/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.env;

import java.io.Serializable;
import java.util.Stack;
import org.ow2.bonita.env.Context;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.ExceptionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Environment
implements Serializable {
    private static final long serialVersionUID = 4160822335317326182L;
    static ThreadLocal<Environment> currentEnvironment = new ThreadLocal();
    static ThreadLocal<Stack<Environment>> currentEnvironmentStack = new ThreadLocal();

    public abstract Object get(String var1);

    public abstract Object get(String var1, String[] var2);

    public abstract <T> T get(Class<T> var1);

    public abstract <T> T get(Class<T> var1, String[] var2);

    public abstract String getUserId();

    public abstract void setUserId(String var1);

    public abstract void close();

    public abstract Context getContext(String var1);

    public abstract void addContext(Context var1);

    public abstract void removeContext(Context var1);

    public abstract ClassLoader getClassLoader();

    public abstract void setClassLoader(ClassLoader var1);

    public static Environment getCurrent() {
        return currentEnvironment.get();
    }

    public static <T> T getFromCurrent(Class<T> type) {
        return Environment.getFromCurrent(type, true);
    }

    public static <T> T getFromCurrent(Class<T> type, boolean required) {
        Environment environment = Environment.getCurrent();
        if (environment == null) {
            if (required) {
                String message = ExceptionManager.getInstance().getFullMessage("bp_E_1", type.getName());
                throw new BonitaRuntimeException(message);
            }
            return null;
        }
        T object = environment.get(type);
        if (object == null) {
            if (required) {
                String message = ExceptionManager.getInstance().getFullMessage("bp_E_2", type.getName());
                throw new BonitaRuntimeException(message);
            }
            return null;
        }
        return object;
    }

    public static Object getFromCurrent(String name) {
        return Environment.getFromCurrent(name, true);
    }

    public static Object getFromCurrent(String name, boolean required) {
        Environment environment = Environment.getCurrent();
        if (environment == null) {
            if (required) {
                String message = ExceptionManager.getInstance().getFullMessage("bp_E_3", name);
                throw new BonitaRuntimeException(message);
            }
            return null;
        }
        Object object = environment.get(name);
        if (object == null) {
            if (required) {
                String message = ExceptionManager.getInstance().getFullMessage("bp_E_4", name);
                throw new BonitaRuntimeException(message);
            }
            return null;
        }
        return object;
    }

    static Stack<Environment> getStack() {
        Stack<Environment> stack = currentEnvironmentStack.get();
        if (stack == null) {
            stack = new Stack();
            currentEnvironmentStack.set(stack);
        }
        return stack;
    }

    protected static synchronized Environment popEnvironment() {
        Environment popped = currentEnvironment.get();
        currentEnvironment.set(null);
        Stack<Environment> stack = currentEnvironmentStack.get();
        if (stack != null && !stack.isEmpty()) {
            currentEnvironment.set(stack.pop());
        }
        return popped;
    }

    protected static synchronized void pushEnvironment(Environment environment) {
        Environment current = currentEnvironment.get();
        if (current != null) {
            Environment.getStack().push(current);
        }
        currentEnvironment.set(environment);
    }

    public abstract boolean isRestrictedApplicationAcces();

    public abstract String getApplicationAccessName();
}

