/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.env;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.env.BonitaEnvironmentParser;
import org.ow2.bonita.env.EnvironmentFactory;
import org.ow2.bonita.env.EnvironmentNotFoundException;
import org.ow2.bonita.env.InvalidEnvironmentException;
import org.ow2.bonita.util.ExceptionManager;
import org.ow2.bonita.util.Misc;

public final class GlobalEnvironmentFactory {
    public static final String DEFAULT_ENVIRONMENT = "bonita-environment.xml";
    public static final String DEFAULT_EMBEDDED_ENVIRONMENT = "bonita-default-environment.xml";
    private static final Logger LOG = Logger.getLogger(GlobalEnvironmentFactory.class.getName());
    private static EnvironmentFactory environmentFactory;
    private static final Object LOCK;

    private GlobalEnvironmentFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EnvironmentFactory getEnvironmentFactory() {
        Object object = LOCK;
        synchronized (object) {
            if (environmentFactory == null) {
                byte[] content;
                URL url;
                String environmentResource;
                block16: {
                    environmentResource = System.getProperty("org.ow2.bonita.environment", DEFAULT_ENVIRONMENT);
                    url = null;
                    try {
                        url = new URL(environmentResource);
                    }
                    catch (MalformedURLException e) {
                        File file = new File(environmentResource);
                        if (!file.exists()) break block16;
                        try {
                            url = file.toURI().toURL();
                        }
                        catch (MalformedURLException e1) {
                            Misc.unreachableStatement();
                        }
                    }
                }
                if (url == null) {
                    url = Thread.currentThread().getContextClassLoader().getResource(environmentResource);
                }
                if (url == null) {
                    url = Thread.currentThread().getContextClassLoader().getResource(DEFAULT_EMBEDDED_ENVIRONMENT);
                    if (url == null) {
                        throw new EnvironmentNotFoundException(environmentResource);
                    }
                    LOG.warning("No environment found, taking default environment from: " + url);
                }
                if (LOG.isLoggable(Level.CONFIG)) {
                    LOG.config("Reading environment configuration from: " + url);
                }
                try {
                    content = Misc.getAllContentFrom(url);
                }
                catch (IOException e) {
                    String message = ExceptionManager.getInstance().getFullMessage("benv_GEF_1", url);
                    throw new InvalidEnvironmentException(message, e);
                }
                String environment = new String(content);
                if (LOG.isLoggable(Level.CONFIG)) {
                    LOG.config("The environment resource " + url + " contains: " + Misc.LINE_SEPARATOR + environment);
                }
                EnvironmentFactory factory = BonitaEnvironmentParser.parseEnvironmentFactoryFromXmlString(environment);
                GlobalEnvironmentFactory.setEnvironmentFactory(factory);
                Runtime.getRuntime().addShutdownHook(new BonitaShutdownHook());
            }
            if (environmentFactory == null) {
                String message = ExceptionManager.getInstance().getFullMessage("benv_GEF_2", new Object[0]);
                throw new InvalidEnvironmentException(message);
            }
            return environmentFactory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setEnvironmentFactory(EnvironmentFactory envFactory) {
        Object object = LOCK;
        synchronized (object) {
            environmentFactory = envFactory;
        }
    }

    public static boolean isInitialized() {
        return environmentFactory != null;
    }

    static {
        LOCK = new Object();
    }

    static class BonitaShutdownHook
    extends Thread {
        public void run() {
            try {
                if (environmentFactory != null) {
                    environmentFactory.close();
                    environmentFactory = null;
                }
            }
            catch (Exception ee) {
                LOG.severe(Misc.getStackTraceFrom(ee));
            }
        }
    }
}

