/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.env.binding;

import org.ow2.bonita.env.binding.WireDescriptorBinding;
import org.ow2.bonita.env.descriptor.ContextTypeRefDescriptor;
import org.ow2.bonita.env.descriptor.EventExecutorDescriptor;
import org.ow2.bonita.env.descriptor.IntegerDescriptor;
import org.ow2.bonita.env.descriptor.ObjectDescriptor;
import org.ow2.bonita.env.descriptor.ReferenceDescriptor;
import org.ow2.bonita.env.descriptor.StringDescriptor;
import org.ow2.bonita.env.operation.InvokeOperation;
import org.ow2.bonita.services.CommandService;
import org.ow2.bonita.util.xml.Parse;
import org.ow2.bonita.util.xml.Parser;
import org.ow2.bonita.util.xml.XmlUtil;
import org.w3c.dom.Element;

public class EventExecutorBinding
extends WireDescriptorBinding {
    public EventExecutorBinding() {
        super("event-executor");
    }

    public Object parse(Element element, Parse parse, Parser parser) {
        EventExecutorDescriptor descriptor = new EventExecutorDescriptor();
        if (element.hasAttribute("command-service")) {
            descriptor.addInjection("commandService", new ReferenceDescriptor(element.getAttribute("command-service")));
        } else {
            descriptor.addInjection("commandService", new ContextTypeRefDescriptor(CommandService.class));
        }
        if (element.hasAttribute("name")) {
            descriptor.addInjection("name", new StringDescriptor(element.getAttribute("name")));
        }
        this.parseIntAttribute(element, "threads", descriptor, "nbrOfThreads", parse);
        this.parseIntAttribute(element, "idle", descriptor, "idleMillis", parse);
        this.parseIntAttribute(element, "idle-min", descriptor, "minimumInterval", parse);
        this.parseIntAttribute(element, "lock", descriptor, "lockMillis", parse);
        if (XmlUtil.attributeBoolean(element, "auto-start", false, parse, true).booleanValue()) {
            InvokeOperation invokeStartOperation = new InvokeOperation();
            invokeStartOperation.setMethodName("start");
            descriptor.addOperation(invokeStartOperation);
            descriptor.setAutoStart(true);
        }
        return descriptor;
    }

    private void parseIntAttribute(Element element, String attributeName, ObjectDescriptor descriptor, String fieldName, Parse parse) {
        Integer intValue = XmlUtil.attributeInteger(element, attributeName, false, parse);
        if (intValue != null) {
            descriptor.addInjection(fieldName, new IntegerDescriptor(intValue));
        }
    }
}

