/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.env.binding;

import java.util.ArrayList;
import java.util.List;
import org.ow2.bonita.env.Descriptor;
import org.ow2.bonita.env.binding.WireDescriptorBinding;
import org.ow2.bonita.env.descriptor.PropertiesDescriptor;
import org.ow2.bonita.env.descriptor.StringDescriptor;
import org.ow2.bonita.util.xml.Parse;
import org.ow2.bonita.util.xml.Parser;
import org.ow2.bonita.util.xml.XmlUtil;
import org.w3c.dom.Element;

public class PropertiesBinding
extends WireDescriptorBinding {
    public PropertiesBinding() {
        super("properties");
    }

    public Object parse(Element element, Parse parse, Parser parser) {
        Boolean isXml;
        PropertiesDescriptor descriptor = new PropertiesDescriptor();
        if (element.hasAttribute("file")) {
            descriptor.setFile(element.getAttribute("file"));
        }
        if (element.hasAttribute("resource")) {
            descriptor.setResource(element.getAttribute("resource"));
        }
        if (element.hasAttribute("url")) {
            descriptor.setUrl(element.getAttribute("url"));
        }
        if ((isXml = XmlUtil.attributeBoolean(element, "is-xml", false, parse)) != null) {
            descriptor.setXml(isXml);
        }
        ArrayList<Descriptor> keyDescriptors = new ArrayList<Descriptor>();
        ArrayList<Descriptor> valueDescriptors = new ArrayList<Descriptor>();
        List<Element> elements = XmlUtil.elements(element);
        if (elements != null) {
            for (Element propertyElement : elements) {
                if ("property".equals(XmlUtil.getTagLocalName(propertyElement))) {
                    String name = XmlUtil.attribute(propertyElement, "name");
                    String value = XmlUtil.attribute(propertyElement, "value");
                    if (name != null && value != null) {
                        keyDescriptors.add(new StringDescriptor(name));
                        valueDescriptors.add(new StringDescriptor(value));
                        continue;
                    }
                    parse.addProblem("property must have name and value attributes: " + XmlUtil.toString(propertyElement));
                    continue;
                }
                parse.addProblem("properties can only contain property elements: " + XmlUtil.toString(propertyElement));
            }
        }
        descriptor.setKeyDescriptors(keyDescriptors);
        descriptor.setValueDescriptors(valueDescriptors);
        return descriptor;
    }
}

