/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.env.binding;

import org.ow2.bonita.env.Descriptor;
import org.ow2.bonita.env.binding.WireOperationBinding;
import org.ow2.bonita.env.operation.PropertyOperation;
import org.ow2.bonita.util.xml.Parse;
import org.ow2.bonita.util.xml.Parser;
import org.ow2.bonita.util.xml.XmlUtil;
import org.w3c.dom.Element;

public class PropertyBinding
extends WireOperationBinding {
    public PropertyBinding() {
        super("property");
    }

    public Object parse(Element element, Parse parse, Parser parser) {
        PropertyOperation propertyOperation = new PropertyOperation();
        if (element.hasAttribute("setter")) {
            propertyOperation.setSetterName(element.getAttribute("setter"));
        } else if (element.hasAttribute("name")) {
            propertyOperation.setPropertyName(element.getAttribute("name"));
        } else {
            parse.addProblem("property must have name or setter attribute: " + XmlUtil.toString(element));
        }
        Element descriptorElement = XmlUtil.element(element);
        if (descriptorElement != null) {
            Descriptor descriptor = (Descriptor)parser.parseElement(descriptorElement, parse, "descriptor");
            if (descriptor != null) {
                propertyOperation.setDescriptor(descriptor);
            } else {
                parse.addProblem("couldn't parse property content element as a value descriptor: " + XmlUtil.toString(element));
            }
        } else {
            parse.addProblem("property must have 1 descriptor element out of " + parser.getBindings().getTagNames("descriptor") + " as content: " + XmlUtil.toString(element));
        }
        return propertyOperation;
    }
}

