/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.env.binding;

import org.ow2.bonita.env.binding.WireInterceptorBinding;
import org.ow2.bonita.env.descriptor.RetryInterceptorDescriptor;
import org.ow2.bonita.util.xml.Parse;
import org.ow2.bonita.util.xml.Parser;
import org.w3c.dom.Element;

public class RetryInterceptorBinding
extends WireInterceptorBinding {
    public RetryInterceptorBinding() {
        super("retry-interceptor");
    }

    public Object parse(Element element, Parse parse, Parser parser) {
        RetryInterceptorDescriptor retryInterceptorDescriptor = new RetryInterceptorDescriptor();
        if (element.hasAttribute("retries")) {
            String retriesText = element.getAttribute("retries");
            try {
                int retries = Integer.parseInt(retriesText);
                retryInterceptorDescriptor.setRetries(retries);
            }
            catch (NumberFormatException e) {
                parse.addProblem("couldn't parse retries " + retriesText);
            }
        }
        if (element.hasAttribute("delay")) {
            String delayText = element.getAttribute("delay");
            try {
                long delay = Long.parseLong(delayText);
                retryInterceptorDescriptor.setDelay(delay);
            }
            catch (NumberFormatException e) {
                parse.addProblem("couldn't parse delay " + delayText);
            }
        }
        if (element.hasAttribute("delay-factor")) {
            String delayFactorText = element.getAttribute("delay-factor");
            try {
                long delayFactor = Long.parseLong(delayFactorText);
                retryInterceptorDescriptor.setDelayFactor(delayFactor);
            }
            catch (NumberFormatException e) {
                parse.addProblem("couldn't parse delay-factor " + delayFactorText);
            }
        }
        return retryInterceptorDescriptor;
    }
}

