/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.env.descriptor;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.env.Environment;
import org.ow2.bonita.env.WireContext;
import org.ow2.bonita.env.WireException;
import org.ow2.bonita.env.descriptor.AbstractDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvironmentTypeRefDescriptor
extends AbstractDescriptor {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(EnvironmentTypeRefDescriptor.class.getName());
    Class<?> type;

    public EnvironmentTypeRefDescriptor(Class<?> type) {
        this.type = type;
    }

    @Override
    public Object construct(WireContext wireContext) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("looking up " + this.type + " by type in environment");
        }
        if (this.type != null) {
            Environment environment = Environment.getCurrent();
            if (environment == null) {
                throw new WireException("no environment to search an object of type " + this.type.getName());
            }
            return environment.get(this.type);
        }
        return null;
    }
}

