/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.env.descriptor;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.env.WireContext;
import org.ow2.bonita.env.descriptor.ObjectDescriptor;
import org.ow2.bonita.runtime.event.EventExecutor;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.ExceptionManager;
import org.ow2.bonita.util.Listener;

public class EventExecutorDescriptor
extends ObjectDescriptor {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(EventExecutorDescriptor.class.getName());
    private boolean autoStart = false;

    public EventExecutorDescriptor() {
        super(EventExecutor.class.getName());
    }

    public Object construct(WireContext wireContext) {
        EventExecutor eventExecutor = (EventExecutor)super.construct(wireContext);
        if (this.autoStart) {
            wireContext.addListener(new EventExecutorStopper(eventExecutor));
        }
        return eventExecutor;
    }

    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    public static class EventExecutorStopper
    implements Listener {
        EventExecutor eventExecutor;

        public EventExecutorStopper(EventExecutor eventExecutor) {
            this.eventExecutor = eventExecutor;
        }

        public void event(Object source, String eventName, Object info) {
            if ("close".equals(eventName)) {
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.info("stopping EventExecutor");
                }
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    String message = ExceptionManager.getInstance().getFullMessage("bp_JED_1", new Object[0]);
                    throw new BonitaRuntimeException(message);
                }
                this.eventExecutor.stop(true);
            }
        }
    }
}

