/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.env.descriptor;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.ow2.bonita.env.Descriptor;
import org.ow2.bonita.env.WireContext;
import org.ow2.bonita.env.WireDefinition;
import org.ow2.bonita.env.WireException;
import org.ow2.bonita.env.descriptor.AbstractDescriptor;
import org.ow2.bonita.util.ExceptionManager;
import org.ow2.bonita.util.Listener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateSessionFactoryDescriptor
extends AbstractDescriptor {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(HibernateSessionFactoryDescriptor.class.getName());
    String configurationName;
    Descriptor configurationDescriptor;

    @Override
    public Object construct(WireContext wireContext) {
        Configuration configuration = null;
        configuration = this.configurationName != null ? (Configuration)wireContext.get(this.configurationName) : (this.configurationDescriptor != null ? (Configuration)wireContext.create(this.configurationDescriptor, false) : wireContext.get(Configuration.class));
        if (configuration == null) {
            String message = ExceptionManager.getInstance().getFullMessage("bp_HSF_1", new Object[0]);
            throw new WireException(message);
        }
        SessionFactory sessionFactory = configuration.buildSessionFactory();
        wireContext.addListener(new SessionFactoryCloser(sessionFactory));
        return sessionFactory;
    }

    @Override
    public Class<?> getType(WireDefinition wireDefinition) {
        return SessionFactory.class;
    }

    public void setConfigurationName(String configurationName) {
        this.configurationName = configurationName;
    }

    public void setConfigurationDescriptor(Descriptor configurationDescriptor) {
        this.configurationDescriptor = configurationDescriptor;
    }

    public static class SessionFactoryCloser
    implements Listener {
        SessionFactory sessionFactory;

        public SessionFactoryCloser(SessionFactory sessionFactory) {
            this.sessionFactory = sessionFactory;
        }

        public void event(Object source, String eventName, Object info) {
            if ("close".equals(eventName)) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("closing hibernate session factory");
                }
                this.sessionFactory.close();
            }
        }
    }
}

