/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.env.operation;

import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.env.Descriptor;
import org.ow2.bonita.env.Environment;
import org.ow2.bonita.env.WireContext;
import org.ow2.bonita.env.WireDefinition;
import org.ow2.bonita.env.WireException;
import org.ow2.bonita.env.descriptor.ArgDescriptor;
import org.ow2.bonita.env.operation.MethodInvokerListener;
import org.ow2.bonita.env.operation.Operation;
import org.ow2.bonita.util.ExceptionManager;
import org.ow2.bonita.util.FilterListener;
import org.ow2.bonita.util.Listener;
import org.ow2.bonita.util.Observable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubscribeOperation
implements Operation {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(SubscribeOperation.class.getName());
    String contextName = null;
    List<String> eventNames = null;
    boolean wireEvents = false;
    List<String> objectNames = null;
    String methodName = null;
    List<ArgDescriptor> argDescriptors = null;

    @Override
    public void apply(Object target, WireContext targetWireContext) {
        WireContext wireContext;
        Listener listener;
        block21: {
            listener = null;
            if (this.methodName != null) {
                listener = new MethodInvokerListener(this.methodName, this.argDescriptors, targetWireContext, target);
            } else {
                try {
                    listener = (Listener)target;
                }
                catch (ClassCastException e) {
                    String message = ExceptionManager.getInstance().getFullMessage("bp_SO_1", target);
                    throw new WireException(message);
                }
            }
            if (this.eventNames != null && !this.eventNames.isEmpty()) {
                listener = new FilterListener(listener, this.eventNames);
            }
            wireContext = null;
            if (this.contextName != null) {
                Environment environment = Environment.getCurrent();
                if (environment != null) {
                    try {
                        wireContext = (WireContext)environment.getContext(this.contextName);
                        if (wireContext == null) {
                            String message = ExceptionManager.getInstance().getFullMessage("bp_SO_2", this.contextName);
                            throw new WireException(message);
                        }
                        break block21;
                    }
                    catch (ClassCastException e) {
                        String message = ExceptionManager.getInstance().getFullMessage("bp_SO_3", this.contextName);
                        throw new WireException(message, e);
                    }
                }
                String message = ExceptionManager.getInstance().getFullMessage("bp_SO_4", this.contextName, targetWireContext);
                throw new WireException(message);
            }
            wireContext = targetWireContext;
        }
        if (this.wireEvents) {
            WireDefinition wireDefinition = wireContext.getWireDefinition();
            if (this.objectNames != null) {
                for (String objectName : this.objectNames) {
                    Descriptor descriptor = wireDefinition.getDescriptor(objectName);
                    this.subscribe(listener, descriptor);
                }
            } else {
                HashSet<Descriptor> descriptors = new HashSet<Descriptor>(wireDefinition.getDescriptors().values());
                for (Descriptor descriptor : descriptors) {
                    this.subscribe(listener, descriptor);
                }
            }
        } else if (this.objectNames != null && !this.objectNames.isEmpty()) {
            for (String objectName : this.objectNames) {
                Object object = wireContext.get(objectName);
                if (object == null) {
                    String message = ExceptionManager.getInstance().getFullMessage("bp_SO_5", wireContext.getName(), objectName);
                    throw new WireException(message);
                }
                if (!(object instanceof Observable)) {
                    String message = ExceptionManager.getInstance().getFullMessage("bp_SO_6", wireContext.getName(), objectName, object.getClass().getName(), Observable.class.getName());
                    throw new WireException(message);
                }
                this.subscribe(listener, (Observable)object);
            }
        } else {
            this.subscribe(listener, wireContext);
        }
    }

    void subscribe(Listener listener, Observable observable) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("adding " + listener + " as listener to " + observable);
        }
        observable.addListener(listener);
    }

    public List<ArgDescriptor> getArgDescriptors() {
        return this.argDescriptors;
    }

    public void setArgDescriptors(List<ArgDescriptor> argDescriptors) {
        this.argDescriptors = argDescriptors;
    }

    public List<String> getEventNames() {
        return this.eventNames;
    }

    public void setEventNames(List<String> eventNames) {
        this.eventNames = eventNames;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getContextName() {
        return this.contextName;
    }

    public void setContextName(String contextName) {
        this.contextName = contextName;
    }

    public List<String> getObjectNames() {
        return this.objectNames;
    }

    public void setObjectNames(List<String> objectNames) {
        this.objectNames = objectNames;
    }

    public boolean isWireEvents() {
        return this.wireEvents;
    }

    public void setWireEvents(boolean wireEvents) {
        this.wireEvents = wireEvents;
    }
}

