/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.expression;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.ow2.bonita.expression.InvalidExpressionException;
import org.ow2.bonita.expression.KeyWord;
import org.ow2.bonita.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BooleanExpression {
    private static final String JAVA_FIELD_PATTERN = "^[a-z][a-zA-Z0-9]*$";
    private List<String> tokens;

    public BooleanExpression(String expression) throws InvalidExpressionException {
        Misc.checkArgsNotNull(expression);
        this.tokens = new Vector<String>();
        this.checkExpression(BooleanExpression.formatExpression(expression));
    }

    private void checkExpression(String expression) throws InvalidExpressionException {
        if ((expression = expression.trim()).length() == 0) {
            throw new InvalidExpressionException(expression, "The expression cannot be an empty String");
        }
        if (expression.startsWith(KeyWord.LEFT_PARENTHESIS.value()) && BooleanExpression.isABloc(expression)) {
            this.tokens.add(KeyWord.LEFT_PARENTHESIS.value());
            this.checkExpression(expression.substring(1, expression.length() - 1));
            this.tokens.add(KeyWord.RIGHT_PARENTHESIS.value());
        } else if (BooleanExpression.isField(expression)) {
            if (!BooleanExpression.isConformField(expression)) {
                throw new InvalidExpressionException(expression, "The field is not conform to expression ^[a-z][a-zA-Z0-9]*$");
            }
            this.tokens.add(expression);
        } else {
            String not = Character.toString(expression.charAt(0));
            if (KeyWord.NOT.value().equals(not)) {
                this.tokens.add(KeyWord.NOT.value());
                this.checkExpression(expression.substring(1));
            } else {
                List<String> expressions = BooleanExpression.getExpressionsFromBinaryOperation(expression);
                String operator = expressions.get(0);
                String left = expressions.get(1).trim();
                String right = expressions.get(2).trim();
                if (left.length() == 0) {
                    throw new InvalidExpressionException(expression, "The left expression is missing");
                }
                if (operator.length() == 0) {
                    throw new InvalidExpressionException(expression, "An operator is missing");
                }
                if (right.length() == 0) {
                    throw new InvalidExpressionException(expression, "The right expression is missing");
                }
                if (operator.equals(KeyWord.AND.value()) || operator.equals(KeyWord.OR.value()) || operator.equals(KeyWord.XOR.value())) {
                    this.checkExpression(left);
                    this.tokens.add(operator);
                    this.checkExpression(right);
                } else {
                    throw new InvalidExpressionException(expression, "Unknown operator : \"" + operator + "\"");
                }
            }
        }
    }

    private static boolean isABloc(String expression) throws InvalidExpressionException {
        boolean bloc = false;
        if (expression.startsWith(KeyWord.LEFT_PARENTHESIS.value())) {
            int index;
            int count = 1;
            for (index = 1; index < expression.length() && count > 0; ++index) {
                char current = expression.charAt(index);
                if (KeyWord.LEFT_PARENTHESIS.value().equals(String.valueOf(current))) {
                    ++count;
                    continue;
                }
                if (!KeyWord.RIGHT_PARENTHESIS.value().equals(String.valueOf(current))) continue;
                --count;
            }
            if (count > 0) {
                throw new InvalidExpressionException(expression, "A right parenthesis is missing");
            }
            if (index == expression.length()) {
                bloc = true;
            }
        }
        return bloc;
    }

    private static List<String> getExpressionsFromBinaryOperation(String expression) throws InvalidExpressionException {
        char current;
        int i;
        ArrayList<String> exp = new ArrayList<String>();
        int count = 0;
        int length = expression.length();
        if (expression.startsWith(KeyWord.LEFT_PARENTHESIS.value())) {
            count = 1;
            for (i = 1; i < length && count > 0; ++i) {
                current = expression.charAt(i);
                if (KeyWord.LEFT_PARENTHESIS.value().equals(String.valueOf(current))) {
                    ++count;
                    continue;
                }
                if (!KeyWord.RIGHT_PARENTHESIS.value().equals(String.valueOf(current))) continue;
                --count;
            }
            if (count > 0) {
                throw new InvalidExpressionException(expression, "A right parenthesis is missing");
            }
        } else {
            String oper = "";
            boolean op = false;
            for (i = 0; i < length - 1 && !op; ++i) {
                current = expression.charAt(i);
                oper = String.valueOf(current);
                if (!oper.equals(KeyWord.AND.value()) && !oper.equals(KeyWord.OR.value()) && !oper.equals(KeyWord.XOR.value())) continue;
                op = true;
            }
            if (!op) {
                throw new InvalidExpressionException(expression, "Operator not valid");
            }
            --i;
        }
        String left = expression.substring(0, i);
        String tail = expression.substring(i);
        String operator = BooleanExpression.getOperator(tail);
        int cut = tail.indexOf(operator);
        String right = tail.substring(cut + operator.length(), tail.length());
        exp.add(operator);
        exp.add(left);
        exp.add(right);
        return exp;
    }

    private static String getOperator(String expression) {
        expression = expression.trim();
        String operator = expression.substring(0, 1);
        if (expression.startsWith(KeyWord.LEFT_PARENTHESIS.value()) || expression.startsWith(KeyWord.NOT.value())) {
            operator = "";
        } else if (!(operator.equals(KeyWord.AND.value()) || operator.equals(KeyWord.OR.value()) || operator.equals(KeyWord.XOR.value()))) {
            boolean end = false;
            char c = 'a';
            operator = "";
            for (int index = 0; index < expression.length() && !end; ++index) {
                c = expression.charAt(index);
                operator = operator + c;
                if (!Character.isWhitespace(c)) continue;
                end = true;
            }
        }
        return operator;
    }

    private static boolean isField(String expression) {
        char ch = ' ';
        boolean field = true;
        for (int i = 0; i < expression.length() && field; ++i) {
            ch = expression.charAt(i);
            if (Character.isJavaIdentifierPart(ch)) continue;
            field = false;
        }
        return field;
    }

    private static boolean isConformField(String expression) {
        return expression.matches(JAVA_FIELD_PATTERN);
    }

    private static String formatExpression(String expression) {
        expression = expression.replaceAll("\t", " ");
        expression = expression.replaceAll("\n", " ");
        return expression.replaceAll("\r", " ");
    }

    public List<String> getTokens() {
        return this.tokens;
    }
}

