/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.expression;

import java.util.List;
import java.util.Map;
import org.ow2.bonita.expression.BooleanExpression;
import org.ow2.bonita.expression.InvalidExpressionException;
import org.ow2.bonita.expression.KeyWord;
import org.ow2.bonita.expression.VariableNotFoundException;
import org.ow2.bonita.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionEvaluator {
    private List<String> list;

    public ExpressionEvaluator(String expression) throws InvalidExpressionException {
        BooleanExpression booleanExpression = new BooleanExpression(expression);
        this.list = booleanExpression.getTokens();
    }

    public boolean evaluate(Map<String, Boolean> variables) throws VariableNotFoundException {
        Misc.checkArgsNotNull(variables);
        for (Map.Entry<String, Boolean> entry : variables.entrySet()) {
            String key = entry.getKey();
            for (int i = 0; i < this.list.size(); ++i) {
                String token = this.list.get(i);
                if (!token.equals(key)) continue;
                this.list.set(i, entry.getValue().toString());
            }
        }
        for (String element : this.list) {
            if (!this.isAField(element) || element.equals(KeyWord.FALSE.value()) || element.equals(KeyWord.TRUE.value())) continue;
            throw new VariableNotFoundException(element);
        }
        return this.evalBooleanExpressionInParentheses(this.list);
    }

    private boolean isAField(String element) {
        return element.matches("^[a-zA-Z_0-9]*$");
    }

    private boolean evalBooleanExpressionInParentheses(List<String> tokens) {
        if (tokens.contains(KeyWord.LEFT_PARENTHESIS.value())) {
            int fromIndex = tokens.indexOf(KeyWord.LEFT_PARENTHESIS.value());
            int toIndex = this.getEndExpressionInParentheses(tokens, fromIndex);
            List<String> toks = tokens.subList(fromIndex + 1, toIndex);
            boolean eval = this.evalBooleanExpressionInParentheses(toks);
            tokens.set(fromIndex, String.valueOf(eval));
            tokens.remove(fromIndex + 1);
            tokens.remove(fromIndex + 1);
            return this.evalBooleanExpressionInParentheses(tokens);
        }
        return this.evalBooleanExpression(tokens);
    }

    private int getEndExpressionInParentheses(List<String> tokens, int fromIndex) {
        int index;
        int count = 1;
        for (index = fromIndex + 1; index < tokens.size() && count > 0; ++index) {
            String token = tokens.get(index);
            if (token.equals(KeyWord.LEFT_PARENTHESIS.value())) {
                ++count;
                continue;
            }
            if (!token.equals(KeyWord.RIGHT_PARENTHESIS.value())) continue;
            --count;
        }
        return index - 1;
    }

    private boolean evalBooleanExpression(List<String> tokens) {
        if (tokens.size() == 1) {
            return Boolean.valueOf(tokens.get(0));
        }
        if (tokens.contains(KeyWord.NOT.value())) {
            boolean not;
            int i;
            int c = i = tokens.indexOf(KeyWord.NOT.value());
            int count = 0;
            while (tokens.get(c).equals(KeyWord.NOT.value())) {
                ++count;
                ++c;
            }
            boolean bl = not = Boolean.valueOf(tokens.get(c)) == false;
            if (c % 2 == 0) {
                not = !not;
            }
            tokens.set(i, String.valueOf(not));
            for (int j = 0; j < count; ++j) {
                tokens.remove(i + 1);
            }
            return this.evalBooleanExpression(tokens);
        }
        if (tokens.contains(KeyWord.AND.value())) {
            int i = tokens.indexOf(KeyWord.AND.value());
            boolean and = Boolean.valueOf(tokens.get(i - 1)) & Boolean.valueOf(tokens.get(i + 1));
            tokens.set(i - 1, String.valueOf(and));
            tokens.remove(i);
            tokens.remove(i);
            return this.evalBooleanExpression(tokens);
        }
        if (tokens.contains(KeyWord.XOR.value())) {
            int i = tokens.indexOf(KeyWord.XOR.value());
            boolean xor = Boolean.valueOf(tokens.get(i - 1)) ^ Boolean.valueOf(tokens.get(i + 1));
            tokens.set(i - 1, String.valueOf(xor));
            tokens.remove(i);
            tokens.remove(i);
            return this.evalBooleanExpression(tokens);
        }
        if (tokens.contains(KeyWord.OR.value())) {
            int i = tokens.indexOf(KeyWord.OR.value());
            boolean or = Boolean.valueOf(tokens.get(i - 1)) | Boolean.valueOf(tokens.get(i + 1));
            tokens.set(i - 1, String.valueOf(or));
            tokens.remove(i);
            tokens.remove(i);
            return this.evalBooleanExpression(tokens);
        }
        return this.evalBooleanExpression(tokens);
    }
}

