/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.env.Authentication;
import org.ow2.bonita.env.Environment;
import org.ow2.bonita.env.EnvironmentFactory;
import org.ow2.bonita.env.GlobalEnvironmentFactory;
import org.ow2.bonita.env.InvalidEnvironmentException;
import org.ow2.bonita.facade.exception.BonitaInternalException;
import org.ow2.bonita.facade.exception.BonitaWrapperException;
import org.ow2.bonita.facade.internal.InternalManagementAPI;
import org.ow2.bonita.facade.internal.InternalWebAPI;
import org.ow2.bonita.services.CommandService;
import org.ow2.bonita.util.BonitaException;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.Command;
import org.ow2.bonita.util.EnvTool;
import org.ow2.bonita.util.ExceptionManager;

public class APIInterceptor
implements InvocationHandler,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static final Logger LOG = Logger.getLogger(APIInterceptor.class.getName());
    private final Object api;

    public APIInterceptor(Object api) {
        this.api = api;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws BonitaException {
        try {
            if (Environment.getCurrent() != null) {
                return new APIInterceptorCommand(method, args, true).execute(Environment.getCurrent());
            }
            EnvironmentFactory envFactory = GlobalEnvironmentFactory.getEnvironmentFactory();
            return envFactory.get(CommandService.class).execute(new APIInterceptorCommand(method, args, false));
        }
        catch (BonitaRuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof BonitaException) {
                throw (BonitaException)cause;
            }
            if (e instanceof InvalidEnvironmentException) {
                throw e;
            }
            if (e instanceof BonitaWrapperException) {
                throw (RuntimeException)e.getCause();
            }
            throw e;
        }
        catch (BonitaException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw BonitaInternalException.build(e);
        }
        catch (Exception t) {
            String message = ExceptionManager.getInstance().getFullMessage("bai_APII_2", t);
            throw new BonitaInternalException(message, t);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class APIInterceptorCommand
    implements Command<Object> {
        private static final long serialVersionUID = 6293853276365124717L;
        private final transient Method m;
        private final Object[] args;
        private final boolean isSecuritySet;

        public APIInterceptorCommand(Method m, Object[] args, boolean isSecuritySet) {
            this.args = args;
            this.m = m;
            this.isSecuritySet = isSecuritySet;
            if (LOG.isLoggable(Level.FINE)) {
                StringBuffer sb = new StringBuffer();
                sb.append("Creating APIInterceptorCommand: " + this + ". Method: " + m + ", isSecuritySet:" + isSecuritySet);
                if (args != null) {
                    for (Object arg : args) {
                        sb.append(" - Arg: " + arg);
                    }
                } else {
                    sb.append(" Args: null.");
                }
                LOG.fine(sb.toString());
            }
        }

        @Override
        public Object execute(Environment env) throws Exception {
            if (!(this.isSecuritySet || InternalManagementAPI.class.equals(this.m.getDeclaringClass()) && InternalManagementAPI.class.getMethod("checkUserCredentials", String.class, String.class).equals(this.m) || InternalWebAPI.class.equals(this.m.getDeclaringClass()) && InternalWebAPI.class.getMethod("getIdentityKeyFromTemporaryToken", String.class).equals(this.m))) {
                Authentication.setUserId(EnvTool.getBonitaSecurityContext().getUser());
            }
            try {
                if (LOG.isLoggable(Level.FINE)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("Executing APIInterceptorCommand: " + this + " on api: " + APIInterceptor.this.api + ". Env: " + env);
                    LOG.fine(sb.toString());
                }
                return this.m.invoke(APIInterceptor.this.api, this.args);
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getCause();
                if (t instanceof Exception) {
                    throw (Exception)t;
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                String message = ExceptionManager.getInstance().getFullMessage("bai_APII_1", t);
                throw new BonitaInternalException(message, t);
            }
        }
    }
}

