/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.facade.BonitaSecurityContext;
import org.ow2.bonita.facade.EJB2SecurityContext;
import org.ow2.bonita.facade.EJB3SecurityContext;
import org.ow2.bonita.facade.StandardSecurityContext;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.ExceptionManager;

public class AutoDetectSecurityContext
implements BonitaSecurityContext {
    private static final Logger LOG = Logger.getLogger(AutoDetectSecurityContext.class.getName());

    public String getUser() {
        String user;
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Using AutoDetectSecurityContext to get the current logged user.");
        }
        if ((user = this.getUser(new EJB3SecurityContext())) == null) {
            user = this.getUser(new EJB2SecurityContext());
        }
        if (user == null) {
            user = this.getUser(new StandardSecurityContext());
        }
        if (user == null) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("No user found from " + AutoDetectSecurityContext.class);
            }
            String message = ExceptionManager.getInstance().getFullMessage("bsi_ADSC_1", new Object[0]);
            throw new BonitaRuntimeException(message);
        }
        return user;
    }

    private String getUser(BonitaSecurityContext securityContext) {
        try {
            return securityContext.getUser();
        }
        catch (Throwable t) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("No user found from " + securityContext.getClass());
            }
            return null;
        }
    }
}

