/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade;

import java.lang.reflect.Method;
import java.security.Principal;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.facade.BonitaSecurityContext;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.Misc;

public class EJB3SecurityContext
implements BonitaSecurityContext {
    private static final Logger LOG = Logger.getLogger(EJB3SecurityContext.class.getName());

    public String getUser() {
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Looking for user in " + EJB3SecurityContext.class);
        }
        try {
            Object ejbContext = Misc.lookup("java:comp/EJBContext", null);
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Looking for user in " + EJB3SecurityContext.class + ", ejbContext=" + ejbContext);
            }
            Class<?> ejbContextClass = Class.forName("javax.ejb.EJBContext");
            Method getCallerPrincipalMethod = ejbContextClass.getMethod("getCallerPrincipal", new Class[0]);
            Principal principal = (Principal)getCallerPrincipalMethod.invoke(ejbContext, new Object[0]);
            String user = principal.getName();
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("User found in " + EJB3SecurityContext.class + ": " + user);
            }
            return user;
        }
        catch (Exception e) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Exception caught while looking for user in " + EJB3SecurityContext.class + ": " + e.getMessage());
            }
            throw new BonitaRuntimeException(e);
        }
    }
}

