/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.ow2.bonita.facade.def.element.BusinessArchive;
import org.ow2.bonita.facade.def.majorElement.ProcessDefinition;
import org.ow2.bonita.facade.exception.DeploymentException;
import org.ow2.bonita.facade.exception.ProcessNotFoundException;
import org.ow2.bonita.facade.exception.RuleAlreadyExistsException;
import org.ow2.bonita.facade.exception.RuleNotFoundException;
import org.ow2.bonita.facade.exception.UndeletableInstanceException;
import org.ow2.bonita.facade.exception.UndeletableProcessException;
import org.ow2.bonita.facade.exception.UserNotFoundException;
import org.ow2.bonita.facade.privilege.PrivilegePolicy;
import org.ow2.bonita.facade.privilege.Rule;
import org.ow2.bonita.facade.uuid.AbstractUUID;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface ManagementAPI {
    public ProcessDefinition deploy(BusinessArchive var1) throws DeploymentException;

    public void deployJar(String var1, byte[] var2) throws DeploymentException;

    public void removeJar(String var1) throws DeploymentException;

    public void deleteProcess(ProcessDefinitionUUID var1) throws ProcessNotFoundException, UndeletableProcessException, UndeletableInstanceException;

    public void deleteAllProcesses() throws UndeletableInstanceException, UndeletableProcessException;

    public String getLoggedUser();

    public void addMetaData(String var1, String var2);

    public String getMetaData(String var1);

    public void deleteMetaData(String var1);

    public void disable(ProcessDefinitionUUID var1) throws DeploymentException;

    public void enable(ProcessDefinitionUUID var1) throws DeploymentException;

    public void archive(ProcessDefinitionUUID var1) throws DeploymentException;

    public void disable(Collection<ProcessDefinitionUUID> var1) throws DeploymentException;

    public void enable(Collection<ProcessDefinitionUUID> var1) throws DeploymentException;

    public void archive(Collection<ProcessDefinitionUUID> var1) throws DeploymentException;

    public void delete(Collection<ProcessDefinitionUUID> var1) throws DeploymentException;

    public boolean isUserAdmin(String var1) throws UserNotFoundException;

    public boolean checkUserCredentials(String var1, String var2);

    public Set<String> getAvailableJars();

    public <E extends AbstractUUID> Rule createRule(String var1, String var2, String var3, Set<E> var4, Rule.RuleType var5) throws RuleAlreadyExistsException;

    public void deleteRule(String var1) throws RuleNotFoundException;

    public <E extends AbstractUUID> void addExceptionsToRule(String var1, Set<E> var2) throws RuleNotFoundException;

    public <E extends AbstractUUID> void removeExceptionsFromRule(String var1, Set<E> var2) throws RuleNotFoundException;

    public void updateRule(String var1, Rule var2) throws RuleNotFoundException;

    public Rule getRule(String var1) throws RuleNotFoundException;

    public void applyRulesToEntity(String var1, Set<String> var2) throws RuleNotFoundException;

    public void removeRulesFromEntity(String var1, Set<String> var2) throws RuleNotFoundException;

    public void applySameRulesToOtherEntities(String var1, Set<String> var2);

    public Set<Rule> getRules();

    public List<Rule> getRules(Rule.RuleType var1, int var2, int var3);

    public Set<Rule> getRules(Set<String> var1) throws RuleNotFoundException;

    public Set<Rule> getApplicableRules(String var1, Rule.RuleType var2);

    public Set<Rule> getAllApplicableRules(String var1);

    public PrivilegePolicy getDefaultPolicy();

    public void setDefaultPolicy(PrivilegePolicy var1, boolean var2);

    public long getNumberOfRules(Rule.RuleType var1);
}

