/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.def;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.ow2.bonita.definition.activity.AbstractActivity;
import org.ow2.bonita.definition.activity.AutomaticActivity;
import org.ow2.bonita.definition.activity.ExternalActivity;
import org.ow2.bonita.definition.activity.ReceiveEvent;
import org.ow2.bonita.definition.activity.SendEvents;
import org.ow2.bonita.definition.activity.SubFlow;
import org.ow2.bonita.definition.activity.Task;
import org.ow2.bonita.definition.activity.Timer;
import org.ow2.bonita.facade.def.InternalActivityDefinition;
import org.ow2.bonita.facade.def.element.ConnectorDefinition;
import org.ow2.bonita.facade.def.element.DeadlineDefinition;
import org.ow2.bonita.facade.def.element.HookDefinition;
import org.ow2.bonita.facade.def.element.OutgoingEventDefinition;
import org.ow2.bonita.facade.def.element.impl.ConnectorDefinitionImpl;
import org.ow2.bonita.facade.def.element.impl.ConnectorParameters;
import org.ow2.bonita.facade.def.element.impl.OutgoingEventDefinitionImpl;
import org.ow2.bonita.facade.def.majorElement.ActivityDefinition;
import org.ow2.bonita.facade.def.majorElement.DataFieldDefinition;
import org.ow2.bonita.facade.def.majorElement.ParticipantDefinition;
import org.ow2.bonita.facade.def.majorElement.ProcessDefinition;
import org.ow2.bonita.facade.def.majorElement.impl.DataFieldDefinitionImpl;
import org.ow2.bonita.facade.def.majorElement.impl.ProcessDefinitionImpl;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.runtime.ClassDataLoader;
import org.ow2.bonita.type.Variable;
import org.ow2.bonita.util.ProcessUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalProcessDefinition
extends ProcessDefinitionImpl {
    private static final long serialVersionUID = 7746264410679050386L;
    protected String labelOrName;

    protected InternalProcessDefinition() {
    }

    public InternalProcessDefinition(ProcessDefinition process) {
        super(process);
        this.activities = new HashSet();
        for (ActivityDefinition activity : process.getActivities()) {
            this.activities.add(new InternalActivityDefinition(activity, InternalProcessDefinition.createBehaviour(activity)));
        }
        this.labelOrName = process.getLabel() != null ? process.getLabel() : process.getName();
    }

    public static InternalProcessDefinition buildFromClientProcess(ProcessDefinition process) {
        InternalProcessDefinition internalProcess = new InternalProcessDefinition(process);
        for (DataFieldDefinition dataField : internalProcess.getDataFields()) {
            if (dataField.getInitialValue() == null) continue;
            ((DataFieldDefinitionImpl)dataField).setInitialValue(ProcessUtil.createVariable(process.getUUID(), dataField.getName(), dataField.getInitialValue()));
        }
        for (ActivityDefinition activity : internalProcess.getActivities()) {
            for (DataFieldDefinition dataFieldDefinition : activity.getDataFields()) {
                if (dataFieldDefinition.getInitialValue() == null) continue;
                ((DataFieldDefinitionImpl)dataFieldDefinition).setInitialValue(ProcessUtil.createVariable(process.getUUID(), dataFieldDefinition.getName(), dataFieldDefinition.getInitialValue()));
            }
        }
        for (ParticipantDefinition participant : internalProcess.getParticipants()) {
            InternalProcessDefinition.setConnectorParameters(process.getUUID(), participant.getRoleMapper());
        }
        for (HookDefinition connector : internalProcess.getConnectors()) {
            InternalProcessDefinition.setConnectorParameters(process.getUUID(), connector);
        }
        for (ActivityDefinition activity : internalProcess.getActivities()) {
            for (DeadlineDefinition deadlineDefinition : activity.getDeadlines()) {
                InternalProcessDefinition.setConnectorParameters(process.getUUID(), deadlineDefinition);
            }
            for (HookDefinition hookDefinition : activity.getConnectors()) {
                InternalProcessDefinition.setConnectorParameters(process.getUUID(), hookDefinition);
            }
            if (activity.getIncomingEvent() != null) {
                for (ConnectorDefinition connectorDefinition : activity.getIncomingEvent().getConnectors()) {
                    InternalProcessDefinition.setConnectorParameters(process.getUUID(), connectorDefinition);
                }
            }
            for (OutgoingEventDefinition outgoingEventDefinition : activity.getOutgoingEvents()) {
                OutgoingEventDefinitionImpl outgoingImpl = (OutgoingEventDefinitionImpl)outgoingEventDefinition;
                for (Map.Entry<String, Object> parameter : outgoingEventDefinition.getParameters().entrySet()) {
                    String key = parameter.getKey();
                    Object value = parameter.getValue();
                    outgoingImpl.addParameter(key, ProcessUtil.createVariable(process.getUUID(), key, value));
                }
                outgoingImpl.removeClientParameters();
            }
            InternalProcessDefinition.setConnectorParameters(process.getUUID(), activity.getMultiInstantiationDefinition());
            InternalProcessDefinition.setConnectorParameters(process.getUUID(), activity.getFilter());
            InternalProcessDefinition.setConnectorParameters(process.getUUID(), activity.getMultipleInstancesInstantiator());
            InternalProcessDefinition.setConnectorParameters(process.getUUID(), activity.getMultipleInstancesJoinChecker());
        }
        return internalProcess;
    }

    public String getLabelOrName() {
        return this.labelOrName;
    }

    @Override
    public InternalActivityDefinition getActivity(String name) {
        return (InternalActivityDefinition)super.getActivity(name);
    }

    private static ExternalActivity createBehaviour(ActivityDefinition activity) {
        String activityName = activity.getName();
        AbstractActivity abstractActivity = null;
        if (activity.isSubflow()) {
            abstractActivity = new SubFlow(activityName);
        } else if (activity.isTimer()) {
            abstractActivity = new Timer(activityName);
        } else if (activity.isAutomatic()) {
            abstractActivity = new AutomaticActivity(activityName);
        } else if (activity.isTask()) {
            abstractActivity = new Task(activityName);
        } else if (activity.isSendEvents()) {
            abstractActivity = new SendEvents(activityName);
        } else if (activity.isReceiveEvent()) {
            abstractActivity = new ReceiveEvent(activityName);
        }
        return abstractActivity;
    }

    private static void setConnectorParameters(ProcessDefinitionUUID processUUID, ConnectorDefinition connector) {
        if (connector != null) {
            ConnectorDefinitionImpl connectorImpl = (ConnectorDefinitionImpl)connector;
            for (Map.Entry<String, Object[]> entries : connector.getParameters().entrySet()) {
                String key = entries.getKey();
                Object[] parameters = entries.getValue();
                ArrayList<Variable> variables = new ArrayList<Variable>();
                for (Object parameter : parameters) {
                    variables.add(ProcessUtil.createVariable(processUUID, key, parameter));
                }
                connectorImpl.addParameter(key, new ConnectorParameters(key, variables));
            }
            connectorImpl.removeClientParameters();
        }
    }

    @Override
    protected ClassLoader getClassLoader(ProcessDefinitionUUID processUUID) {
        return ClassDataLoader.getProcessClassLoader(processUUID);
    }

    public Map<String, InternalActivityDefinition> getInternalInitialActivities() {
        HashMap<String, InternalActivityDefinition> result = new HashMap<String, InternalActivityDefinition>();
        for (ActivityDefinition activity : this.getInitialActivities().values()) {
            result.put(activity.getName(), (InternalActivityDefinition)activity);
        }
        return result;
    }
}

