/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.def.element.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.ow2.bonita.util.CopyTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IterationDescriptor
implements Serializable {
    private static final long serialVersionUID = -3306138069531809523L;
    protected Set<String> otherNodes;
    protected Set<String> entryNodes;
    protected Set<String> exitNodes;

    protected IterationDescriptor() {
    }

    public IterationDescriptor(Set<String> otherNodes, Set<String> entryNodes, Set<String> exitNodes) {
        this.otherNodes = otherNodes;
        this.entryNodes = entryNodes;
        this.exitNodes = exitNodes;
    }

    public IterationDescriptor(IterationDescriptor id) {
        this.otherNodes = CopyTool.copy(id.getOtherNodes());
        this.entryNodes = CopyTool.copy(id.getEntryNodes());
        this.exitNodes = CopyTool.copy(id.getExitNodes());
    }

    private Set<String> getOtherNodes() {
        if (this.otherNodes == null) {
            return Collections.emptySet();
        }
        return this.otherNodes;
    }

    public Set<String> getEntryNodes() {
        if (this.entryNodes == null) {
            return Collections.emptySet();
        }
        return this.entryNodes;
    }

    public Set<String> getExitNodes() {
        if (this.exitNodes == null) {
            return Collections.emptySet();
        }
        return this.exitNodes;
    }

    public boolean containsNode(String node) {
        return this.getCycleNodes().contains(node);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IterationDescriptor)) {
            return false;
        }
        IterationDescriptor other = (IterationDescriptor)obj;
        return ((Object)other.getEntryNodes()).equals(this.getEntryNodes()) && ((Object)other.getExitNodes()).equals(this.getExitNodes()) && ((Object)other.getOtherNodes()).equals(this.getOtherNodes());
    }

    public String toString() {
        String s = this.getClass().getSimpleName() + ": ";
        s = s + "\nEntry nodes : ";
        for (String st : this.getEntryNodes()) {
            s = s + st + ",";
        }
        s = s + "\nExit nodes : ";
        for (String st : this.getExitNodes()) {
            s = s + st + ",";
        }
        s = s + "\nOther nodes : ";
        for (String st : this.getOtherNodes()) {
            s = s + st + ",";
        }
        return s;
    }

    public Set<String> getCycleNodes() {
        HashSet<String> cycleNodes = new HashSet<String>();
        cycleNodes.addAll(this.getEntryNodes());
        cycleNodes.addAll(this.getExitNodes());
        cycleNodes.addAll(this.getOtherNodes());
        return cycleNodes;
    }
}

