/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.def.element.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.ow2.bonita.facade.def.element.OutgoingEventDefinition;
import org.ow2.bonita.type.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutgoingEventDefinitionImpl
implements OutgoingEventDefinition {
    private static final long serialVersionUID = 1478036854866168059L;
    protected String name;
    protected Map<String, Object> clientParameters;
    protected Map<String, Variable> variableParameters;
    protected String toProcessName;
    protected String toActivityName;
    protected long timeToLive;

    public OutgoingEventDefinitionImpl() {
    }

    public OutgoingEventDefinitionImpl(String eventName, String toProcessName, String toActivityName, Map<String, Object> parameters, long timeToLive) {
        this.name = eventName;
        this.toProcessName = toProcessName;
        this.toActivityName = toActivityName;
        this.clientParameters = parameters;
        this.timeToLive = timeToLive;
    }

    public OutgoingEventDefinitionImpl(OutgoingEventDefinition src) {
        this.name = src.getName();
        this.toProcessName = src.getToProcessName();
        this.toActivityName = src.getToActivityName();
        this.clientParameters = src.getParameters();
        this.timeToLive = src.getTimeToLive();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Map<String, Object> getParameters() {
        if (this.getVariableParameters() != null) {
            return this.getVariableParameters();
        }
        if (this.getClientParameters() != null) {
            return this.getClientParameters();
        }
        return Collections.emptyMap();
    }

    @Override
    public String getToActivityName() {
        return this.toActivityName;
    }

    @Override
    public String getToProcessName() {
        return this.toProcessName;
    }

    public Map<String, Object> getClientParameters() {
        return this.clientParameters;
    }

    public Map<String, Object> getVariableParameters() {
        if (this.variableParameters == null) {
            return null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, Variable> entry : this.variableParameters.entrySet()) {
            result.put(entry.getKey(), entry.getValue().getValue());
        }
        return result;
    }

    public void addParameter(String key, Variable value) {
        if (this.variableParameters == null) {
            this.variableParameters = new HashMap<String, Variable>();
        }
        this.variableParameters.put(key, value);
    }

    public void removeClientParameters() {
        this.clientParameters = null;
    }

    @Override
    public long getTimeToLive() {
        return this.timeToLive;
    }
}

