/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.def.majorElement.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.ow2.bonita.facade.def.majorElement.DataFieldDefinition;
import org.ow2.bonita.facade.def.majorElement.impl.ProcessElementImpl;
import org.ow2.bonita.facade.uuid.ActivityDefinitionUUID;
import org.ow2.bonita.facade.uuid.DataFieldDefinitionUUID;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.type.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataFieldDefinitionImpl
extends ProcessElementImpl
implements DataFieldDefinition {
    private static final long serialVersionUID = 3520847216843051032L;
    protected DataFieldDefinitionUUID uuid;
    protected String dataTypeClassName;
    protected String scriptingValue;
    protected String enumerationValues;
    protected Variable initialValueVariable;
    protected Serializable clientInitialValue;

    protected DataFieldDefinitionImpl() {
    }

    public DataFieldDefinitionImpl(ProcessDefinitionUUID processUUID, String name, String dataTypeClassName) {
        super(name, processUUID);
        this.uuid = new DataFieldDefinitionUUID(processUUID, name);
        this.dataTypeClassName = dataTypeClassName;
    }

    public DataFieldDefinitionImpl(ActivityDefinitionUUID activityUUID, String name, String dataTypeClassName) {
        super(name, activityUUID.getProcessUUID());
        this.uuid = new DataFieldDefinitionUUID(activityUUID, name);
        this.dataTypeClassName = dataTypeClassName;
    }

    public DataFieldDefinitionImpl(DataFieldDefinition src) {
        super(src);
        this.uuid = new DataFieldDefinitionUUID(src.getUUID());
        this.dataTypeClassName = src.getDataTypeClassName();
        DataFieldDefinitionImpl srcImpl = (DataFieldDefinitionImpl)src;
        this.enumerationValues = srcImpl.enumerationValues;
        this.clientInitialValue = src.getInitialValue();
        this.scriptingValue = src.getScriptingValue();
    }

    @Override
    public String getDataTypeClassName() {
        return this.dataTypeClassName;
    }

    @Override
    public Serializable getInitialValue() {
        if (this.getInitialValueVariable() != null) {
            return (Serializable)this.getInitialValueVariable().getValue();
        }
        return this.getClientInitialValue();
    }

    @Override
    public DataFieldDefinitionUUID getUUID() {
        return this.uuid;
    }

    @Override
    public Set<String> getEnumerationValues() {
        if (this.enumerationValues == null) {
            return Collections.emptySet();
        }
        String[] values = this.enumerationValues.split(",");
        HashSet<String> result = new HashSet<String>();
        for (String s : values) {
            result.add(s);
        }
        return result;
    }

    public void setEnumerationValues(Set<String> enumerationValues) {
        if (enumerationValues != null) {
            this.enumerationValues = "";
            Iterator<String> it = enumerationValues.iterator();
            while (it.hasNext()) {
                this.enumerationValues = this.enumerationValues + it.next();
                if (!it.hasNext()) continue;
                this.enumerationValues = this.enumerationValues + ",";
            }
        }
    }

    public void setInitialValue(Serializable initialValue) {
        this.clientInitialValue = initialValue;
    }

    @Override
    public boolean isEnumeration() {
        return this.dataTypeClassName.equals(String.class.getName()) && this.enumerationValues != null;
    }

    public void setInitialValue(Variable initialValue) {
        this.initialValueVariable = initialValue;
        this.clientInitialValue = null;
    }

    private Variable getInitialValueVariable() {
        return this.initialValueVariable;
    }

    private Serializable getClientInitialValue() {
        return this.clientInitialValue;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!o.getClass().equals(this.getClass())) {
            return false;
        }
        DataFieldDefinitionImpl other = (DataFieldDefinitionImpl)o;
        return other.getUUID().equals(this.getUUID());
    }

    public void setScriptingValue(String scriptingValue) {
        this.scriptingValue = scriptingValue;
    }

    @Override
    public String getScriptingValue() {
        return this.scriptingValue;
    }
}

