/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.ejb;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.util.ExceptionManager;
import org.ow2.bonita.util.Misc;

public final class EJB2SecurityOwner {
    private static final InheritableThreadLocal<String> USERS = new InheritableThreadLocal();
    private static final Logger LOG = Logger.getLogger(EJB2SecurityOwner.class.getName());

    private EJB2SecurityOwner() {
    }

    public static String getUser() {
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.entering(EJB2SecurityOwner.class.getName(), "getUser");
        }
        String userId = (String)USERS.get();
        String message = ExceptionManager.getInstance().getFullMessage("bsi_EJBSO_1", new Object[0]);
        Misc.badStateIfNull(userId, message);
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.exiting(EJB2SecurityOwner.class.getName(), "getUser", userId);
        }
        return userId;
    }

    static void setUser(String userId) {
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.entering(EJB2SecurityOwner.class.getName(), "setUser", userId);
        }
        String message = ExceptionManager.getInstance().getFullMessage("bsi_EJBSO_2", new Object[0]);
        Misc.checkArgsNotNull(userId, message);
        USERS.set(userId);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("User set: " + userId);
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.exiting(EJB2SecurityOwner.class.getName(), "setUser");
        }
    }
}

