/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.ejb;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.env.Environment;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.Command;
import org.ow2.bonita.util.ExceptionManager;
import org.ow2.bonita.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializedCommand<T>
implements Command<T> {
    private static final long serialVersionUID = -3780999471259012607L;
    private byte[] serializedCommand;
    private String className;
    private static final Logger LOG = Logger.getLogger(SerializedCommand.class.getName());

    public SerializedCommand(Command<?> command) {
        try {
            this.className = command.getClass().getName();
            this.serializedCommand = Misc.serialize(command);
        }
        catch (IOException e) {
            throw new BonitaRuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new BonitaRuntimeException(e);
        }
    }

    @Override
    public T execute(Environment environment) throws Exception {
        try {
            ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Executing a command in remote mode. Looking for Class: " + this.className + ". Current ClassLoader: " + currentClassLoader);
            }
            Class.forName(this.className, true, currentClassLoader);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Executing a command in remote mode. Class: " + this.className + " found.");
            }
            Command command = (Command)Misc.deserialize(this.serializedCommand);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Executing a command in remote mode. Executing deserialized command: " + command);
            }
            return command.execute(environment);
        }
        catch (ClassNotFoundException e) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Executing a command in remote mode. Class: " + this.className + " not found.");
            }
            String message = ExceptionManager.getInstance().getFullMessage("baa_SC_1", this.className);
            throw new BonitaRuntimeException(message, e);
        }
    }
}

