/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.exception;

import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.util.BonitaException;

public class DeploymentException
extends BonitaException {
    private static final long serialVersionUID = 6967327173196513880L;
    private final String className;
    private final ProcessDefinitionUUID processUUID;

    public DeploymentException(String msg) {
        super(msg);
        this.className = null;
        this.processUUID = null;
    }

    public DeploymentException(String msg, Throwable cause) {
        super(msg, cause);
        this.className = null;
        this.processUUID = null;
    }

    public DeploymentException(String msg, Throwable cause, ProcessDefinitionUUID processUUID) {
        super(msg, cause);
        this.className = null;
        this.processUUID = processUUID;
    }

    public DeploymentException(String msg, String className) {
        super(msg + className);
        this.className = className;
        this.processUUID = null;
    }

    public DeploymentException(String msg, String className, ProcessDefinitionUUID processUUID) {
        super(msg + " className: " + className + " processDefinitionUUID: " + processUUID);
        this.className = className;
        this.processUUID = processUUID;
    }

    public String getClassName() {
        return this.className;
    }

    public ProcessDefinitionUUID getProcessDefinitionUUID() {
        return this.processUUID;
    }
}

