/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.exception;

import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.util.BonitaException;
import org.ow2.bonita.util.ExceptionManager;

public class ProcessNotFoundException
extends BonitaException {
    private static final long serialVersionUID = -264146472484882763L;
    private final String processId;
    private final String version;
    private final ProcessDefinitionUUID processUUID;

    public ProcessNotFoundException(String id, String processId) {
        super(ExceptionManager.getInstance().getIdMessage(id) + ExceptionManager.getInstance().getMessage("PNFE1", processId));
        this.processId = processId;
        this.processUUID = null;
        this.version = null;
    }

    public ProcessNotFoundException(String id, String processId, String version) {
        super(ExceptionManager.getInstance().getIdMessage(id) + ExceptionManager.getInstance().getMessage("PNFE1", processId));
        this.processId = processId;
        this.version = version;
        this.processUUID = null;
    }

    public ProcessNotFoundException(String id, ProcessDefinitionUUID processUUID) {
        super(ExceptionManager.getInstance().getIdMessage(id) + ExceptionManager.getInstance().getMessage("PNFE3", processUUID));
        this.processUUID = processUUID;
        this.processId = null;
        this.version = null;
    }

    public String getProcessId() {
        return this.processId;
    }

    public ProcessDefinitionUUID getProcessUUID() {
        return this.processUUID;
    }

    public String getVersion() {
        return this.version;
    }
}

