/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.identity.impl;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.ow2.bonita.facade.def.majorElement.impl.DescriptionElementImpl;
import org.ow2.bonita.facade.identity.Role;
import org.ow2.bonita.facade.identity.impl.UserImpl;
import org.ow2.bonita.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoleImpl
extends DescriptionElementImpl
implements Role {
    private static final long serialVersionUID = 3045932457883692778L;
    protected long dbid;
    protected String uuid;
    protected String name;
    protected String label;
    protected Set<UserImpl> users;

    protected RoleImpl() {
    }

    public RoleImpl(String name) {
        Misc.checkArgsNotNull(name);
        this.name = name;
        this.uuid = UUID.randomUUID().toString();
    }

    public RoleImpl(RoleImpl src) {
        super(src);
        this.uuid = src.getUUID();
        this.name = src.getName();
        this.label = src.getLabel();
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public Set<UserImpl> getUsers() {
        if (this.users == null) {
            this.users = new HashSet<UserImpl>();
        }
        return this.users;
    }

    public void addUser(UserImpl user) {
        if (this.users == null) {
            this.users = new HashSet<UserImpl>();
        }
        this.users.add(user);
        user.getRoles().add(this);
    }

    public void removeUser(UserImpl user) {
        if (this.users != null && !this.users.isEmpty()) {
            this.users.remove(user);
            user.getRoles().remove(this);
        }
    }

    @Deprecated
    public void setUUID(String uuid) {
        this.uuid = uuid;
    }

    @Override
    public String getUUID() {
        return this.uuid;
    }

    @Override
    @Deprecated
    public long getId() {
        return this.dbid;
    }
}

