/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.identity.impl;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.ow2.bonita.facade.identity.User;
import org.ow2.bonita.facade.identity.impl.RoleImpl;
import org.ow2.bonita.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserImpl
implements User {
    private static final long serialVersionUID = 5357217264648978573L;
    protected long dbid;
    protected String uuid;
    protected String email;
    protected String firstName;
    protected String lastName;
    protected String password;
    protected String username;
    protected Set<RoleImpl> roles;

    protected UserImpl() {
    }

    public UserImpl(String username, String password) {
        Misc.checkArgsNotNull(username, password);
        this.uuid = UUID.randomUUID().toString();
        this.username = username;
        this.password = password;
    }

    public UserImpl(UserImpl src) {
        Misc.checkArgsNotNull(src);
        this.uuid = src.getUUID();
        this.email = src.getEmail();
        this.firstName = src.getFirstName();
        this.lastName = src.getLastName();
        this.password = src.getPassword();
        this.username = src.getUsername();
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    @Override
    public String getFirstName() {
        return this.firstName;
    }

    @Override
    public String getLastName() {
        return this.lastName;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    public Set<RoleImpl> getRoles() {
        if (this.roles == null) {
            this.roles = new HashSet<RoleImpl>();
        }
        return this.roles;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setRoles(Set<RoleImpl> roles) {
        this.roles = roles;
    }

    public void addRole(RoleImpl role) {
        if (this.roles == null) {
            this.roles = new HashSet<RoleImpl>();
        }
        this.roles.add(role);
        role.getUsers().add(this);
    }

    public void removeRole(RoleImpl role) {
        if (this.roles != null && !this.roles.isEmpty()) {
            this.roles.remove(role);
            role.getUsers().remove(this);
        }
    }

    @Override
    @Deprecated
    public long getId() {
        return this.dbid;
    }

    @Override
    public String getUUID() {
        return this.uuid;
    }

    @Deprecated
    public void setUUID(String uuid) {
        this.uuid = uuid;
    }
}

