/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.impl;

import java.rmi.RemoteException;
import java.util.Date;
import java.util.List;
import org.ow2.bonita.facade.internal.InternalBAMAPI;
import org.ow2.bonita.util.DateUtil;
import org.ow2.bonita.util.EnvTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BAMAPIImpl
implements InternalBAMAPI {
    protected BAMAPIImpl() {
    }

    @Override
    public List<Integer> getNumberOfExecutingCasesPerDay(Date since, String queryList) throws RemoteException {
        Date now = new Date();
        return EnvTool.getAllQueriers(queryList).getNumberOfExecutingCasesPerDay(since, now);
    }

    @Override
    public List<Integer> getNumberOfFinishedCasesPerDay(Date since, String queryList) throws RemoteException {
        Date now = new Date();
        return EnvTool.getAllQueriers(queryList).getNumberOfFinishedCasesPerDay(since, now);
    }

    @Override
    public int getNumberOfOpenSteps(String queryList) throws RemoteException {
        return EnvTool.getJournalQueriers(queryList).getNumberOfOpenSteps();
    }

    @Override
    public List<Integer> getNumberOfOpenStepsPerDay(Date since, String queryList) throws RemoteException {
        Date now = new Date();
        return EnvTool.getAllQueriers(queryList).getNumberOfOpenStepsPerDay(since, now);
    }

    @Override
    public int getNumberOfOverdueSteps(String queryList) throws RemoteException {
        Date now = new Date();
        return EnvTool.getJournalQueriers(queryList).getNumberOfOverdueSteps(now);
    }

    @Override
    public int getNumberOfStepsAtRisk(int remainingDays, String queryList) throws RemoteException {
        if (remainingDays < 0) {
            throw new IllegalArgumentException("The number of remaining days is negative");
        }
        Date currentDate = new Date();
        Date beginningOfTheDay = DateUtil.getBeginningOfTheDay(currentDate);
        Date atRisk = DateUtil.backTo(beginningOfTheDay, -(remainingDays + 1));
        return EnvTool.getJournalQueriers(queryList).getNumberOfStepsAtRisk(currentDate, atRisk);
    }

    @Override
    public int getNumberOfUserOpenSteps(String queryList) throws RemoteException {
        String userId = EnvTool.getUserId();
        return EnvTool.getJournalQueriers(queryList).getNumberOfUserOpenSteps(userId);
    }

    @Override
    public int getNumberOfUserOverdueSteps(String queryList) throws RemoteException {
        Date now = new Date();
        String userId = EnvTool.getUserId();
        return EnvTool.getJournalQueriers(queryList).getNumberOfUserOverdueSteps(userId, now);
    }

    @Override
    public int getNumberOfUserStepsAtRisk(int remainingDays, String queryList) throws RemoteException {
        if (remainingDays < 0) {
            throw new IllegalArgumentException("The number of remaining days is negative");
        }
        String userId = EnvTool.getUserId();
        Date currentDate = new Date();
        Date beginningOfTheDay = DateUtil.getBeginningOfTheDay(currentDate);
        Date atRisk = DateUtil.backTo(beginningOfTheDay, -(remainingDays + 1));
        return EnvTool.getJournalQueriers(queryList).getNumberOfUserStepsAtRisk(userId, currentDate, atRisk);
    }

    @Override
    public int getNumberOfFinishedSteps(int priority, Date since, String queryList) throws RemoteException {
        return EnvTool.getAllQueriers(queryList).getNumberOfFinishedSteps(priority, since);
    }

    @Override
    public int getNumberOfOpenSteps(int priority, String queryList) throws RemoteException {
        return EnvTool.getJournalQueriers(queryList).getNumberOfOpenSteps(priority);
    }

    @Override
    public int getNumberOfUserFinishedSteps(int priority, Date since, String queryList) throws RemoteException {
        String userId = EnvTool.getUserId();
        return EnvTool.getAllQueriers(queryList).getNumberOfUserFinishedSteps(userId, priority, since);
    }

    @Override
    public int getNumberOfUserOpenSteps(int priority, String queryList) throws RemoteException {
        String userId = EnvTool.getUserId();
        return EnvTool.getJournalQueriers(queryList).getNumberOfUserOpenSteps(userId, priority);
    }
}

