/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.impl;

import java.util.HashSet;
import java.util.Set;
import org.ow2.bonita.facade.def.InternalProcessDefinition;
import org.ow2.bonita.facade.exception.BonitaWrapperException;
import org.ow2.bonita.facade.exception.ProcessNotFoundException;
import org.ow2.bonita.facade.privilege.PrivilegePolicy;
import org.ow2.bonita.facade.privilege.Rule;
import org.ow2.bonita.facade.runtime.impl.InternalProcessInstance;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.services.Querier;
import org.ow2.bonita.util.EnvTool;
import org.ow2.bonita.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FacadeUtil {
    private FacadeUtil() {
    }

    public static InternalProcessDefinition getProcessDefinition(ProcessDefinitionUUID processUUID) throws ProcessNotFoundException {
        Misc.checkArgsNotNull(processUUID);
        Querier journal = EnvTool.getJournalQueriers();
        InternalProcessDefinition process = journal.getProcess(processUUID);
        if (process == null) {
            throw new ProcessNotFoundException("bai_FU_1", processUUID);
        }
        return process;
    }

    public static InternalProcessInstance getInstance(ProcessInstanceUUID instanceUUID, String queryList) {
        Misc.checkArgsNotNull(instanceUUID);
        Querier journal = null;
        journal = queryList != null ? EnvTool.getJournalQueriers(queryList) : EnvTool.getJournalQueriers();
        return journal.getProcessInstance(instanceUUID);
    }

    static void checkArgsNotNull(Object ... args) {
        try {
            Misc.checkArgsNotNull(1, args);
        }
        catch (IllegalArgumentException e) {
            throw new BonitaWrapperException(e);
        }
    }

    public static Set<ProcessDefinitionUUID> getAllowedProcessUUIDsFor(String entityID, Rule.RuleType ruleType) {
        FacadeUtil.checkArgsNotNull(new Object[]{entityID, ruleType});
        PrivilegePolicy policy = EnvTool.getPrivilegeService().getDefaultPolicy();
        Set<String> processUUIDs = EnvTool.getPrivilegeService().getExceptions(entityID, ruleType);
        Set<ProcessDefinitionUUID> result = new HashSet<ProcessDefinitionUUID>();
        for (String processUUID : processUUIDs) {
            result.add(new ProcessDefinitionUUID(processUUID));
        }
        if (policy == PrivilegePolicy.ALLOW_BY_DEFAULT) {
            result = EnvTool.getAllQueriers().getAllProcessDefinitionUUIDsExcept(result);
        }
        return result;
    }
}

