/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.impl;

import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.Set;
import org.ow2.bonita.facade.exception.RoleAlreadyExistsException;
import org.ow2.bonita.facade.exception.RoleNotFoundException;
import org.ow2.bonita.facade.exception.UserAlreadyExistsException;
import org.ow2.bonita.facade.exception.UserNotFoundException;
import org.ow2.bonita.facade.identity.Role;
import org.ow2.bonita.facade.identity.User;
import org.ow2.bonita.facade.identity.impl.RoleImpl;
import org.ow2.bonita.facade.identity.impl.UserImpl;
import org.ow2.bonita.facade.impl.FacadeUtil;
import org.ow2.bonita.facade.internal.InternalIdentityAPI;
import org.ow2.bonita.services.IdentityService;
import org.ow2.bonita.util.EnvTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityAPIImpl
implements InternalIdentityAPI {
    protected IdentityAPIImpl() {
    }

    @Override
    public Role addRole(String name) throws RemoteException, RoleAlreadyExistsException {
        FacadeUtil.checkArgsNotNull(name);
        IdentityService identityService = EnvTool.getIdentityService();
        RoleImpl role = identityService.getRole(name);
        if (role != null) {
            throw new RoleAlreadyExistsException("bai_IAPII_1", name);
        }
        role = new RoleImpl(name);
        identityService.addRole(role);
        return role;
    }

    @Override
    public Role addRole(String name, String label, String description) throws RemoteException, RoleAlreadyExistsException {
        FacadeUtil.checkArgsNotNull(name);
        IdentityService identityService = EnvTool.getIdentityService();
        RoleImpl role = identityService.getRole(name);
        if (role != null) {
            throw new RoleAlreadyExistsException("bai_IAPII_2", name);
        }
        role = new RoleImpl(name);
        role.setLabel(label);
        role.setDescription(description);
        identityService.addRole(role);
        return role;
    }

    @Override
    public void addRoleToUser(String roleName, String username) throws RemoteException, UserNotFoundException, RoleNotFoundException {
        FacadeUtil.checkArgsNotNull(roleName, username);
        IdentityService identityService = EnvTool.getIdentityService();
        UserImpl user = identityService.getUser(username);
        if (user == null) {
            throw new UserNotFoundException("bai_IAPII_3", username);
        }
        RoleImpl role = identityService.getRole(roleName);
        if (role == null) {
            throw new RoleNotFoundException("bai_IAPII_4", roleName);
        }
        user.addRole(role);
    }

    @Override
    public void setUserRoles(String username, Set<String> roleNames) throws RemoteException, UserNotFoundException, RoleNotFoundException {
        FacadeUtil.checkArgsNotNull(username, roleNames);
        IdentityService identityService = EnvTool.getIdentityService();
        UserImpl user = identityService.getUser(username);
        if (user == null) {
            throw new UserNotFoundException("bai_IAPII_8", username);
        }
        HashSet<String> rolesToRemove = new HashSet<String>();
        for (RoleImpl oldRole : user.getRoles()) {
            String oldRoleName = oldRole.getName();
            rolesToRemove.add(oldRoleName);
        }
        for (String roleToRemove : rolesToRemove) {
            this.removeRoleFromUser(roleToRemove, username);
        }
        for (String roleName : roleNames) {
            this.addRoleToUser(roleName, username);
        }
    }

    @Override
    public User addUser(String username, String password) throws RemoteException, UserAlreadyExistsException {
        FacadeUtil.checkArgsNotNull(username, password);
        IdentityService identityService = EnvTool.getIdentityService();
        UserImpl user = identityService.getUser(username);
        if (user != null) {
            throw new UserAlreadyExistsException("bai_IAPII_5", username);
        }
        user = new UserImpl(username, password);
        identityService.addUser(user);
        return user;
    }

    @Override
    public User addUser(String username, String password, String firstName, String lastName, String email) throws RemoteException, UserAlreadyExistsException {
        FacadeUtil.checkArgsNotNull(username, password);
        IdentityService identityService = EnvTool.getIdentityService();
        UserImpl user = identityService.getUser(username);
        if (user != null) {
            throw new UserAlreadyExistsException("bai_IAPII_6", username);
        }
        user = new UserImpl(username, password);
        user.setEmail(email);
        user.setFirstName(firstName);
        user.setLastName(lastName);
        identityService.addUser(user);
        return user;
    }

    @Override
    public Set<Role> getRoles() throws RemoteException {
        IdentityService identityService = EnvTool.getIdentityService();
        Set<RoleImpl> roles = identityService.getRoles();
        HashSet<Role> result = new HashSet<Role>();
        if (roles != null) {
            for (RoleImpl role : roles) {
                result.add(new RoleImpl(role));
            }
        }
        return result;
    }

    @Override
    public Set<User> getUsers() throws RemoteException {
        IdentityService identityService = EnvTool.getIdentityService();
        Set<UserImpl> users = identityService.getUsers();
        HashSet<User> result = new HashSet<User>();
        if (users != null) {
            for (UserImpl user : users) {
                result.add(new UserImpl(user));
            }
        }
        return result;
    }

    @Override
    public Role getRole(String name) throws RemoteException, RoleNotFoundException {
        FacadeUtil.checkArgsNotNull(name);
        IdentityService identityService = EnvTool.getIdentityService();
        RoleImpl role = identityService.getRole(name);
        if (role == null) {
            throw new RoleNotFoundException("bai_IAPII_7", name);
        }
        return new RoleImpl(role);
    }

    @Override
    public User getUser(String username) throws RemoteException, UserNotFoundException {
        FacadeUtil.checkArgsNotNull(username);
        IdentityService identityService = EnvTool.getIdentityService();
        UserImpl user = identityService.getUser(username);
        if (user == null) {
            throw new UserNotFoundException("bai_IAPII_8", username);
        }
        return new UserImpl(user);
    }

    @Override
    public void removeRole(String name) throws RemoteException, RoleNotFoundException {
        FacadeUtil.checkArgsNotNull(name);
        IdentityService identityService = EnvTool.getIdentityService();
        RoleImpl role = identityService.getRole(name);
        if (role == null) {
            throw new RoleNotFoundException("bai_IAPII_9", name);
        }
        Set<UserImpl> users = role.getUsers();
        if (users != null) {
            for (UserImpl user : users) {
                user.getRoles().remove(role);
            }
        }
        identityService.deleteRole(role);
    }

    @Override
    public void removeUser(String username) throws RemoteException, UserNotFoundException {
        FacadeUtil.checkArgsNotNull(username);
        IdentityService identityService = EnvTool.getIdentityService();
        UserImpl user = identityService.getUser(username);
        if (user == null) {
            throw new UserNotFoundException("bai_IAPII_10", username);
        }
        Set<RoleImpl> roles = user.getRoles();
        if (roles != null) {
            for (RoleImpl role : roles) {
                role.getUsers().remove(user);
            }
        }
        identityService.deleteUser(user);
    }

    @Override
    public void removeRoleFromUser(String roleName, String username) throws RemoteException, UserNotFoundException, RoleNotFoundException {
        FacadeUtil.checkArgsNotNull(roleName, username);
        IdentityService identityService = EnvTool.getIdentityService();
        UserImpl user = identityService.getUser(username);
        if (user == null) {
            throw new UserNotFoundException("bai_IAPII_11", username);
        }
        RoleImpl role = identityService.getRole(roleName);
        if (role == null) {
            throw new RoleNotFoundException("bai_IAPII_12", roleName);
        }
        user.removeRole(role);
    }

    @Override
    public Set<Role> getUserRoles(String username) throws RemoteException, UserNotFoundException {
        FacadeUtil.checkArgsNotNull(username);
        IdentityService identityService = EnvTool.getIdentityService();
        UserImpl user = identityService.getUser(username);
        if (user == null) {
            throw new UserNotFoundException("bai_IAPII_13", username);
        }
        Set<RoleImpl> roles = user.getRoles();
        HashSet<Role> result = new HashSet<Role>();
        if (roles != null) {
            for (RoleImpl role : roles) {
                result.add(new RoleImpl(role));
            }
        }
        return result;
    }

    @Override
    public Set<User> getUsersInRole(String name) throws RemoteException, RoleNotFoundException {
        FacadeUtil.checkArgsNotNull(name);
        IdentityService identityService = EnvTool.getIdentityService();
        RoleImpl role = identityService.getRole(name);
        if (role == null) {
            throw new RoleNotFoundException("bai_IAPII_14", name);
        }
        Set<UserImpl> users = role.getUsers();
        HashSet<User> result = new HashSet<User>();
        if (users != null) {
            for (UserImpl user : users) {
                result.add(new UserImpl(user));
            }
        }
        return result;
    }

    @Override
    public Role updateRole(String oldName, String name, String label, String description) throws RemoteException, RoleNotFoundException, RoleAlreadyExistsException {
        FacadeUtil.checkArgsNotNull(oldName, name);
        IdentityService identityService = EnvTool.getIdentityService();
        RoleImpl role = identityService.getRole(oldName);
        if (role == null) {
            throw new RoleNotFoundException("bai_IAPII_15", oldName);
        }
        if (name != oldName && identityService.getRole(name) != null) {
            throw new RoleAlreadyExistsException("bai_IAPII_16", name);
        }
        role.setName(name);
        role.setLabel(label);
        role.setDescription(description);
        return role;
    }

    @Override
    public User updateUser(String oldUsername, String username, String password, String firstName, String lastName, String email) throws RemoteException, UserNotFoundException, UserAlreadyExistsException {
        FacadeUtil.checkArgsNotNull(oldUsername, username);
        IdentityService identityService = EnvTool.getIdentityService();
        UserImpl user = identityService.getUser(oldUsername);
        if (user == null) {
            throw new UserNotFoundException("bai_IAPII_17", oldUsername);
        }
        if (username != oldUsername && identityService.getUser(username) != null) {
            throw new UserAlreadyExistsException("bai_IAPII_18", username);
        }
        user.setUsername(username);
        user.setPassword(password);
        user.setFirstName(firstName);
        user.setLastName(lastName);
        user.setEmail(email);
        return user;
    }
}

