/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.impl;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.HibernateException;
import org.ow2.bonita.deployment.Deployer;
import org.ow2.bonita.deployment.DeploymentRuntimeException;
import org.ow2.bonita.env.Environment;
import org.ow2.bonita.facade.def.InternalProcessDefinition;
import org.ow2.bonita.facade.def.element.BusinessArchive;
import org.ow2.bonita.facade.def.majorElement.ProcessDefinition;
import org.ow2.bonita.facade.exception.DeploymentException;
import org.ow2.bonita.facade.exception.InstanceNotFoundException;
import org.ow2.bonita.facade.exception.PrivilegeNotFoundException;
import org.ow2.bonita.facade.exception.ProcessNotFoundException;
import org.ow2.bonita.facade.exception.RuleAlreadyExistsException;
import org.ow2.bonita.facade.exception.RuleNotFoundException;
import org.ow2.bonita.facade.exception.UndeletableInstanceException;
import org.ow2.bonita.facade.exception.UndeletableProcessException;
import org.ow2.bonita.facade.exception.UserNotFoundException;
import org.ow2.bonita.facade.identity.impl.RoleImpl;
import org.ow2.bonita.facade.identity.impl.UserImpl;
import org.ow2.bonita.facade.impl.FacadeUtil;
import org.ow2.bonita.facade.impl.RuntimeAPIImpl;
import org.ow2.bonita.facade.internal.InternalManagementAPI;
import org.ow2.bonita.facade.privilege.PrivilegePolicy;
import org.ow2.bonita.facade.privilege.Rule;
import org.ow2.bonita.facade.privilege.impl.ProcessReadRuleImpl;
import org.ow2.bonita.facade.privilege.impl.ProcessRuleImpl;
import org.ow2.bonita.facade.privilege.impl.ProcessStartRuleImpl;
import org.ow2.bonita.facade.privilege.impl.RuleImpl;
import org.ow2.bonita.facade.runtime.InstanceState;
import org.ow2.bonita.facade.runtime.impl.InternalProcessInstance;
import org.ow2.bonita.facade.uuid.AbstractUUID;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.runtime.ClassDataLoader;
import org.ow2.bonita.services.Archiver;
import org.ow2.bonita.services.AuthenticationService;
import org.ow2.bonita.services.IdentityService;
import org.ow2.bonita.services.LargeDataRepository;
import org.ow2.bonita.services.PrivilegeService;
import org.ow2.bonita.services.Querier;
import org.ow2.bonita.services.Recorder;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.EnvTool;
import org.ow2.bonita.util.ExceptionManager;
import org.ow2.bonita.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagementAPIImpl
implements InternalManagementAPI {
    private static final String DEFAULT_USERS_CREATED = "DEFAULT_USERS_CREATED";

    protected ManagementAPIImpl() {
    }

    @Override
    public ProcessDefinition deploy(BusinessArchive businessArchive) throws DeploymentException {
        FacadeUtil.checkArgsNotNull(businessArchive);
        try {
            return Deployer.deploy(businessArchive);
        }
        catch (Exception e) {
            throw new DeploymentException(e.getMessage(), e);
        }
    }

    @Override
    public void deployJar(String jarName, byte[] jar) throws DeploymentException {
        FacadeUtil.checkArgsNotNull(jarName, jar);
        if (!jarName.endsWith(".jar")) {
            throw new DeploymentException("Invalid jar name: " + jarName + ". A jar file name must ends with .jar extension.");
        }
        LargeDataRepository ldr = EnvTool.getLargeDataRepository();
        if (ldr.getData(byte[].class, Misc.getGlobalClassDataCategories(), jarName) != null) {
            throw new DeploymentException("A jar with name: " + jarName + " already exists in repository.");
        }
        ldr.storeData(Misc.getGlobalClassDataCategories(), jarName, (Serializable)jar, true);
        ClassDataLoader.resetCommonClassloader();
    }

    @Override
    public void removeJar(String jarName) throws DeploymentException {
        FacadeUtil.checkArgsNotNull(jarName);
        if (!jarName.endsWith(".jar")) {
            throw new DeploymentException("Invalid jar name: " + jarName + ". A jar file name must ends with .jar extension.");
        }
        LargeDataRepository ldr = EnvTool.getLargeDataRepository();
        boolean found = ldr.deleteData(Misc.getGlobalClassDataCategories(), jarName);
        if (!found) {
            String message = ExceptionManager.getInstance().getFullMessage("bai_MAPII_6", new Object[0]);
            throw new DeploymentException(message, jarName);
        }
        ClassDataLoader.resetCommonClassloader();
    }

    @Override
    public Set<String> getAvailableJars() throws RemoteException {
        LargeDataRepository ldr = EnvTool.getLargeDataRepository();
        return ldr.getKeys(Misc.getGlobalClassDataCategories());
    }

    @Override
    public void delete(Collection<ProcessDefinitionUUID> processUUIDs) throws DeploymentException, ProcessNotFoundException, UndeletableProcessException, UndeletableInstanceException, RemoteException {
        FacadeUtil.checkArgsNotNull(processUUIDs);
        for (ProcessDefinitionUUID processUUID : processUUIDs) {
            this.deleteProcess(processUUID);
        }
    }

    @Override
    public void deleteProcess(ProcessDefinitionUUID processUUID) throws ProcessNotFoundException, UndeletableProcessException, UndeletableInstanceException {
        FacadeUtil.checkArgsNotNull(processUUID);
        this.deleteProcess(true, processUUID);
    }

    private void deleteProcess(boolean deleteAll, ProcessDefinitionUUID processUUID) throws ProcessNotFoundException, UndeletableProcessException, UndeletableInstanceException {
        FacadeUtil.checkArgsNotNull(processUUID);
        Environment env = Environment.getCurrent();
        boolean access = env.isRestrictedApplicationAcces();
        boolean share = false;
        if (access) {
            try {
                HashSet<ProcessDefinitionUUID> itemsToRemove = new HashSet<ProcessDefinitionUUID>();
                itemsToRemove.add(processUUID);
                this.removeProcessDefinitionUUIDFromAllRules(itemsToRemove, Rule.RuleType.PROCESS_READ, Rule.RuleType.PROCESS_START);
            }
            catch (Exception e) {
                throw new ProcessNotFoundException(processUUID.getProcessName(), processUUID);
            }
        }
        if (!share) {
            boolean inJournal;
            Querier journal = EnvTool.getJournalQueriers();
            Querier history = EnvTool.getHistoryQueriers();
            InternalProcessDefinition processDef = journal.getProcess(processUUID);
            boolean bl = inJournal = processDef != null;
            if (processDef == null) {
                processDef = history.getProcess(processUUID);
            }
            if (processDef == null) {
                throw new ProcessNotFoundException("bai_MAPII_9", processUUID);
            }
            if (deleteAll) {
                RuntimeAPIImpl runtimeAPI = new RuntimeAPIImpl();
                try {
                    runtimeAPI.deleteAllProcessInstances(processUUID);
                }
                catch (ProcessNotFoundException e) {
                    throw new BonitaRuntimeException(e);
                }
            }
            if (inJournal) {
                Set<InternalProcessInstance> instances = EnvTool.getJournalQueriers().getProcessInstances(processUUID, InstanceState.STARTED);
                if (!instances.isEmpty()) {
                    ProcessInstanceUUID instanceUUID = instances.iterator().next().getUUID();
                    throw new UndeletableProcessException("bai_MAPII_10", processUUID, instanceUUID);
                }
                this.removeProcessDependencies(deleteAll, processDef);
                Recorder recorder = EnvTool.getRecorder();
                recorder.remove(processDef);
            }
            if (!inJournal) {
                Archiver archiver = EnvTool.getArchiver();
                archiver.remove(processDef);
            }
            ClassDataLoader.removeProcessClassLoader(processDef.getUUID());
            LargeDataRepository ldr = EnvTool.getLargeDataRepository();
            ldr.deleteData(Misc.getBusinessArchiveCategories(processUUID));
            ldr.deleteData(Misc.getAttachmentCategories(processUUID));
        }
    }

    private void removeProcessDefinitionUUIDFromAllRules(Set<ProcessDefinitionUUID> itemsToRemove, Rule.RuleType ... ruleTypes) throws RuleNotFoundException, RemoteException, PrivilegeNotFoundException {
        FacadeUtil.checkArgsNotNull(new Object[]{itemsToRemove, ruleTypes});
        PrivilegeService privilegeService = EnvTool.getPrivilegeService();
        Set<Rule> rules = privilegeService.getRulesByType(ruleTypes);
        for (Rule rule : rules) {
            this.removeExceptionsFromRule(rule.getName(), itemsToRemove);
        }
    }

    private void removeProcessDependencies(boolean checkIntegrity, ProcessDefinition processDef) {
        Set<InternalProcessInstance> instances = EnvTool.getJournalQueriers().getProcessInstances(processDef.getUUID(), InstanceState.STARTED);
        Deployer.removeStartEvents(processDef);
        if (instances != null && !instances.isEmpty()) {
            String message = ExceptionManager.getInstance().getFullMessage("bd_D_9", new Object[0]);
            throw new DeploymentRuntimeException(message);
        }
        ClassDataLoader.removeProcessClassLoader(processDef.getUUID());
    }

    @Override
    public void deleteAllProcesses() throws UndeletableInstanceException, RemoteException, UndeletableProcessException {
        Querier querier = EnvTool.getAllQueriers();
        Set<Object> processes = new HashSet();
        Set<Object> parentInstances = new HashSet();
        Environment env = Environment.getCurrent();
        boolean access = env.isRestrictedApplicationAcces();
        if (access) {
            Set<ProcessDefinitionUUID> readyToRemove;
            String applicationName = env.getApplicationAccessName();
            if (applicationName != null && !(readyToRemove = FacadeUtil.getAllowedProcessUUIDsFor(applicationName, Rule.RuleType.PROCESS_READ)).isEmpty()) {
                processes = querier.getProcesses(readyToRemove);
                parentInstances = querier.getProcessInstances(readyToRemove);
            }
        } else {
            parentInstances = querier.getParentInstances();
            processes = querier.getProcesses();
        }
        RuntimeAPIImpl runtimeAPI = new RuntimeAPIImpl();
        for (InternalProcessInstance internalProcessInstance : parentInstances) {
            try {
                runtimeAPI.deleteProcessInstance(internalProcessInstance.getUUID());
            }
            catch (InstanceNotFoundException e) {
                throw new BonitaRuntimeException("Unable to delete process instance: " + internalProcessInstance.getUUID());
            }
        }
        for (InternalProcessDefinition internalProcessDefinition : processes) {
            try {
                this.deleteProcess(false, internalProcessDefinition.getUUID());
            }
            catch (ProcessNotFoundException e) {
                throw new BonitaRuntimeException("Unable to delete process: " + internalProcessDefinition.getUUID());
            }
        }
    }

    @Override
    public String getLoggedUser() throws RemoteException {
        return EnvTool.getUserId();
    }

    @Override
    public void addMetaData(String key, String value) throws RemoteException {
        EnvTool.getJournal().storeMetaData(key, value);
    }

    @Override
    public void deleteMetaData(String key) throws RemoteException {
        EnvTool.getJournal().deleteMetaData(key);
    }

    @Override
    public String getMetaData(String key) throws RemoteException {
        return EnvTool.getJournal().getMetaData(key);
    }

    @Override
    public void archive(ProcessDefinitionUUID processUUID) throws DeploymentException {
        FacadeUtil.checkArgsNotNull(processUUID);
        try {
            Deployer.archiveProcess(processUUID, EnvTool.getUserId());
        }
        catch (DeploymentRuntimeException e) {
            throw new DeploymentException(e.getMessage(), e);
        }
    }

    @Override
    public void archive(Collection<ProcessDefinitionUUID> processUUIDs) throws DeploymentException, RemoteException {
        FacadeUtil.checkArgsNotNull(processUUIDs);
        for (ProcessDefinitionUUID processUUID : processUUIDs) {
            try {
                Deployer.archiveProcess(processUUID, EnvTool.getUserId());
            }
            catch (DeploymentRuntimeException e) {
                throw new DeploymentException(e.getMessage(), e);
            }
        }
    }

    @Override
    public void disable(ProcessDefinitionUUID processUUID) throws DeploymentException {
        FacadeUtil.checkArgsNotNull(processUUID);
        try {
            Deployer.disableProcess(processUUID);
        }
        catch (DeploymentRuntimeException e) {
            throw new DeploymentException(e.getMessage(), e);
        }
    }

    @Override
    public void disable(Collection<ProcessDefinitionUUID> processUUIDs) throws DeploymentException, RemoteException {
        FacadeUtil.checkArgsNotNull(processUUIDs);
        for (ProcessDefinitionUUID processUUID : processUUIDs) {
            try {
                Deployer.disableProcess(processUUID);
            }
            catch (DeploymentRuntimeException e) {
                throw new DeploymentException(e.getMessage(), e, processUUID);
            }
        }
    }

    @Override
    public void enable(ProcessDefinitionUUID processUUID) throws DeploymentException {
        FacadeUtil.checkArgsNotNull(processUUID);
        try {
            Deployer.enableProcess(processUUID);
        }
        catch (DeploymentRuntimeException e) {
            throw new DeploymentException(e.getMessage(), e);
        }
    }

    @Override
    public void enable(Collection<ProcessDefinitionUUID> processUUIDs) throws DeploymentException, RemoteException {
        FacadeUtil.checkArgsNotNull(processUUIDs);
        for (ProcessDefinitionUUID processUUID : processUUIDs) {
            this.enable(processUUID);
        }
    }

    @Override
    public boolean isUserAdmin(String username) throws UserNotFoundException, RemoteException {
        AuthenticationService adminService = EnvTool.getAuthenticationService();
        return adminService.isUserAdmin(username);
    }

    @Override
    public boolean checkUserCredentials(String username, String password) throws RemoteException {
        String defaultUsersCreated = EnvTool.getJournal().getMetaData(DEFAULT_USERS_CREATED);
        if (defaultUsersCreated == null) {
            IdentityService identityService = EnvTool.getIdentityService();
            RoleImpl userRole = this.createDefaultRole(identityService, "user", "User", "The user Role");
            RoleImpl adminRole = this.createDefaultRole(identityService, "admin", "Admin", "The admin Role");
            HashSet<RoleImpl> userRoles = new HashSet<RoleImpl>();
            userRoles.add(userRole);
            HashSet<RoleImpl> adminRoles = new HashSet<RoleImpl>();
            adminRoles.add(adminRole);
            this.addDefaultUser(identityService, "admin", "", "", "bpm", adminRoles);
            this.addDefaultUser(identityService, "john", "John", "Doe", "bpm", userRoles);
            this.addDefaultUser(identityService, "jack", "Jack", "Doe", "bpm", userRoles);
            this.addDefaultUser(identityService, "james", "James", "Doe", "bpm", userRoles);
            EnvTool.getJournal().storeMetaData(DEFAULT_USERS_CREATED, "true");
        }
        AuthenticationService authenticationService = EnvTool.getAuthenticationService();
        return authenticationService.checkUserCredentials(username, password);
    }

    private RoleImpl createDefaultRole(IdentityService identityService, String name, String label, String description) throws HibernateException {
        RoleImpl userRole = identityService.getRole(name);
        if (userRole == null) {
            userRole = new RoleImpl(name);
            userRole.setLabel(label);
            userRole.setDescription(description);
        }
        return userRole;
    }

    private void addDefaultUser(IdentityService identityService, String username, String firstName, String lastName, String password, Set<RoleImpl> roles) throws HibernateException {
        UserImpl existingUser = identityService.getUser(username);
        if (existingUser == null) {
            UserImpl user = new UserImpl(username, password);
            user.setFirstName(firstName);
            user.setLastName(lastName);
            for (RoleImpl role : roles) {
                RoleImpl dbRole = identityService.getRole(role.getName());
                if (dbRole != null) {
                    user.addRole(dbRole);
                    continue;
                }
                user.addRole(role);
            }
            identityService.addUser(user);
        } else {
            for (RoleImpl role : roles) {
                if (identityService.getRole(role.getName()) == null) {
                    identityService.addRole(role);
                }
                existingUser.addRole(identityService.getRole(role.getName()));
            }
        }
    }

    public void grantAccessAuthorisation(String applicationName, ProcessDefinitionUUID definitionUUID) throws RemoteException {
        FacadeUtil.checkArgsNotNull(applicationName, definitionUUID);
        PrivilegeService privilegeService = EnvTool.getPrivilegeService();
        RuleImpl rule = (RuleImpl)privilegeService.getRule(applicationName);
        if (rule != null) {
            HashSet<String> processeUUIDs = new HashSet<String>();
            processeUUIDs.add(definitionUUID.getValue());
            rule.addItems(processeUUIDs);
        } else {
            HashSet<ProcessDefinitionUUID> processes = new HashSet<ProcessDefinitionUUID>();
            processes.add(definitionUUID);
            try {
                rule = (RuleImpl)this.createRule(applicationName, applicationName, applicationName, processes, Rule.RuleType.PROCESS_READ);
                HashSet<String> rules = new HashSet<String>();
                rules.add(rule.getName());
            }
            catch (RuleAlreadyExistsException e) {
                e.printStackTrace();
                throw new RemoteException();
            }
        }
    }

    public void grantAccessAuthorisation(String applicationName, Set<ProcessDefinitionUUID> definitionUUIDs) throws RemoteException {
        FacadeUtil.checkArgsNotNull(applicationName, definitionUUIDs);
        for (ProcessDefinitionUUID definitionUUID : definitionUUIDs) {
            this.grantAccessAuthorisation(applicationName, definitionUUID);
        }
    }

    @Override
    public <E extends AbstractUUID> void addExceptionsToRule(String ruleName, Set<E> exceptions) throws RuleNotFoundException, RemoteException {
        FacadeUtil.checkArgsNotNull(ruleName, exceptions);
        if (exceptions.size() > 0) {
            PrivilegeService privilegeService = EnvTool.getPrivilegeService();
            Rule rule = privilegeService.getRule(ruleName);
            if (rule == null) {
                throw new RuleNotFoundException("bai_IAPII_8", ruleName);
            }
            switch (rule.getType()) {
                case PROCESS_START: {
                    ((ProcessStartRuleImpl)rule).addProcesses(exceptions);
                    break;
                }
                case PROCESS_READ: {
                    ((ProcessReadRuleImpl)rule).addProcesses(exceptions);
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
    }

    @Override
    public void applyRulesToEntity(String entityID, Set<String> rules) throws RuleNotFoundException, RemoteException {
        FacadeUtil.checkArgsNotNull(entityID, rules);
        if (rules.size() > 0) {
            PrivilegeService privilegeService = EnvTool.getPrivilegeService();
            Set<Rule> storedRules = privilegeService.getRules(rules);
            if (storedRules.size() < rules.size()) {
                HashSet<String> missingRulesName = new HashSet<String>(rules);
                for (Rule rule : storedRules) {
                    missingRulesName.remove(rule.getName());
                }
                throw new RuleNotFoundException("bai_IAPII_8", missingRulesName.iterator().next());
            }
            HashSet<String> entities = new HashSet<String>();
            entities.add(entityID);
            for (Rule rule : storedRules) {
                ((RuleImpl)rule).addEntitiess(entities);
            }
        }
    }

    @Override
    public void removeRulesFromEntity(String entityID, Set<String> rules) throws RemoteException, PrivilegeNotFoundException, RuleNotFoundException {
        FacadeUtil.checkArgsNotNull(entityID, rules);
        if (rules.size() > 0) {
            PrivilegeService privilegeService = EnvTool.getPrivilegeService();
            Set<Rule> storedRules = privilegeService.getRules();
            if (storedRules.size() < rules.size()) {
                HashSet<String> missingRulesName = new HashSet<String>(rules);
                for (Rule rule : storedRules) {
                    missingRulesName.remove(rule.getName());
                }
                throw new RuleNotFoundException("bai_IAPII_8", missingRulesName.iterator().next());
            }
            HashSet<String> entities = new HashSet<String>();
            entities.add(entityID);
            for (Rule rule : storedRules) {
                ((RuleImpl)rule).removeEntities(entities);
            }
        }
    }

    @Override
    public void applySameRulesToOtherEntities(String entityID, Set<String> entities) throws PrivilegeNotFoundException, RemoteException {
        FacadeUtil.checkArgsNotNull(entityID, entities);
        if (entities.size() > 0) {
            PrivilegeService privilegeService = EnvTool.getPrivilegeService();
            Set<Rule> storedRules = privilegeService.getAllApplicableRules(entityID);
            if (storedRules == null || storedRules.isEmpty()) {
                throw new PrivilegeNotFoundException("bai_IAPII_8", entityID);
            }
            for (String entity : entities) {
                Set<Rule> oldRules = privilegeService.getAllApplicableRules(entity);
                for (Rule rule : oldRules) {
                    ((RuleImpl)rule).removeEntities(entities);
                }
            }
            for (Rule rule : storedRules) {
                ((RuleImpl)rule).addEntitiess(entities);
            }
        }
    }

    @Override
    public <E extends AbstractUUID> Rule createRule(String name, String label, String description, Set<E> exceptions, Rule.RuleType type) throws RemoteException, RuleAlreadyExistsException {
        FacadeUtil.checkArgsNotNull(new Object[]{name, exceptions, type});
        PrivilegeService privilegeService = EnvTool.getPrivilegeService();
        Rule rule = privilegeService.getRule(name);
        if (rule != null) {
            throw new RuleAlreadyExistsException("bai_IAPII_1", name);
        }
        switch (type) {
            case PROCESS_START: {
                rule = new ProcessStartRuleImpl(name, label, description, exceptions);
                privilegeService.addRule(rule);
                break;
            }
            case PROCESS_READ: {
                rule = new ProcessReadRuleImpl(name, label, description, exceptions);
                privilegeService.addRule(rule);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return rule;
    }

    @Override
    public void deleteRule(String name) throws RemoteException, RuleNotFoundException {
        FacadeUtil.checkArgsNotNull(name);
        PrivilegeService privilegeService = EnvTool.getPrivilegeService();
        Rule rule = privilegeService.getRule(name);
        if (rule == null) {
            throw new RuleNotFoundException("bai_IAPII_9", name);
        }
        privilegeService.deleteRule(rule);
    }

    @Override
    public Rule getRule(String name) throws RuleNotFoundException, RemoteException {
        FacadeUtil.checkArgsNotNull(name);
        PrivilegeService privilegeService = EnvTool.getPrivilegeService();
        Rule rule = privilegeService.getRule(name);
        if (rule == null) {
            throw new RuleNotFoundException("bai_IAPII_8", name);
        }
        switch (rule.getType()) {
            case PROCESS_START: {
                return new ProcessStartRuleImpl((ProcessStartRuleImpl)rule);
            }
            case PROCESS_READ: {
                return new ProcessReadRuleImpl((ProcessReadRuleImpl)rule);
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Set<Rule> getRules() throws RemoteException {
        PrivilegeService privilegeService = EnvTool.getPrivilegeService();
        Set<Rule> rules = privilegeService.getRules();
        if (rules == null || rules.isEmpty()) {
            return Collections.emptySet();
        }
        return this.buildRulesResultSet(rules);
    }

    @Override
    public Set<Rule> getRules(Set<String> ruleNames) throws RemoteException, RuleNotFoundException {
        PrivilegeService privilegeService = EnvTool.getPrivilegeService();
        if (ruleNames.size() > 0) {
            Set<Rule> rules = privilegeService.getRules(ruleNames);
            if (ruleNames.size() != rules.size()) {
                HashSet<String> storedRuleNames = new HashSet<String>();
                for (Rule rule : rules) {
                    storedRuleNames.add(rule.getName());
                }
                for (String ruleName : ruleNames) {
                    if (storedRuleNames.contains(ruleName)) continue;
                    throw new RuleNotFoundException("bai_IAPII_8", ruleName);
                }
            }
            return this.buildRulesResultSet(rules);
        }
        return Collections.emptySet();
    }

    @Override
    public <E extends AbstractUUID> void removeExceptionsFromRule(String ruleName, Set<E> exceptions) throws RuleNotFoundException, RemoteException {
        FacadeUtil.checkArgsNotNull(ruleName, exceptions);
        if (exceptions.size() > 0) {
            PrivilegeService privilegeService = EnvTool.getPrivilegeService();
            Rule rule = privilegeService.getRule(ruleName);
            if (rule == null) {
                throw new RuleNotFoundException("bai_IAPII_8", ruleName);
            }
            switch (rule.getType()) {
                case PROCESS_START: {
                    ((ProcessStartRuleImpl)rule).removeProcesses(exceptions);
                    break;
                }
                case PROCESS_READ: {
                    ((ProcessReadRuleImpl)rule).removeProcesses(exceptions);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Un-managed rule type: " + (Object)((Object)rule.getType()));
                }
            }
        }
    }

    @Override
    public void updateRule(String name, Rule newRule) throws RemoteException, RuleNotFoundException {
        FacadeUtil.checkArgsNotNull(name, newRule);
        PrivilegeService privilegeService = EnvTool.getPrivilegeService();
        Rule rule = privilegeService.getRule(name);
        if (rule == null) {
            throw new RuleNotFoundException("bai_IAPII_8", name);
        }
        switch (rule.getType()) {
            case PROCESS_START: 
            case PROCESS_READ: {
                ((RuleImpl)rule).setDescription(newRule.getDescription());
                ((RuleImpl)rule).setName(newRule.getName());
                ((RuleImpl)rule).setLabel(newRule.getLabel());
                ((RuleImpl)rule).setExceptions(newRule.getItems());
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public Set<Rule> getAllApplicableRules(String entityID) {
        FacadeUtil.checkArgsNotNull(entityID);
        PrivilegeService privilegeService = EnvTool.getPrivilegeService();
        Set<Rule> rules = privilegeService.getAllApplicableRules(entityID);
        return this.buildRulesResultSet(rules);
    }

    @Override
    public Set<Rule> getApplicableRules(String entityID, Rule.RuleType ruleType) {
        FacadeUtil.checkArgsNotNull(new Object[]{entityID, ruleType});
        PrivilegeService privilegeService = EnvTool.getPrivilegeService();
        Set<Rule> rules = privilegeService.getApplicableRules(entityID, ruleType);
        return this.buildRulesResultSet(rules);
    }

    private Set<Rule> buildRulesResultSet(Set<Rule> rules) {
        HashSet<Rule> rulesResult = new HashSet<Rule>();
        block4: for (Rule rule : rules) {
            switch (rule.getType()) {
                case PROCESS_START: {
                    rulesResult.add(new ProcessStartRuleImpl((ProcessStartRuleImpl)rule));
                    continue block4;
                }
                case PROCESS_READ: {
                    rulesResult.add(new ProcessReadRuleImpl((ProcessReadRuleImpl)rule));
                    continue block4;
                }
            }
            throw new IllegalArgumentException("Un-managed RuleType: " + (Object)((Object)rule.getType()));
        }
        return rulesResult;
    }

    private List<Rule> buildRulesResultList(List<Rule> rules) {
        ArrayList<Rule> rulesResult = new ArrayList<Rule>();
        block4: for (Rule rule : rules) {
            switch (rule.getType()) {
                case PROCESS_START: {
                    rulesResult.add(new ProcessStartRuleImpl((ProcessStartRuleImpl)rule));
                    continue block4;
                }
                case PROCESS_READ: {
                    rulesResult.add(new ProcessReadRuleImpl((ProcessReadRuleImpl)rule));
                    continue block4;
                }
            }
            throw new IllegalArgumentException("Un-managed RuleType: " + (Object)((Object)rule.getType()));
        }
        return rulesResult;
    }

    @Override
    public PrivilegePolicy getDefaultPolicy() {
        PrivilegeService privilegeService = EnvTool.getPrivilegeService();
        return privilegeService.getDefaultPolicy();
    }

    @Override
    public void setDefaultPolicy(PrivilegePolicy newPolicy, boolean negateRules) {
        FacadeUtil.checkArgsNotNull(new Object[]{newPolicy});
        PrivilegeService privilegeService = EnvTool.getPrivilegeService();
        PrivilegePolicy currentPolicy = privilegeService.getDefaultPolicy();
        if (newPolicy != currentPolicy) {
            Set<Rule> processRules;
            if (negateRules && (processRules = privilegeService.getRulesByType(Rule.RuleType.PROCESS_START, Rule.RuleType.PROCESS_READ)) != null && !processRules.isEmpty()) {
                Set<InternalProcessDefinition> allProcesses = EnvTool.getAllQueriers().getProcesses();
                HashSet<ProcessDefinitionUUID> readableProcesses = new HashSet<ProcessDefinitionUUID>();
                HashSet<ProcessDefinitionUUID> startableProcesses = new HashSet<ProcessDefinitionUUID>();
                for (InternalProcessDefinition processDefinition : allProcesses) {
                    if (processDefinition.getState() != ProcessDefinition.ProcessState.ARCHIVED) {
                        startableProcesses.add(processDefinition.getUUID());
                    }
                    readableProcesses.add(processDefinition.getUUID());
                }
                for (Rule rule : processRules) {
                    switch (rule.getType()) {
                        case PROCESS_READ: {
                            HashSet<ProcessDefinitionUUID> ruleProcesses = new HashSet<ProcessDefinitionUUID>(readableProcesses);
                            ruleProcesses.removeAll(((ProcessRuleImpl)rule).getProcesses());
                            ((ProcessRuleImpl)rule).setProcesses(ruleProcesses);
                            break;
                        }
                        case PROCESS_START: {
                            HashSet<ProcessDefinitionUUID> ruleProcesses = new HashSet(startableProcesses);
                            ruleProcesses.removeAll(((ProcessRuleImpl)rule).getProcesses());
                            ((ProcessRuleImpl)rule).setProcesses(ruleProcesses);
                            break;
                        }
                    }
                }
            }
            privilegeService.setDefaultPolicy(newPolicy);
        }
    }

    @Override
    public List<Rule> getRules(Rule.RuleType ruleType, int fromIndex, int pageSige) throws RemoteException {
        PrivilegeService privilegeService = EnvTool.getPrivilegeService();
        List<Rule> rules = privilegeService.getRules(ruleType, fromIndex, pageSige);
        if (rules == null || rules.isEmpty()) {
            return Collections.emptyList();
        }
        return this.buildRulesResultList(rules);
    }

    @Override
    public long getNumberOfRules(Rule.RuleType ruleType) throws RemoteException {
        PrivilegeService privilegeService = EnvTool.getPrivilegeService();
        return privilegeService.getNumberOfRules(ruleType);
    }
}

