/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.impl;

import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ow2.bonita.env.Environment;
import org.ow2.bonita.facade.def.InternalActivityDefinition;
import org.ow2.bonita.facade.def.InternalProcessDefinition;
import org.ow2.bonita.facade.def.element.AttachmentDefinition;
import org.ow2.bonita.facade.def.element.BusinessArchive;
import org.ow2.bonita.facade.def.element.impl.BusinessArchiveImpl;
import org.ow2.bonita.facade.def.majorElement.ActivityDefinition;
import org.ow2.bonita.facade.def.majorElement.DataFieldDefinition;
import org.ow2.bonita.facade.def.majorElement.ParticipantDefinition;
import org.ow2.bonita.facade.def.majorElement.ProcessDefinition;
import org.ow2.bonita.facade.def.majorElement.impl.ActivityDefinitionImpl;
import org.ow2.bonita.facade.def.majorElement.impl.DataFieldDefinitionImpl;
import org.ow2.bonita.facade.def.majorElement.impl.ParticipantDefinitionImpl;
import org.ow2.bonita.facade.def.majorElement.impl.ProcessDefinitionImpl;
import org.ow2.bonita.facade.exception.ActivityDefNotFoundException;
import org.ow2.bonita.facade.exception.ActivityNotFoundException;
import org.ow2.bonita.facade.exception.DataFieldNotFoundException;
import org.ow2.bonita.facade.exception.ParticipantNotFoundException;
import org.ow2.bonita.facade.exception.ProcessNotFoundException;
import org.ow2.bonita.facade.impl.FacadeUtil;
import org.ow2.bonita.facade.internal.InternalQueryDefinitionAPI;
import org.ow2.bonita.facade.privilege.Rule;
import org.ow2.bonita.facade.runtime.InitialAttachment;
import org.ow2.bonita.facade.runtime.impl.InitialAttachmentImpl;
import org.ow2.bonita.facade.uuid.ActivityDefinitionUUID;
import org.ow2.bonita.facade.uuid.ParticipantDefinitionUUID;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.light.LightProcessDefinition;
import org.ow2.bonita.light.impl.LightProcessDefinitionImpl;
import org.ow2.bonita.runtime.ClassDataLoader;
import org.ow2.bonita.services.LargeDataRepository;
import org.ow2.bonita.util.EnvTool;
import org.ow2.bonita.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryDefinitionAPIImpl
implements InternalQueryDefinitionAPI {
    protected QueryDefinitionAPIImpl() {
    }

    private Set<ProcessDefinition> getProcessCopy(Set<ProcessDefinition> src) {
        HashSet<ProcessDefinition> result = new HashSet<ProcessDefinition>();
        if (src != null) {
            for (ProcessDefinition p : src) {
                result.add(new ProcessDefinitionImpl(p));
            }
        }
        return result;
    }

    private Set<ActivityDefinition> getActivityCopy(Set<ActivityDefinition> src) {
        HashSet<ActivityDefinition> result = new HashSet<ActivityDefinition>();
        if (src != null) {
            for (ActivityDefinition p : src) {
                result.add(new ActivityDefinitionImpl(p));
            }
        }
        return result;
    }

    private Set<ParticipantDefinition> getParticipantCopy(Set<ParticipantDefinition> src) {
        HashSet<ParticipantDefinition> result = new HashSet<ParticipantDefinition>();
        if (src != null) {
            for (ParticipantDefinition p : src) {
                result.add(new ParticipantDefinitionImpl(p));
            }
        }
        return result;
    }

    @Override
    public List<ProcessDefinition> getProcesses(int fromIndex, int pageSize, String queryList) throws RemoteException {
        ArrayList<ProcessDefinition> result = new ArrayList<ProcessDefinition>();
        if (pageSize <= 0) {
            return result;
        }
        List<InternalProcessDefinition> processes = this.getIndexedProcesses(fromIndex, pageSize, queryList);
        for (InternalProcessDefinition record : processes) {
            result.add(new ProcessDefinitionImpl(record));
        }
        return result;
    }

    @Override
    public List<LightProcessDefinition> getLightProcesses(int fromIndex, int pageSize, String queryList) throws RemoteException {
        ArrayList<LightProcessDefinition> result = new ArrayList<LightProcessDefinition>();
        if (pageSize <= 0) {
            return result;
        }
        List<InternalProcessDefinition> processes = this.getIndexedProcesses(fromIndex, pageSize, queryList);
        for (InternalProcessDefinition record : processes) {
            result.add(new LightProcessDefinitionImpl(record));
        }
        return result;
    }

    private List<InternalProcessDefinition> getIndexedProcesses(int fromIndex, int pageSize, String queryList) {
        Environment env = Environment.getCurrent();
        boolean access = env.isRestrictedApplicationAcces();
        List<Object> processes = new ArrayList();
        if (access) {
            Set<ProcessDefinitionUUID> visibleProcessUUIDs;
            String applicationName = env.getApplicationAccessName();
            if (applicationName != null && !(visibleProcessUUIDs = FacadeUtil.getAllowedProcessUUIDsFor(applicationName, Rule.RuleType.PROCESS_READ)).isEmpty()) {
                processes = EnvTool.getAllQueriers(queryList).getProcesses(visibleProcessUUIDs, fromIndex, pageSize);
            }
        } else {
            processes = EnvTool.getAllQueriers(queryList).getProcesses(fromIndex, pageSize);
        }
        return processes;
    }

    @Override
    public int getNumberOfProcesses(String queryList) throws RemoteException {
        Environment env = Environment.getCurrent();
        boolean access = env.isRestrictedApplicationAcces();
        if (!access) {
            return EnvTool.getAllQueriers(queryList).getNumberOfProcesses();
        }
        String applicationName = env.getApplicationAccessName();
        if (applicationName != null) {
            Set<ProcessDefinitionUUID> visibleProcessUUIDs = FacadeUtil.getAllowedProcessUUIDsFor(applicationName, Rule.RuleType.PROCESS_READ);
            return visibleProcessUUIDs.size();
        }
        return 0;
    }

    @Override
    public BusinessArchive getBusinessArchive(ProcessDefinitionUUID processDefinitionUUID, String queryList) throws ProcessNotFoundException, RemoteException {
        Misc.checkArgsNotNull(processDefinitionUUID);
        LargeDataRepository ldr = EnvTool.getLargeDataRepository();
        Map<String, byte[]> resources = ldr.getData(byte[].class, Misc.getBusinessArchiveCategories(processDefinitionUUID));
        BusinessArchiveImpl businessArchive = new BusinessArchiveImpl(processDefinitionUUID, resources);
        return businessArchive;
    }

    private Set<DataFieldDefinition> getDataFieldCopy(Set<DataFieldDefinition> src) {
        HashSet<DataFieldDefinition> result = new HashSet<DataFieldDefinition>();
        if (src != null) {
            for (DataFieldDefinition p : src) {
                result.add(new DataFieldDefinitionImpl(p));
            }
        }
        return result;
    }

    @Override
    public ProcessDefinition getLastProcess(String processId, String queryList) throws ProcessNotFoundException {
        FacadeUtil.checkArgsNotNull(processId);
        Environment env = Environment.getCurrent();
        boolean access = env.isRestrictedApplicationAcces();
        InternalProcessDefinition last = null;
        if (access) {
            String applicationName = env.getApplicationAccessName();
            if (applicationName == null) {
                throw new ProcessNotFoundException("bai_QDAPII_2", processId);
            }
            Set<ProcessDefinitionUUID> visibleProcessUUIDs = FacadeUtil.getAllowedProcessUUIDsFor(applicationName, Rule.RuleType.PROCESS_READ);
            if (visibleProcessUUIDs.isEmpty()) {
                throw new ProcessNotFoundException("bai_QDAPII_2", processId);
            }
            HashSet<ProcessDefinitionUUID> definitionUUIDs = new HashSet<ProcessDefinitionUUID>();
            for (ProcessDefinitionUUID processUUID : visibleProcessUUIDs) {
                if (!processId.equals(processUUID.getProcessName())) continue;
                definitionUUIDs.add(processUUID);
            }
            last = EnvTool.getAllQueriers(queryList).getLastDeployedProcess(definitionUUIDs, ProcessDefinition.ProcessState.ENABLED);
        } else {
            last = EnvTool.getAllQueriers(queryList).getLastDeployedProcess(processId, ProcessDefinition.ProcessState.ENABLED);
        }
        if (last == null) {
            throw new ProcessNotFoundException("bai_QDAPII_2", processId);
        }
        return new ProcessDefinitionImpl(last);
    }

    @Override
    public ProcessDefinition getProcess(ProcessDefinitionUUID processUUID, String queryList) throws ProcessNotFoundException {
        FacadeUtil.checkArgsNotNull(processUUID);
        InternalProcessDefinition process = EnvTool.getAllQueriers(queryList).getProcess(processUUID);
        if (process == null) {
            throw new ProcessNotFoundException("bai_QDAPII_5", processUUID);
        }
        return new ProcessDefinitionImpl(process);
    }

    @Override
    public LightProcessDefinition getLightProcess(ProcessDefinitionUUID processUUID, String queryList) throws ProcessNotFoundException {
        FacadeUtil.checkArgsNotNull(processUUID);
        InternalProcessDefinition process = EnvTool.getAllQueriers(queryList).getProcess(processUUID);
        if (process == null) {
            throw new ProcessNotFoundException("bai_QDAPII_5", processUUID);
        }
        return new LightProcessDefinitionImpl(process);
    }

    @Override
    public ProcessDefinition getProcess(String processId, String processVersion, String queryList) throws ProcessNotFoundException {
        FacadeUtil.checkArgsNotNull(processId, processVersion);
        InternalProcessDefinition process = EnvTool.getAllQueriers(queryList).getProcess(processId, processVersion);
        if (process == null) {
            throw new ProcessNotFoundException(processId, processVersion);
        }
        Environment env = Environment.getCurrent();
        boolean access = env.isRestrictedApplicationAcces();
        if (access) {
            String applicationName = env.getApplicationAccessName();
            if (applicationName == null) {
                throw new ProcessNotFoundException(processId, processVersion);
            }
            Set<ProcessDefinitionUUID> visibleProcessUUIDs = FacadeUtil.getAllowedProcessUUIDsFor(applicationName, Rule.RuleType.PROCESS_READ);
            if (visibleProcessUUIDs == null || !visibleProcessUUIDs.contains(process.getUUID())) {
                throw new ProcessNotFoundException(processId, processVersion);
            }
        }
        return new ProcessDefinitionImpl(process);
    }

    @Override
    public Set<ActivityDefinition> getProcessActivities(ProcessDefinitionUUID processUUID, String queryList) throws ProcessNotFoundException {
        FacadeUtil.checkArgsNotNull(processUUID);
        InternalProcessDefinition process = EnvTool.getAllQueriers(queryList).getProcess(processUUID);
        if (process == null) {
            throw new ProcessNotFoundException("bai_QDAPII_7", processUUID);
        }
        Set<ActivityDefinition> activities = process.getActivities();
        return this.getActivityCopy(activities);
    }

    @Override
    public ActivityDefinition getProcessActivity(ProcessDefinitionUUID processUUID, String activityId, String queryList) throws ProcessNotFoundException, ActivityNotFoundException {
        FacadeUtil.checkArgsNotNull(processUUID, activityId);
        InternalProcessDefinition process = EnvTool.getAllQueriers(queryList).getProcess(processUUID);
        if (process == null) {
            throw new ProcessNotFoundException("bai_QDAPII_8", processUUID);
        }
        Set<ActivityDefinition> activities = process.getActivities();
        if (activities != null) {
            for (ActivityDefinition activityDefinition : activities) {
                if (!activityDefinition.getName().equals(activityId)) continue;
                return new ActivityDefinitionImpl(activityDefinition);
            }
        }
        throw new ActivityNotFoundException("bai_QDAPII_9", processUUID, activityId);
    }

    @Override
    public ParticipantDefinition getProcessParticipant(ProcessDefinitionUUID processUUID, String participantId, String queryList) throws ProcessNotFoundException, ParticipantNotFoundException {
        FacadeUtil.checkArgsNotNull(processUUID, participantId);
        Set<ParticipantDefinition> participants = this.getProcessParticipants(processUUID, queryList);
        if (participants != null) {
            for (ParticipantDefinition participant : participants) {
                if (!participant.getName().equals(participantId)) continue;
                return new ParticipantDefinitionImpl(participant);
            }
        }
        throw new ParticipantNotFoundException("bai_QDAPII_10", participantId, processUUID);
    }

    @Override
    public Set<ParticipantDefinition> getProcessParticipants(ProcessDefinitionUUID processUUID, String queryList) throws ProcessNotFoundException {
        FacadeUtil.checkArgsNotNull(processUUID);
        InternalProcessDefinition process = EnvTool.getAllQueriers(queryList).getProcess(processUUID);
        if (process == null) {
            throw new ProcessNotFoundException("bai_QDAPII_11", processUUID);
        }
        Set<ParticipantDefinition> participants = process.getParticipants();
        return this.getParticipantCopy(participants);
    }

    @Override
    public Set<ProcessDefinition> getProcesses(String queryList) {
        Environment env = Environment.getCurrent();
        boolean access = env.isRestrictedApplicationAcces();
        Set<Object> processes = new HashSet();
        if (access) {
            Set<ProcessDefinitionUUID> visibleProcessUUIDs;
            String applicationName = env.getApplicationAccessName();
            if (applicationName != null && (visibleProcessUUIDs = FacadeUtil.getAllowedProcessUUIDsFor(applicationName, Rule.RuleType.PROCESS_READ)) != null && !visibleProcessUUIDs.isEmpty()) {
                processes = EnvTool.getAllQueriers(queryList).getProcesses(visibleProcessUUIDs);
            }
        } else {
            processes = EnvTool.getAllQueriers(queryList).getProcesses();
        }
        return this.getProcessCopy(processes);
    }

    @Override
    public Set<LightProcessDefinition> getLightProcesses(String queryList) throws RemoteException {
        Environment env = Environment.getCurrent();
        boolean access = env.isRestrictedApplicationAcces();
        Set<Object> processes = new HashSet();
        if (access) {
            Set<ProcessDefinitionUUID> visibleProcessUUIDs;
            String applicationName = env.getApplicationAccessName();
            if (applicationName != null && (visibleProcessUUIDs = FacadeUtil.getAllowedProcessUUIDsFor(applicationName, Rule.RuleType.PROCESS_READ)) != null && !visibleProcessUUIDs.isEmpty()) {
                processes = EnvTool.getAllQueriers(queryList).getProcesses(visibleProcessUUIDs);
            }
        } else {
            processes = EnvTool.getAllQueriers(queryList).getProcesses();
        }
        HashSet<LightProcessDefinition> result = new HashSet<LightProcessDefinition>();
        for (InternalProcessDefinition internalProcessDefinition : processes) {
            result.add(new LightProcessDefinitionImpl(internalProcessDefinition));
        }
        return result;
    }

    @Override
    public Set<ProcessDefinition> getProcesses(String processId, String queryList) {
        FacadeUtil.checkArgsNotNull(processId);
        Environment env = Environment.getCurrent();
        boolean access = env.isRestrictedApplicationAcces();
        Set<Object> processes = new HashSet();
        if (access) {
            Set<ProcessDefinitionUUID> visibleProcessUUIDs;
            String applicationName = env.getApplicationAccessName();
            if (applicationName != null && (visibleProcessUUIDs = FacadeUtil.getAllowedProcessUUIDsFor(applicationName, Rule.RuleType.PROCESS_READ)) != null && !visibleProcessUUIDs.isEmpty()) {
                HashSet<ProcessDefinitionUUID> definitionUUIDs = new HashSet<ProcessDefinitionUUID>();
                for (ProcessDefinitionUUID processUUID : visibleProcessUUIDs) {
                    if (!processId.equals(processUUID.getProcessName())) continue;
                    definitionUUIDs.add(processUUID);
                }
                processes = EnvTool.getAllQueriers(queryList).getProcesses(definitionUUIDs);
            }
        } else {
            processes = EnvTool.getAllQueriers(queryList).getProcesses(processId);
        }
        return this.getProcessCopy(processes);
    }

    @Override
    public ParticipantDefinitionUUID getProcessParticipantId(ProcessDefinitionUUID processUUID, String participantName, String queryList) throws ProcessNotFoundException {
        FacadeUtil.checkArgsNotNull(processUUID, participantName);
        Set<ParticipantDefinition> participants = this.getProcessParticipants(processUUID, queryList);
        if (participants != null) {
            for (ParticipantDefinition participant : participants) {
                if (!participantName.equals(participant.getName())) continue;
                return participant.getUUID();
            }
        }
        return null;
    }

    @Override
    public ActivityDefinitionUUID getProcessActivityId(ProcessDefinitionUUID processUUID, String activityName, String queryList) throws ProcessNotFoundException {
        FacadeUtil.checkArgsNotNull(processUUID, activityName);
        Set<ActivityDefinition> activities = this.getProcessActivities(processUUID, queryList);
        if (activities != null) {
            for (ActivityDefinition activity : activities) {
                if (!activityName.equals(activity.getName())) continue;
                return activity.getUUID();
            }
        }
        return null;
    }

    @Override
    public Set<ProcessDefinition> getProcesses(String processId, ProcessDefinition.ProcessState processState, String queryList) {
        FacadeUtil.checkArgsNotNull(new Object[]{processId, processState});
        Environment env = Environment.getCurrent();
        boolean access = env.isRestrictedApplicationAcces();
        Set<Object> processes = new HashSet();
        if (access) {
            Set<ProcessDefinitionUUID> visibleProcessUUIDs;
            String applicationName = env.getApplicationAccessName();
            if (applicationName != null && (visibleProcessUUIDs = FacadeUtil.getAllowedProcessUUIDsFor(applicationName, Rule.RuleType.PROCESS_READ)) != null && !visibleProcessUUIDs.isEmpty()) {
                HashSet<ProcessDefinitionUUID> definitionUUIDs = new HashSet<ProcessDefinitionUUID>();
                for (ProcessDefinitionUUID processUUID : visibleProcessUUIDs) {
                    if (!processId.equals(processUUID.getProcessName())) continue;
                    definitionUUIDs.add(processUUID);
                }
                processes = EnvTool.getAllQueriers(queryList).getProcesses(definitionUUIDs, processState);
            }
        } else {
            processes = EnvTool.getAllQueriers(queryList).getProcesses(processId, processState);
        }
        return this.getProcessCopy(processes);
    }

    @Override
    public Set<ProcessDefinition> getProcesses(ProcessDefinition.ProcessState processState, String queryList) {
        FacadeUtil.checkArgsNotNull(new Object[]{processState});
        Environment env = Environment.getCurrent();
        boolean access = env.isRestrictedApplicationAcces();
        Set<Object> processes = new HashSet();
        if (access) {
            Set<ProcessDefinitionUUID> visibleProcessUUIDs;
            String applicationName = env.getApplicationAccessName();
            if (applicationName != null && (visibleProcessUUIDs = FacadeUtil.getAllowedProcessUUIDsFor(applicationName, Rule.RuleType.PROCESS_READ)) != null && !visibleProcessUUIDs.isEmpty()) {
                HashSet<ProcessDefinitionUUID> definitionUUIDs = new HashSet<ProcessDefinitionUUID>();
                for (ProcessDefinitionUUID processUUID : visibleProcessUUIDs) {
                    definitionUUIDs.add(processUUID);
                }
                processes = EnvTool.getAllQueriers(queryList).getProcesses(definitionUUIDs, processState);
            }
        } else {
            processes = EnvTool.getAllQueriers(queryList).getProcesses(processState);
        }
        return this.getProcessCopy(processes);
    }

    @Override
    public Set<LightProcessDefinition> getLightProcesses(ProcessDefinition.ProcessState processState, String queryList) throws RemoteException {
        FacadeUtil.checkArgsNotNull(new Object[]{processState});
        Environment env = Environment.getCurrent();
        boolean access = env.isRestrictedApplicationAcces();
        Set<Object> processes = new HashSet();
        if (access) {
            Set<ProcessDefinitionUUID> visibleProcessUUIDs;
            String applicationName = env.getApplicationAccessName();
            if (applicationName != null && (visibleProcessUUIDs = FacadeUtil.getAllowedProcessUUIDsFor(applicationName, Rule.RuleType.PROCESS_READ)) != null && !visibleProcessUUIDs.isEmpty()) {
                HashSet<ProcessDefinitionUUID> hashSet = new HashSet<ProcessDefinitionUUID>();
                for (ProcessDefinitionUUID processUUID : visibleProcessUUIDs) {
                    hashSet.add(processUUID);
                }
                processes = EnvTool.getAllQueriers(queryList).getProcesses(hashSet, processState);
            }
        } else {
            processes = EnvTool.getAllQueriers(queryList).getProcesses(processState);
        }
        HashSet<LightProcessDefinition> result = new HashSet<LightProcessDefinition>();
        for (InternalProcessDefinition internalProcessDefinition : processes) {
            result.add(new LightProcessDefinitionImpl(internalProcessDefinition));
        }
        return result;
    }

    @Override
    public DataFieldDefinition getProcessDataField(ProcessDefinitionUUID processDefinitionUUID, String dataFieldId, String queryList) throws ProcessNotFoundException, DataFieldNotFoundException {
        FacadeUtil.checkArgsNotNull(processDefinitionUUID, dataFieldId);
        Set<DataFieldDefinition> datafields = this.getProcessDataFields(processDefinitionUUID, queryList);
        if (datafields != null) {
            for (DataFieldDefinition datefield : datafields) {
                if (!datefield.getName().equals(dataFieldId)) continue;
                return new DataFieldDefinitionImpl(datefield);
            }
        }
        throw new DataFieldNotFoundException("bai_QDAPII_14", dataFieldId, processDefinitionUUID);
    }

    @Override
    public Set<DataFieldDefinition> getProcessDataFields(ProcessDefinitionUUID processDefinitionUUID, String queryList) throws ProcessNotFoundException {
        FacadeUtil.checkArgsNotNull(processDefinitionUUID);
        InternalProcessDefinition process = EnvTool.getAllQueriers(queryList).getProcess(processDefinitionUUID);
        if (process == null) {
            throw new ProcessNotFoundException("bai_QDAPII_15", processDefinitionUUID);
        }
        Set<DataFieldDefinition> datafields = process.getDataFields();
        return this.getDataFieldCopy(datafields);
    }

    @Override
    public Set<DataFieldDefinition> getActivityDataFields(ActivityDefinitionUUID activityDefinitionUUID, String queryList) throws ActivityDefNotFoundException {
        FacadeUtil.checkArgsNotNull(activityDefinitionUUID);
        InternalActivityDefinition activity = EnvTool.getAllQueriers(queryList).getActivity(activityDefinitionUUID);
        if (activity == null) {
            throw new ActivityDefNotFoundException("bai_QDAPII_16", activityDefinitionUUID);
        }
        Set<DataFieldDefinition> datafields = activity.getDataFields();
        return this.getDataFieldCopy(datafields);
    }

    @Override
    public DataFieldDefinition getActivityDataField(ActivityDefinitionUUID activityDefinitionUUID, String dataFieldId, String queryList) throws ActivityDefNotFoundException, DataFieldNotFoundException {
        FacadeUtil.checkArgsNotNull(activityDefinitionUUID);
        InternalActivityDefinition activity = EnvTool.getAllQueriers(queryList).getActivity(activityDefinitionUUID);
        if (activity == null) {
            throw new ActivityDefNotFoundException("bai_QDAPII_17", activityDefinitionUUID);
        }
        Set<DataFieldDefinition> datafields = activity.getDataFields();
        if (datafields != null) {
            for (DataFieldDefinition datefield : datafields) {
                if (!datefield.getName().equals(dataFieldId)) continue;
                return new DataFieldDefinitionImpl(datefield);
            }
        }
        throw new DataFieldNotFoundException("bai_QDAPII_18", dataFieldId, activityDefinitionUUID);
    }

    @Override
    public String getProcessMetaData(ProcessDefinitionUUID uuid, String key, String queryList) throws RemoteException, ProcessNotFoundException {
        FacadeUtil.checkArgsNotNull(uuid, key);
        InternalProcessDefinition process = EnvTool.getAllQueriers(queryList).getProcess(uuid);
        if (process == null) {
            throw new ProcessNotFoundException("bai_QDAPII_19", uuid);
        }
        return process.getAMetaData(key);
    }

    @Override
    public InitialAttachment getProcessAttachment(ProcessDefinitionUUID processUUID, String attachmentName, String queryList) throws ProcessNotFoundException, RemoteException {
        FacadeUtil.checkArgsNotNull(processUUID, attachmentName);
        InternalProcessDefinition process = EnvTool.getAllQueriers(queryList).getProcess(processUUID);
        if (process == null) {
            throw new ProcessNotFoundException("bai_QDAPII_19", processUUID);
        }
        AttachmentDefinition attachment = process.getAttachment(attachmentName);
        if (attachment == null) {
            return null;
        }
        LargeDataRepository ldr = EnvTool.getLargeDataRepository();
        byte[] content = null;
        if (attachment.getFilePath() != null) {
            content = ldr.getData(byte[].class, Misc.getAttachmentCategories(processUUID), attachment.getFilePath());
        }
        return new InitialAttachmentImpl(attachment, content);
    }

    @Override
    public Set<InitialAttachment> getProcessAttachments(ProcessDefinitionUUID processUUID, String queryList) throws ProcessNotFoundException, RemoteException {
        FacadeUtil.checkArgsNotNull(processUUID);
        InternalProcessDefinition process = EnvTool.getAllQueriers(queryList).getProcess(processUUID);
        if (process == null) {
            throw new ProcessNotFoundException("bai_QDAPII_19", processUUID);
        }
        Map<String, AttachmentDefinition> processAttachments = process.getAttachments();
        HashSet<InitialAttachment> attachments = new HashSet<InitialAttachment>();
        if (attachments != null) {
            LargeDataRepository ldr = EnvTool.getLargeDataRepository();
            for (AttachmentDefinition processAttachment : processAttachments.values()) {
                byte[] content = null;
                if (processAttachment.getFilePath() != null) {
                    content = ldr.getData(byte[].class, Misc.getAttachmentCategories(processUUID), processAttachment.getFilePath());
                }
                attachments.add(new InitialAttachmentImpl(processAttachment, content));
            }
        }
        return attachments;
    }

    @Override
    public AttachmentDefinition getAttachmentDefinition(ProcessDefinitionUUID processUUID, String attachmentName, String queryList) throws ProcessNotFoundException, RemoteException {
        FacadeUtil.checkArgsNotNull(processUUID, attachmentName);
        InternalProcessDefinition process = EnvTool.getAllQueriers(queryList).getProcess(processUUID);
        if (process == null) {
            throw new ProcessNotFoundException("bai_QDAPII_19", processUUID);
        }
        return process.getAttachment(attachmentName);
    }

    @Override
    public Set<AttachmentDefinition> getAttachmentDefinitions(ProcessDefinitionUUID processUUID, String queryList) throws ProcessNotFoundException, RemoteException {
        FacadeUtil.checkArgsNotNull(processUUID);
        InternalProcessDefinition process = EnvTool.getAllQueriers(queryList).getProcess(processUUID);
        if (process == null) {
            throw new ProcessNotFoundException("bai_QDAPII_19", processUUID);
        }
        Map<String, AttachmentDefinition> processAttachments = process.getAttachments();
        HashSet<AttachmentDefinition> attachments = new HashSet<AttachmentDefinition>();
        if (attachments != null) {
            for (Map.Entry<String, AttachmentDefinition> processAttachment : processAttachments.entrySet()) {
                attachments.add(processAttachment.getValue());
            }
        }
        return attachments;
    }

    @Override
    public byte[] getResource(ProcessDefinitionUUID definitionUUID, String resourcePath, String queryList) throws ProcessNotFoundException, RemoteException {
        FacadeUtil.checkArgsNotNull(definitionUUID);
        InternalProcessDefinition process = EnvTool.getAllQueriers(queryList).getProcess(definitionUUID);
        if (process == null) {
            throw new ProcessNotFoundException("bai_QDAPII_19", definitionUUID);
        }
        ClassLoader classLoader = ClassDataLoader.getProcessClassLoader(definitionUUID);
        InputStream in = classLoader.getResourceAsStream(resourcePath);
        byte[] resource = null;
        if (in != null) {
            try {
                resource = Misc.getAllContentFrom(in);
                in.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return resource;
    }

    @Override
    public Set<LightProcessDefinition> getLightProcesses(Set<ProcessDefinitionUUID> processUUIDs, String queryList) throws ProcessNotFoundException, RemoteException {
        FacadeUtil.checkArgsNotNull(processUUIDs);
        Set<Object> processes = new HashSet();
        processes = EnvTool.getAllQueriers(queryList).getProcesses(processUUIDs);
        HashSet<LightProcessDefinition> result = new HashSet<LightProcessDefinition>();
        for (InternalProcessDefinition internalProcessDefinition : processes) {
            result.add(new LightProcessDefinitionImpl(internalProcessDefinition));
        }
        return result;
    }

    @Override
    public List<LightProcessDefinition> getAllLightProcessesExcept(Set<ProcessDefinitionUUID> processUUIDs, int fromIndex, int pageSize, String queryList) throws RemoteException {
        FacadeUtil.checkArgsNotNull(processUUIDs);
        if (processUUIDs.isEmpty()) {
            return this.getLightProcesses(fromIndex, pageSize, queryList);
        }
        List<Object> processes = new ArrayList();
        processes = EnvTool.getAllQueriers(queryList).getProcessesExcept(processUUIDs, fromIndex, pageSize);
        ArrayList<LightProcessDefinition> result = new ArrayList<LightProcessDefinition>();
        for (InternalProcessDefinition internalProcessDefinition : processes) {
            result.add(new LightProcessDefinitionImpl(internalProcessDefinition));
        }
        return result;
    }
}

