/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.impl;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ow2.bonita.env.Environment;
import org.ow2.bonita.facade.exception.ActivityNotFoundException;
import org.ow2.bonita.facade.exception.InstanceNotFoundException;
import org.ow2.bonita.facade.exception.TaskNotFoundException;
import org.ow2.bonita.facade.exception.VariableNotFoundException;
import org.ow2.bonita.facade.impl.FacadeUtil;
import org.ow2.bonita.facade.internal.InternalQueryRuntimeAPI;
import org.ow2.bonita.facade.privilege.Rule;
import org.ow2.bonita.facade.runtime.ActivityInstance;
import org.ow2.bonita.facade.runtime.ActivityState;
import org.ow2.bonita.facade.runtime.AttachmentInstance;
import org.ow2.bonita.facade.runtime.Comment;
import org.ow2.bonita.facade.runtime.InstanceState;
import org.ow2.bonita.facade.runtime.ProcessInstance;
import org.ow2.bonita.facade.runtime.TaskInstance;
import org.ow2.bonita.facade.runtime.VariableUpdate;
import org.ow2.bonita.facade.runtime.impl.ActivityInstanceImpl;
import org.ow2.bonita.facade.runtime.impl.AttachmentInstanceImpl;
import org.ow2.bonita.facade.runtime.impl.InternalActivityInstance;
import org.ow2.bonita.facade.runtime.impl.InternalProcessInstance;
import org.ow2.bonita.facade.runtime.impl.ProcessInstanceImpl;
import org.ow2.bonita.facade.uuid.ActivityInstanceUUID;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.light.LightActivityInstance;
import org.ow2.bonita.light.LightProcessInstance;
import org.ow2.bonita.light.LightTaskInstance;
import org.ow2.bonita.light.impl.LightActivityInstanceImpl;
import org.ow2.bonita.light.impl.LightProcessInstanceImpl;
import org.ow2.bonita.services.LargeDataRepository;
import org.ow2.bonita.services.Querier;
import org.ow2.bonita.util.CopyTool;
import org.ow2.bonita.util.EnvTool;
import org.ow2.bonita.util.ExceptionManager;
import org.ow2.bonita.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryRuntimeAPIImpl
implements InternalQueryRuntimeAPI {
    protected QueryRuntimeAPIImpl() {
    }

    @Override
    public int getNumberOfParentProcessInstances(String queryList) throws RemoteException {
        Environment env = Environment.getCurrent();
        boolean access = env.isRestrictedApplicationAcces();
        int count = 0;
        if (access) {
            String applicationName = env.getApplicationAccessName();
            Set<ProcessDefinitionUUID> visibleProcessUUIDs = FacadeUtil.getAllowedProcessUUIDsFor(applicationName, Rule.RuleType.PROCESS_READ);
            if (visibleProcessUUIDs != null) {
                count = EnvTool.getAllQueriers(queryList).getNumberOfParentProcessInstances(visibleProcessUUIDs);
            }
        } else {
            count = EnvTool.getAllQueriers(queryList).getNumberOfParentProcessInstances();
        }
        return count;
    }

    @Override
    public int getNumberOfProcessInstances(String queryList) throws RemoteException {
        Environment env = Environment.getCurrent();
        boolean access = env.isRestrictedApplicationAcces();
        int count = 0;
        if (access) {
            String applicationName = env.getApplicationAccessName();
            Set<ProcessDefinitionUUID> visibleProcessUUIDs = FacadeUtil.getAllowedProcessUUIDsFor(applicationName, Rule.RuleType.PROCESS_READ);
            if (visibleProcessUUIDs != null && !visibleProcessUUIDs.isEmpty()) {
                count = EnvTool.getAllQueriers(queryList).getNumberOfProcessInstances(visibleProcessUUIDs);
            }
        } else {
            count = EnvTool.getAllQueriers(queryList).getNumberOfProcessInstances();
        }
        return count;
    }

    @Override
    public ProcessInstance getProcessInstance(ProcessInstanceUUID instanceUUID, String queryList) throws InstanceNotFoundException {
        ProcessInstance result = this.getInternalProcessInstance(instanceUUID, queryList);
        if (result == null) {
            throw new InstanceNotFoundException("bai_QRAPII_1", instanceUUID);
        }
        return new ProcessInstanceImpl(result);
    }

    @Override
    public LightProcessInstance getLightProcessInstance(ProcessInstanceUUID instanceUUID, String queryList) throws InstanceNotFoundException, RemoteException {
        ProcessInstance result = this.getInternalProcessInstance(instanceUUID, queryList);
        if (result == null) {
            throw new InstanceNotFoundException("bai_QRAPII_1", instanceUUID);
        }
        return new LightProcessInstanceImpl(result);
    }

    ProcessInstance getInternalProcessInstance(ProcessInstanceUUID instanceUUID, String queryList) throws InstanceNotFoundException {
        FacadeUtil.checkArgsNotNull(instanceUUID);
        Querier querier = EnvTool.getAllQueriers(queryList);
        InternalProcessInstance result = querier.getProcessInstance(instanceUUID);
        return result;
    }

    @Override
    public Set<ProcessInstance> getProcessInstances(String queryList) {
        Set<InternalProcessInstance> processes = this.getInternalProcessInstances(queryList);
        HashSet<ProcessInstance> result = new HashSet<ProcessInstance>();
        for (InternalProcessInstance record : processes) {
            result.add(new ProcessInstanceImpl(record));
        }
        return result;
    }

    @Override
    public Set<LightProcessInstance> getLightProcessInstances(String queryList) throws RemoteException {
        Set<InternalProcessInstance> processes = this.getInternalProcessInstances(queryList);
        HashSet<LightProcessInstance> result = new HashSet<LightProcessInstance>();
        for (InternalProcessInstance record : processes) {
            result.add(new LightProcessInstanceImpl(record));
        }
        return result;
    }

    private Set<InternalProcessInstance> getInternalProcessInstances(String queryList) {
        Environment env = Environment.getCurrent();
        boolean access = env.isRestrictedApplicationAcces();
        Set<Object> processes = new HashSet();
        if (access) {
            Set<ProcessDefinitionUUID> visibleProcessUUIDs;
            String applicationName = env.getApplicationAccessName();
            if (applicationName != null && (visibleProcessUUIDs = FacadeUtil.getAllowedProcessUUIDsFor(applicationName, Rule.RuleType.PROCESS_READ)) != null && !visibleProcessUUIDs.isEmpty()) {
                processes = EnvTool.getAllQueriers(queryList).getProcessInstances(visibleProcessUUIDs);
            }
        } else {
            processes = EnvTool.getAllQueriers(queryList).getProcessInstances();
        }
        return processes;
    }

    @Override
    public List<LightProcessInstance> getLightProcessInstances(int fromIndex, int pageSize, String queryList) throws RemoteException {
        ArrayList<LightProcessInstance> result = new ArrayList<LightProcessInstance>();
        if (pageSize <= 0) {
            return result;
        }
        Environment env = Environment.getCurrent();
        boolean access = env.isRestrictedApplicationAcces();
        List<Object> processes = new ArrayList();
        if (access) {
            Set<ProcessDefinitionUUID> set;
            String applicationName = env.getApplicationAccessName();
            if (applicationName != null && (set = FacadeUtil.getAllowedProcessUUIDsFor(applicationName, Rule.RuleType.PROCESS_READ)) != null && !set.isEmpty()) {
                processes = EnvTool.getAllQueriers(queryList).getProcessInstances(set, fromIndex, pageSize);
            }
        } else {
            processes = EnvTool.getAllQueriers(queryList).getProcessInstances(fromIndex, pageSize);
        }
        for (InternalProcessInstance internalProcessInstance : processes) {
            result.add(new LightProcessInstanceImpl(internalProcessInstance));
        }
        return result;
    }

    @Override
    public List<LightProcessInstance> getLightParentProcessInstances(int fromIndex, int pageSize, String queryList) throws RemoteException {
        ArrayList<LightProcessInstance> result = new ArrayList<LightProcessInstance>();
        if (pageSize <= 0) {
            return result;
        }
        for (InternalProcessInstance record : EnvTool.getAllQueriers(queryList).getParentProcessInstances(fromIndex, pageSize)) {
            result.add(new LightProcessInstanceImpl(record));
        }
        return result;
    }

    @Override
    public Set<ProcessInstance> getUserInstances(String queryList) throws RemoteException {
        Set<InternalProcessInstance> processes = this.getUserProcessInstances(queryList);
        HashSet<ProcessInstance> result = new HashSet<ProcessInstance>();
        for (InternalProcessInstance record : processes) {
            result.add(new ProcessInstanceImpl(record));
        }
        return result;
    }

    @Override
    public Set<LightProcessInstance> getLightUserInstances(String queryList) throws RemoteException {
        Set<InternalProcessInstance> processes = this.getUserProcessInstances(queryList);
        HashSet<LightProcessInstance> result = new HashSet<LightProcessInstance>();
        for (InternalProcessInstance record : processes) {
            result.add(new LightProcessInstanceImpl(record));
        }
        return result;
    }

    private Set<InternalProcessInstance> getUserProcessInstances(String queryList) {
        Environment env = Environment.getCurrent();
        boolean access = env.isRestrictedApplicationAcces();
        Set<Object> processes = new HashSet();
        if (access) {
            Set<ProcessDefinitionUUID> visibleProcessUUIDs;
            String applicationName = env.getApplicationAccessName();
            if (applicationName != null && (visibleProcessUUIDs = FacadeUtil.getAllowedProcessUUIDsFor(applicationName, Rule.RuleType.PROCESS_READ)) != null && !visibleProcessUUIDs.isEmpty()) {
                processes = EnvTool.getAllQueriers(queryList).getUserInstances(EnvTool.getUserId(), visibleProcessUUIDs);
            }
        } else {
            processes = EnvTool.getAllQueriers(queryList).getUserInstances(EnvTool.getUserId());
        }
        return processes;
    }

    @Override
    public Set<ProcessInstance> getProcessInstances(Collection<ProcessInstanceUUID> instanceUUIDs, String queryList) throws RemoteException {
        HashSet<ProcessInstance> result = new HashSet<ProcessInstance>();
        if (instanceUUIDs == null || instanceUUIDs.isEmpty()) {
            return result;
        }
        for (InternalProcessInstance record : EnvTool.getAllQueriers(queryList).getProcessInstances(instanceUUIDs)) {
            result.add(new ProcessInstanceImpl(record));
        }
        return result;
    }

    @Override
    public Set<LightProcessInstance> getLightProcessInstances(Collection<ProcessInstanceUUID> instanceUUIDs, String queryList) throws RemoteException {
        HashSet<LightProcessInstance> result = new HashSet<LightProcessInstance>();
        if (instanceUUIDs == null || instanceUUIDs.isEmpty()) {
            return result;
        }
        for (InternalProcessInstance record : EnvTool.getAllQueriers(queryList).getProcessInstances(instanceUUIDs)) {
            result.add(new LightProcessInstanceImpl(record));
        }
        return result;
    }

    @Override
    public List<LightProcessInstance> getLightProcessInstances(Collection<ProcessInstanceUUID> instanceUUIDs, int fromIndex, int pageSize, String queryList) throws RemoteException {
        ArrayList<LightProcessInstance> result = new ArrayList<LightProcessInstance>();
        if (pageSize <= 0) {
            return result;
        }
        if (instanceUUIDs == null || instanceUUIDs.isEmpty()) {
            return result;
        }
        for (InternalProcessInstance record : EnvTool.getAllQueriers(queryList).getProcessInstances(instanceUUIDs, fromIndex, pageSize)) {
            result.add(new LightProcessInstanceImpl(record));
        }
        return result;
    }

    @Override
    public Set<ProcessInstance> getProcessInstancesWithTaskState(Collection<ActivityState> activityStates, String queryList) throws RemoteException {
        HashSet<ProcessInstance> result = new HashSet<ProcessInstance>();
        if (activityStates == null || activityStates.isEmpty()) {
            return result;
        }
        Environment env = Environment.getCurrent();
        boolean access = env.isRestrictedApplicationAcces();
        Set<Object> processes = new HashSet();
        if (access) {
            Set<ProcessDefinitionUUID> set;
            String applicationName = env.getApplicationAccessName();
            if (applicationName != null && (set = FacadeUtil.getAllowedProcessUUIDsFor(applicationName, Rule.RuleType.PROCESS_READ)) != null && !set.isEmpty()) {
                processes = EnvTool.getAllQueriers(queryList).getProcessInstancesWithTaskState(activityStates, set);
            }
        } else {
            processes = EnvTool.getAllQueriers(queryList).getProcessInstancesWithTaskState(activityStates);
        }
        for (InternalProcessInstance internalProcessInstance : processes) {
            result.add(new ProcessInstanceImpl(internalProcessInstance));
        }
        return result;
    }

    @Override
    public Set<ProcessInstance> getProcessInstancesWithInstanceStates(Collection<InstanceState> instanceStates, String queryList) throws RemoteException {
        Misc.checkArgsNotNull(instanceStates);
        if (instanceStates.isEmpty()) {
            throw new IllegalArgumentException(ExceptionManager.getInstance().getMessage("bai_QRAPII_15", new Object[0]));
        }
        HashSet<ProcessInstance> result = new HashSet<ProcessInstance>();
        Environment env = Environment.getCurrent();
        boolean access = env.isRestrictedApplicationAcces();
        Set<Object> processes = new HashSet();
        if (access) {
            Set<ProcessDefinitionUUID> set;
            String applicationName = env.getApplicationAccessName();
            if (applicationName != null && (set = FacadeUtil.getAllowedProcessUUIDsFor(applicationName, Rule.RuleType.PROCESS_READ)) != null && !set.isEmpty()) {
                processes = EnvTool.getAllQueriers(queryList).getProcessInstancesWithInstanceStates(instanceStates, set);
            }
        } else {
            processes = EnvTool.getAllQueriers(queryList).getProcessInstancesWithInstanceStates(instanceStates);
        }
        for (InternalProcessInstance internalProcessInstance : processes) {
            result.add(new ProcessInstanceImpl(internalProcessInstance));
        }
        return result;
    }

    @Override
    public Set<ProcessInstance> getProcessInstances(ProcessDefinitionUUID processUUID, String queryList) {
        HashSet<ProcessInstance> result = new HashSet<ProcessInstance>();
        for (InternalProcessInstance record : EnvTool.getAllQueriers(queryList).getProcessInstances(processUUID)) {
            result.add(new ProcessInstanceImpl(record));
        }
        return result;
    }

    @Override
    public Set<LightProcessInstance> getLightProcessInstances(ProcessDefinitionUUID processUUID, String queryList) throws RemoteException {
        HashSet<LightProcessInstance> result = new HashSet<LightProcessInstance>();
        for (InternalProcessInstance record : EnvTool.getAllQueriers(queryList).getProcessInstances(processUUID)) {
            result.add(new LightProcessInstanceImpl(record));
        }
        return result;
    }

    @Override
    public Set<LightProcessInstance> getLightWeightProcessInstances(Set<ProcessDefinitionUUID> processUUIDs, String queryList) throws RemoteException {
        HashSet<LightProcessInstance> result = new HashSet<LightProcessInstance>();
        for (InternalProcessInstance record : EnvTool.getAllQueriers(queryList).getProcessInstances(processUUIDs)) {
            result.add(new LightProcessInstanceImpl(record));
        }
        return result;
    }

    public ActivityInstance getActivityInstance(ProcessInstanceUUID instanceUUID, String activityId, String iterationId, String activityInstanceId, String queryList) throws ActivityNotFoundException, InstanceNotFoundException {
        InternalActivityInstance result = EnvTool.getAllQueriers(queryList).getActivityInstance(instanceUUID, activityId, iterationId, activityInstanceId);
        if (result == null) {
            if (EnvTool.getAllQueriers(queryList).getProcessInstance(instanceUUID) == null) {
                throw new InstanceNotFoundException("bai_QRAPII_2", instanceUUID);
            }
            throw new ActivityNotFoundException("bai_QRAPII_3", instanceUUID, activityId, iterationId);
        }
        return new ActivityInstanceImpl(result);
    }

    @Override
    public boolean canExecuteTask(ActivityInstanceUUID taskUUID, String queryList) throws TaskNotFoundException, RemoteException {
        TaskInstance task = this.getTask(taskUUID, queryList);
        if (task == null) {
            return false;
        }
        if (!task.getState().equals((Object)ActivityState.READY)) {
            return false;
        }
        String userId = EnvTool.getUserId();
        if (task.isTaskAssigned()) {
            return task.getTaskUser().equals(userId);
        }
        return task.getTaskCandidates().contains(userId);
    }

    @Override
    public Set<ActivityInstance> getActivityInstances(ProcessInstanceUUID instanceUUID, String queryList) {
        HashSet<ActivityInstance> result = new HashSet<ActivityInstance>();
        for (InternalActivityInstance record : EnvTool.getAllQueriers(queryList).getActivityInstances(instanceUUID)) {
            result.add(new ActivityInstanceImpl(record));
        }
        return result;
    }

    @Override
    public List<LightActivityInstance> getLightActivityInstancesFromRoot(ProcessInstanceUUID rootInstanceUUID, String queryList) throws RemoteException {
        ArrayList<LightActivityInstance> result = new ArrayList<LightActivityInstance>();
        List<InternalActivityInstance> activities = EnvTool.getAllQueriers(queryList).getActivityInstancesFromRoot(rootInstanceUUID);
        for (InternalActivityInstance record : activities) {
            result.add(new LightActivityInstanceImpl(record));
        }
        return result;
    }

    @Override
    public Map<ProcessInstanceUUID, List<LightActivityInstance>> getLightActivityInstancesFromRoot(Set<ProcessInstanceUUID> rootInstanceUUIDs, ActivityState state, String queryList) throws RemoteException {
        HashMap<ProcessInstanceUUID, List<LightActivityInstance>> result = new HashMap<ProcessInstanceUUID, List<LightActivityInstance>>();
        List<InternalActivityInstance> activities = EnvTool.getAllQueriers(queryList).getActivityInstancesFromRoot(rootInstanceUUIDs, state);
        for (InternalActivityInstance activity : activities) {
            ProcessInstanceUUID instanceUUID = activity.getRootInstanceUUID();
            if (!result.containsKey(instanceUUID)) {
                result.put(instanceUUID, new ArrayList());
            }
            ((List)result.get(instanceUUID)).add(new LightActivityInstanceImpl(activity));
        }
        return result;
    }

    @Override
    public Map<ProcessInstanceUUID, List<LightActivityInstance>> getLightActivityInstancesFromRoot(Set<ProcessInstanceUUID> rootInstanceUUIDs, String queryList) throws RemoteException {
        HashMap<ProcessInstanceUUID, List<LightActivityInstance>> result = new HashMap<ProcessInstanceUUID, List<LightActivityInstance>>();
        List<InternalActivityInstance> activities = EnvTool.getAllQueriers(queryList).getActivityInstancesFromRoot(rootInstanceUUIDs);
        for (InternalActivityInstance activity : activities) {
            ProcessInstanceUUID instanceUUID = activity.getRootInstanceUUID();
            if (!result.containsKey(instanceUUID)) {
                result.put(instanceUUID, new ArrayList());
            }
            ((List)result.get(instanceUUID)).add(new LightActivityInstanceImpl(activity));
        }
        return result;
    }

    @Override
    public Map<ProcessInstanceUUID, LightActivityInstance> getLightLastUpdatedActivityInstanceFromRoot(Set<ProcessInstanceUUID> rootInstanceUUIDs, boolean considerSystemTaks, String queryList) throws RemoteException {
        HashMap<ProcessInstanceUUID, LightActivityInstance> result = new HashMap<ProcessInstanceUUID, LightActivityInstance>();
        Map<ProcessInstanceUUID, InternalActivityInstance> temp = EnvTool.getAllQueriers(queryList).getLastUpdatedActivityInstanceFromRoot(rootInstanceUUIDs, considerSystemTaks);
        for (Map.Entry<ProcessInstanceUUID, InternalActivityInstance> entry : temp.entrySet()) {
            result.put(entry.getKey(), new LightActivityInstanceImpl(entry.getValue()));
        }
        return result;
    }

    @Override
    public List<LightTaskInstance> getLightTaskInstancesFromRoot(ProcessInstanceUUID rootInstanceUUID, String queryList) throws RemoteException {
        ArrayList<LightTaskInstance> result = new ArrayList<LightTaskInstance>();
        for (InternalActivityInstance record : EnvTool.getAllQueriers(queryList).getActivityInstancesFromRoot(rootInstanceUUID)) {
            if (!record.isTask()) continue;
            result.add(new LightActivityInstanceImpl(record));
        }
        return result;
    }

    @Override
    public Map<ProcessInstanceUUID, List<LightTaskInstance>> getLightTaskInstancesFromRoot(Set<ProcessInstanceUUID> rootInstanceUUIDs, String queryList) throws RemoteException {
        HashMap<ProcessInstanceUUID, List<LightTaskInstance>> result = new HashMap<ProcessInstanceUUID, List<LightTaskInstance>>();
        for (ProcessInstanceUUID instanceUUID : rootInstanceUUIDs) {
            result.put(instanceUUID, this.getLightTaskInstancesFromRoot(instanceUUID, queryList));
        }
        return result;
    }

    @Override
    public Set<LightActivityInstance> getLightActivityInstances(ProcessInstanceUUID instanceUUID, String queryList) throws InstanceNotFoundException, RemoteException {
        HashSet<LightActivityInstance> result = new HashSet<LightActivityInstance>();
        Set<InternalActivityInstance> activities = EnvTool.getAllQueriers(queryList).getActivityInstances(instanceUUID);
        for (InternalActivityInstance record : activities) {
            result.add(new LightActivityInstanceImpl(record));
        }
        return result;
    }

    @Override
    public Set<ActivityInstance> getActivityInstances(ProcessInstanceUUID instanceUUID, String activityId, String queryList) throws ActivityNotFoundException {
        HashSet<ActivityInstance> result = new HashSet<ActivityInstance>();
        for (InternalActivityInstance record : EnvTool.getAllQueriers(queryList).getActivityInstances(instanceUUID)) {
            if (!record.getActivityName().equals(activityId)) continue;
            result.add(new ActivityInstanceImpl(record));
        }
        if (result.isEmpty()) {
            throw new ActivityNotFoundException("bai_QRAPII_4", instanceUUID, activityId);
        }
        return result;
    }

    @Override
    public Set<LightActivityInstance> getLightActivityInstances(ProcessInstanceUUID instanceUUID, String activityName, String queryList) throws InstanceNotFoundException, ActivityNotFoundException, RemoteException {
        HashSet<LightActivityInstance> result = new HashSet<LightActivityInstance>();
        Set<InternalActivityInstance> activities = EnvTool.getAllQueriers(queryList).getActivityInstances(instanceUUID);
        for (InternalActivityInstance record : activities) {
            if (!record.getActivityName().equals(activityName)) continue;
            result.add(new LightActivityInstanceImpl(record));
        }
        if (result.isEmpty()) {
            throw new ActivityNotFoundException("bai_QRAPII_4", instanceUUID, activityName);
        }
        return result;
    }

    @Override
    public Set<LightActivityInstance> getLightActivityInstances(ProcessInstanceUUID instanceUUID, String activityName, String iterationId, String queryList) throws RemoteException {
        HashSet<LightActivityInstance> result = new HashSet<LightActivityInstance>();
        Set<InternalActivityInstance> activities = EnvTool.getAllQueriers(queryList).getActivityInstances(instanceUUID, activityName, iterationId);
        for (InternalActivityInstance record : activities) {
            result.add(new LightActivityInstanceImpl(record));
        }
        return result;
    }

    @Override
    public Set<TaskInstance> getTasks(ProcessInstanceUUID instanceUUID, String queryList) {
        HashSet<TaskInstance> result = new HashSet<TaskInstance>();
        for (TaskInstance record : EnvTool.getAllQueriers(queryList).getTaskInstances(instanceUUID)) {
            result.add(new ActivityInstanceImpl(record));
        }
        return result;
    }

    @Override
    public Set<LightTaskInstance> getLightTasks(ProcessInstanceUUID instanceUUID, String queryList) throws InstanceNotFoundException, RemoteException {
        HashSet<LightTaskInstance> result = new HashSet<LightTaskInstance>();
        for (TaskInstance record : EnvTool.getAllQueriers(queryList).getTaskInstances(instanceUUID)) {
            result.add(new LightActivityInstanceImpl(record));
        }
        return result;
    }

    @Override
    public Collection<TaskInstance> getTaskList(ProcessInstanceUUID instanceUUID, ActivityState taskState, String queryList) throws InstanceNotFoundException {
        return this.getTaskListUser(instanceUUID, EnvTool.getUserId(), taskState, queryList);
    }

    @Override
    public Collection<LightTaskInstance> getLightTaskList(ProcessInstanceUUID instanceUUID, ActivityState taskState, String queryList) throws InstanceNotFoundException {
        return this.getLightTaskListUser(instanceUUID, EnvTool.getUserId(), taskState, queryList);
    }

    @Override
    public Collection<TaskInstance> getTaskList(ProcessInstanceUUID instanceUUID, Collection<ActivityState> taskStates, String queryList) throws InstanceNotFoundException, RemoteException {
        FacadeUtil.checkArgsNotNull(instanceUUID, taskStates);
        HashSet<TaskInstance> todos = new HashSet<TaskInstance>();
        for (ActivityState taskState : taskStates) {
            Collection<TaskInstance> tasks = this.getTaskListUser(instanceUUID, EnvTool.getUserId(), taskState, queryList);
            if (tasks == null) continue;
            todos.addAll(tasks);
        }
        return todos;
    }

    @Override
    public Collection<LightTaskInstance> getLightTaskList(ProcessInstanceUUID instanceUUID, Collection<ActivityState> taskStates, String queryList) throws InstanceNotFoundException, RemoteException {
        FacadeUtil.checkArgsNotNull(instanceUUID, taskStates);
        HashSet<LightTaskInstance> todos = new HashSet<LightTaskInstance>();
        for (ActivityState taskState : taskStates) {
            Collection<LightTaskInstance> tasks = this.getLightTaskListUser(instanceUUID, EnvTool.getUserId(), taskState, queryList);
            if (tasks == null) continue;
            todos.addAll(tasks);
        }
        return todos;
    }

    @Override
    public Collection<TaskInstance> getTaskList(ActivityState taskState, String queryList) {
        return this.getTaskListUser(EnvTool.getUserId(), taskState, queryList);
    }

    @Override
    public Collection<LightTaskInstance> getLightTaskList(ActivityState taskState, String queryList) {
        return this.getLightTaskListUser(EnvTool.getUserId(), taskState, queryList);
    }

    @Override
    public TaskInstance getTask(ActivityInstanceUUID taskUUID, String queryList) throws TaskNotFoundException {
        TaskInstance taskInstance = EnvTool.getAllQueriers(queryList).getTaskInstance(taskUUID);
        if (taskInstance == null) {
            throw new TaskNotFoundException("bai_QRAPII_5", taskUUID);
        }
        return new ActivityInstanceImpl(taskInstance);
    }

    @Override
    public Set<String> getTaskCandidates(ActivityInstanceUUID taskUUID, String queryList) throws RemoteException, TaskNotFoundException {
        TaskInstance taskInstance = EnvTool.getAllQueriers(queryList).getTaskInstance(taskUUID);
        if (taskInstance == null) {
            throw new TaskNotFoundException("bai_QRAPII_5", taskUUID);
        }
        return CopyTool.copy(taskInstance.getTaskCandidates());
    }

    @Override
    public Map<ActivityInstanceUUID, Set<String>> getTaskCandidates(Set<ActivityInstanceUUID> taskUUIDs, String queryList) throws RemoteException, TaskNotFoundException {
        HashMap<ActivityInstanceUUID, Set<String>> result = new HashMap<ActivityInstanceUUID, Set<String>>();
        for (ActivityInstanceUUID taskUUID : taskUUIDs) {
            TaskInstance taskInstance = EnvTool.getAllQueriers(queryList).getTaskInstance(taskUUID);
            if (taskInstance == null) {
                throw new TaskNotFoundException("bai_QRAPII_5", taskUUID);
            }
            result.put(taskUUID, CopyTool.copy(taskInstance.getTaskCandidates()));
        }
        return result;
    }

    public Map<String, Object> getActivityInstanceVariables(ProcessInstanceUUID instanceUUID, String activityId, String iterationId, String activityInstanceId, String queryList) throws ActivityNotFoundException, InstanceNotFoundException {
        ActivityInstance activityInst = this.getActivityInstance(instanceUUID, activityId, iterationId, activityInstanceId, queryList);
        if (activityInst == null) {
            throw new ActivityNotFoundException("bai_QRAPII_6", instanceUUID, activityId);
        }
        Map<String, Object> variables = activityInst.getLastKnownVariableValues();
        return variables;
    }

    public Object getActivityInstanceVariable(ProcessInstanceUUID instanceUUID, String activityId, String iterationId, String activityInstanceId, String variableId, String queryList) throws InstanceNotFoundException, ActivityNotFoundException, VariableNotFoundException {
        Map<String, Object> variables = this.getActivityInstanceVariables(instanceUUID, activityId, iterationId, activityInstanceId, queryList);
        if (variables == null || !variables.containsKey(variableId)) {
            throw new VariableNotFoundException("bai_QRAPII_7", instanceUUID, activityId, variableId);
        }
        return variables.get(variableId);
    }

    @Override
    public Map<String, Object> getProcessInstanceVariables(ProcessInstanceUUID instanceUUID, String queryList) throws InstanceNotFoundException {
        ProcessInstance processInstance = this.getInternalProcessInstance(instanceUUID, queryList);
        if (processInstance == null) {
            throw new InstanceNotFoundException("bai_QRAPII_8", instanceUUID);
        }
        return processInstance.getLastKnownVariableValues();
    }

    private Map<String, Object> getProcessInstanceVariables(ProcessInstanceUUID instanceUUID, String queryList, Date maxDate) throws InstanceNotFoundException {
        ProcessInstance processInstance = this.getInternalProcessInstance(instanceUUID, queryList);
        Map<String, Object> instanceInitialVars = processInstance.getInitialVariableValues();
        HashMap<String, Object> instanceVarBeforeMaxDate = new HashMap<String, Object>();
        instanceVarBeforeMaxDate.putAll(instanceInitialVars);
        HashMap<String, VariableUpdate> maxVarUpdates = new HashMap<String, VariableUpdate>();
        for (VariableUpdate varUpdate : processInstance.getVariableUpdates()) {
            VariableUpdate currentMax;
            if (varUpdate.getDate().getTime() > maxDate.getTime() || (currentMax = (VariableUpdate)maxVarUpdates.get(varUpdate.getName())) != null && currentMax.getDate().getTime() > varUpdate.getDate().getTime()) continue;
            maxVarUpdates.put(varUpdate.getName(), varUpdate);
            instanceVarBeforeMaxDate.put(varUpdate.getName(), varUpdate.getValue());
        }
        return instanceVarBeforeMaxDate;
    }

    private Object getProcessInstanceVariable(ProcessInstanceUUID instanceUUID, String variableId, String queryList, Date maxDate) throws InstanceNotFoundException, VariableNotFoundException {
        Map<String, Object> variables = this.getProcessInstanceVariables(instanceUUID, queryList, maxDate);
        if (variables == null || !variables.containsKey(variableId)) {
            throw new VariableNotFoundException("bai_QRAPII_9", instanceUUID, variableId);
        }
        return variables.get(variableId);
    }

    @Override
    public Object getProcessInstanceVariable(ProcessInstanceUUID instanceUUID, String variableId, String queryList) throws InstanceNotFoundException, VariableNotFoundException {
        Map<String, Object> variables = this.getProcessInstanceVariables(instanceUUID, queryList);
        if (variables == null || !variables.containsKey(variableId)) {
            throw new VariableNotFoundException("bai_QRAPII_10", instanceUUID, variableId);
        }
        return variables.get(variableId);
    }

    @Override
    public ActivityInstance getActivityInstance(ActivityInstanceUUID activityUUID, String queryList) throws ActivityNotFoundException {
        InternalActivityInstance activity = EnvTool.getAllQueriers(queryList).getActivityInstance(activityUUID);
        if (activity == null) {
            throw new ActivityNotFoundException("bai_QRAPII_11", activityUUID);
        }
        return new ActivityInstanceImpl(activity);
    }

    @Override
    public ActivityState getActivityInstanceState(ActivityInstanceUUID activityUUID, String queryList) throws ActivityNotFoundException {
        FacadeUtil.checkArgsNotNull(activityUUID);
        Querier querier = EnvTool.getAllQueriers(queryList);
        ActivityState state = querier.getActivityInstanceState(activityUUID);
        if (state == null) {
            throw new ActivityNotFoundException("bai_QRAPII_3", activityUUID.getProcessInstanceUUID(), activityUUID.getActivityName());
        }
        return state;
    }

    @Override
    public Object getActivityInstanceVariable(ActivityInstanceUUID activityUUID, String variableId, String queryList) throws ActivityNotFoundException, VariableNotFoundException {
        ActivityInstance activity = this.getActivityInstance(activityUUID, queryList);
        Map<String, Object> variableValues = activity.getLastKnownVariableValues();
        if (!variableValues.containsKey(variableId)) {
            throw new VariableNotFoundException("bai_QRAPII_12", activityUUID, variableId);
        }
        return activity.getLastKnownVariableValues().get(variableId);
    }

    @Override
    public Map<String, Object> getActivityInstanceVariables(ActivityInstanceUUID activityUUID, String queryList) throws ActivityNotFoundException {
        ActivityInstance activity = this.getActivityInstance(activityUUID, queryList);
        return activity.getLastKnownVariableValues();
    }

    @Override
    public Collection<TaskInstance> getTaskList(ProcessInstanceUUID instanceUUID, String userId, ActivityState taskState, String queryList) throws InstanceNotFoundException {
        return this.getTaskListUser(instanceUUID, userId, taskState, queryList);
    }

    @Override
    public Collection<LightTaskInstance> getLightTaskList(ProcessInstanceUUID instanceUUID, String userId, ActivityState taskState, String queryList) throws InstanceNotFoundException {
        return this.getLightTaskListUser(instanceUUID, userId, taskState, queryList);
    }

    @Override
    public Collection<TaskInstance> getTaskList(String userId, ActivityState taskState, String queryList) {
        return this.getTaskListUser(userId, taskState, queryList);
    }

    @Override
    public Collection<LightTaskInstance> getLightTaskList(String userId, ActivityState taskState, String queryList) {
        return this.getLightTaskListUser(userId, taskState, queryList);
    }

    @Override
    public ActivityInstanceUUID getOneTask(ActivityState taskState, String queryList) throws RemoteException {
        Querier journal = EnvTool.getJournalQueriers(queryList);
        Environment env = Environment.getCurrent();
        boolean access = env.isRestrictedApplicationAcces();
        TaskInstance task = null;
        if (access) {
            Set<ProcessDefinitionUUID> visibleProcessUUIDs;
            String applicationName = env.getApplicationAccessName();
            if (applicationName != null && (visibleProcessUUIDs = FacadeUtil.getAllowedProcessUUIDsFor(applicationName, Rule.RuleType.PROCESS_READ)) != null && !visibleProcessUUIDs.isEmpty()) {
                task = journal.getOneTask(EnvTool.getUserId(), taskState, visibleProcessUUIDs);
            }
        } else {
            task = journal.getOneTask(EnvTool.getUserId(), taskState);
        }
        if (task == null) {
            return null;
        }
        return new ActivityInstanceUUID(task.getUUID());
    }

    @Override
    public ActivityInstanceUUID getOneTask(ProcessInstanceUUID instanceUUID, ActivityState taskState, String queryList) throws RemoteException {
        Querier journal = EnvTool.getJournalQueriers(queryList);
        TaskInstance task = journal.getOneTask(EnvTool.getUserId(), instanceUUID, taskState);
        if (task == null) {
            return null;
        }
        return new ActivityInstanceUUID(task.getUUID());
    }

    @Override
    public ActivityInstanceUUID getOneTask(ProcessDefinitionUUID processUUID, ActivityState taskState, String queryList) throws RemoteException {
        Querier journal = EnvTool.getJournalQueriers(queryList);
        TaskInstance task = journal.getOneTask(EnvTool.getUserId(), processUUID, taskState);
        if (task == null) {
            return null;
        }
        return new ActivityInstanceUUID(task.getUUID());
    }

    private Collection<TaskInstance> getTaskListUser(ProcessInstanceUUID instanceUUID, String userId, ActivityState taskState, String queryList) throws InstanceNotFoundException {
        ArrayList<TaskInstance> todos = new ArrayList<TaskInstance>();
        for (TaskInstance taskActivity : this.getInternalTaskListUser(instanceUUID, userId, taskState, queryList)) {
            todos.add(new ActivityInstanceImpl(taskActivity));
        }
        return todos;
    }

    private Collection<LightTaskInstance> getLightTaskListUser(ProcessInstanceUUID instanceUUID, String userId, ActivityState taskState, String queryList) throws InstanceNotFoundException {
        ArrayList<LightTaskInstance> todos = new ArrayList<LightTaskInstance>();
        for (TaskInstance taskActivity : this.getInternalTaskListUser(instanceUUID, userId, taskState, queryList)) {
            todos.add(new LightActivityInstanceImpl(taskActivity));
        }
        return todos;
    }

    private Collection<TaskInstance> getInternalTaskListUser(ProcessInstanceUUID instanceUUID, String userId, ActivityState taskState, String queryList) throws InstanceNotFoundException {
        FacadeUtil.checkArgsNotNull(new Object[]{instanceUUID, taskState, userId});
        ProcessInstance processInstance = this.getInternalProcessInstance(instanceUUID, queryList);
        if (processInstance == null) {
            throw new InstanceNotFoundException("bai_QRAPII_13", instanceUUID);
        }
        Querier journal = EnvTool.getAllQueriers(queryList);
        return journal.getUserInstanceTasks(userId, instanceUUID, taskState);
    }

    private Collection<TaskInstance> getTaskListUser(String userId, ActivityState taskState, String queryList) {
        HashSet<TaskInstance> result = new HashSet<TaskInstance>();
        for (TaskInstance taskInstance : this.getInternalTaskListUser(userId, taskState, queryList)) {
            result.add(new ActivityInstanceImpl(taskInstance));
        }
        return result;
    }

    private Collection<LightTaskInstance> getLightTaskListUser(String userId, ActivityState taskState, String queryList) {
        HashSet<LightTaskInstance> result = new HashSet<LightTaskInstance>();
        for (TaskInstance taskInstance : this.getInternalTaskListUser(userId, taskState, queryList)) {
            result.add(new LightActivityInstanceImpl(taskInstance));
        }
        return result;
    }

    private Collection<TaskInstance> getInternalTaskListUser(String userId, ActivityState taskState, String queryList) {
        FacadeUtil.checkArgsNotNull(new Object[]{userId, taskState});
        Environment env = Environment.getCurrent();
        boolean access = env.isRestrictedApplicationAcces();
        Set<Object> tasks = new HashSet();
        if (access) {
            Set<ProcessDefinitionUUID> visibleProcessUUIDs;
            String applicationName = env.getApplicationAccessName();
            if (applicationName != null && (visibleProcessUUIDs = FacadeUtil.getAllowedProcessUUIDsFor(applicationName, Rule.RuleType.PROCESS_READ)) != null && !visibleProcessUUIDs.isEmpty()) {
                tasks = EnvTool.getAllQueriers(queryList).getUserTasks(userId, taskState, visibleProcessUUIDs);
            }
        } else {
            tasks = EnvTool.getAllQueriers(queryList).getUserTasks(userId, taskState);
        }
        return tasks;
    }

    @Override
    public Object getVariable(ActivityInstanceUUID activityUUID, String variableId, String queryList) throws ActivityNotFoundException, VariableNotFoundException {
        try {
            return this.getActivityInstanceVariable(activityUUID, variableId, queryList);
        }
        catch (VariableNotFoundException e) {
            ActivityInstance activity = this.getActivityInstance(activityUUID, queryList);
            Date maxDate = this.getMaxDate(activity);
            try {
                return this.getProcessInstanceVariable(activity.getProcessInstanceUUID(), variableId, queryList, maxDate);
            }
            catch (InstanceNotFoundException e1) {
                Misc.unreachableStatement();
                return null;
            }
        }
    }

    @Override
    public Map<String, Object> getVariables(ActivityInstanceUUID activityUUID, String queryList) throws ActivityNotFoundException {
        InternalActivityInstance activity = EnvTool.getAllQueriers(queryList).getActivityInstance(activityUUID);
        if (activity == null) {
            throw new ActivityNotFoundException("bai_QRAPII_14", activityUUID);
        }
        Date maxDate = this.getMaxDate(activity);
        try {
            HashMap<String, Object> allVariables = new HashMap<String, Object>();
            Map<String, Object> localVariables = activity.getLastKnownVariableValues();
            Map<String, Object> globalVariables = this.getProcessInstanceVariables(activity.getProcessInstanceUUID(), queryList, maxDate);
            allVariables.putAll(globalVariables);
            allVariables.putAll(localVariables);
            return allVariables;
        }
        catch (InstanceNotFoundException e) {
            Misc.unreachableStatement();
            return null;
        }
    }

    private Date getMaxDate(ActivityInstance activity) {
        Date endedDate = activity.getEndedDate();
        if (endedDate == null) {
            return new Date();
        }
        return endedDate;
    }

    @Override
    public Set<String> getAttachmentNames(ProcessInstanceUUID instanceUUID, String queryList) throws RemoteException {
        FacadeUtil.checkArgsNotNull(instanceUUID);
        HashSet<String> result = new HashSet<String>();
        InternalProcessInstance instance = EnvTool.getAllQueriers(queryList).getProcessInstance(instanceUUID);
        List<AttachmentInstance> attachmentInstances = instance.getAttachments();
        for (AttachmentInstance attachmentInstance : attachmentInstances) {
            result.add(attachmentInstance.getName());
        }
        return result;
    }

    @Override
    public AttachmentInstance getLastAttachment(ProcessInstanceUUID instanceUUID, String attachmentName, String queryList) throws RemoteException {
        FacadeUtil.checkArgsNotNull(instanceUUID, attachmentName);
        InternalProcessInstance instance = EnvTool.getAllQueriers(queryList).getProcessInstance(instanceUUID);
        List<AttachmentInstance> matchingAttachments = instance.getAttachments(attachmentName);
        if (matchingAttachments.isEmpty()) {
            return null;
        }
        return new AttachmentInstanceImpl(matchingAttachments.get(matchingAttachments.size() - 1));
    }

    @Override
    public AttachmentInstance getLastAttachment(ProcessInstanceUUID instanceUUID, String attachmentName, ActivityInstanceUUID activityUUID, String queryList) throws RemoteException, ActivityNotFoundException {
        ActivityInstance activity = this.getActivityInstance(activityUUID, queryList);
        Date date = null;
        date = !activity.getState().equals((Object)ActivityState.READY) && !activity.getState().equals((Object)ActivityState.SUSPENDED) && !activity.getState().equals((Object)ActivityState.EXECUTING) ? activity.getLastStateUpdate().getUpdatedDate() : new Date();
        return this.getLastAttachment(instanceUUID, attachmentName, date, queryList);
    }

    @Override
    public AttachmentInstance getLastAttachment(ProcessInstanceUUID instanceUUID, String attachmentName, Date date, String queryList) throws RemoteException {
        FacadeUtil.checkArgsNotNull(instanceUUID, attachmentName, date);
        AttachmentInstance result = null;
        InternalProcessInstance instance = EnvTool.getAllQueriers(queryList).getProcessInstance(instanceUUID);
        List<AttachmentInstance> matchingAttachments = instance.getAttachments(attachmentName);
        for (int i = 0; i < matchingAttachments.size(); ++i) {
            if (result != null && matchingAttachments.get(i).getVersionDate().getTime() > date.getTime()) continue;
            result = matchingAttachments.get(i);
        }
        if (result == null) {
            return null;
        }
        return new AttachmentInstanceImpl(result);
    }

    @Override
    public Collection<AttachmentInstance> getLastAttachments(ProcessInstanceUUID instanceUUID, Set<String> attachmentNames, String queryList) throws RemoteException {
        FacadeUtil.checkArgsNotNull(instanceUUID, attachmentNames);
        HashSet<AttachmentInstance> result = new HashSet<AttachmentInstance>();
        for (String attachmentName : attachmentNames) {
            AttachmentInstance attachmentInstance = this.getLastAttachment(instanceUUID, attachmentName, queryList);
            if (attachmentInstance == null) continue;
            result.add(attachmentInstance);
        }
        return result;
    }

    @Override
    public Collection<AttachmentInstance> getLastAttachments(ProcessInstanceUUID instanceUUID, String regex, String queryList) throws RemoteException {
        FacadeUtil.checkArgsNotNull(instanceUUID, regex);
        InternalProcessInstance instance = EnvTool.getAllQueriers(queryList).getProcessInstance(instanceUUID);
        List<AttachmentInstance> matchingAttachments = instance.getAttachments();
        HashMap<String, AttachmentInstanceImpl> result = new HashMap<String, AttachmentInstanceImpl>();
        for (AttachmentInstance attachmentInstance : matchingAttachments) {
            if (!attachmentInstance.getName().matches(regex)) continue;
            result.put(attachmentInstance.getName(), new AttachmentInstanceImpl(attachmentInstance));
        }
        return result.values();
    }

    @Override
    public List<AttachmentInstance> getAttachments(ProcessInstanceUUID instanceUUID, String attachmentName, String queryList) throws RemoteException {
        FacadeUtil.checkArgsNotNull(instanceUUID, attachmentName);
        InternalProcessInstance instance = EnvTool.getAllQueriers(queryList).getProcessInstance(instanceUUID);
        ArrayList<AttachmentInstance> attachments = new ArrayList<AttachmentInstance>();
        for (AttachmentInstance attachmentInstance : instance.getAttachments(attachmentName)) {
            attachments.add(new AttachmentInstanceImpl(attachmentInstance));
        }
        return attachments;
    }

    @Override
    public byte[] getAttachmentValue(AttachmentInstance attachmentInstance, String queryList) throws RemoteException {
        LargeDataRepository largeDataRepository = EnvTool.getLargeDataRepository();
        String key = Misc.getAttachmentIndexName(attachmentInstance.getName(), attachmentInstance.getVersionDate());
        List<String> categories = Misc.getAttachmentCategories(attachmentInstance.getProcessInstanceUUID());
        return largeDataRepository.getData(byte[].class, categories, key);
    }

    @Override
    public List<Comment> getCommentFeed(ProcessInstanceUUID instanceUUID, String queryList) throws RemoteException {
        List<Comment> comments = EnvTool.getAllQueriers(queryList).getCommentFeed(instanceUUID);
        return new ArrayList<Comment>(comments);
    }

    @Override
    public List<Comment> getActivityInstanceCommentFeed(ActivityInstanceUUID activityUUID, String queryList) throws RemoteException {
        FacadeUtil.checkArgsNotNull(activityUUID);
        List<Comment> comments = EnvTool.getAllQueriers(queryList).getActivityInstanceCommentFeed(activityUUID);
        return new ArrayList<Comment>(comments);
    }

    @Override
    public int getNumberOfActivityInstanceComments(ActivityInstanceUUID activityUUID, String queryList) throws RemoteException {
        return EnvTool.getAllQueriers(queryList).getNumberOfActivityInstanceComments(activityUUID);
    }

    @Override
    public Map<ActivityInstanceUUID, Integer> getNumberOfActivityInstanceComments(Set<ActivityInstanceUUID> activityUUIDs, String queryList) throws RemoteException {
        if (activityUUIDs == null || activityUUIDs.isEmpty()) {
            return Collections.emptyMap();
        }
        return EnvTool.getAllQueriers(queryList).getNumberOfActivityInstanceComments(activityUUIDs);
    }

    @Override
    public int getNumberOfComments(ProcessInstanceUUID instanceUUID, String queryList) throws InstanceNotFoundException, RemoteException {
        return EnvTool.getAllQueriers(queryList).getNumberOfComments(instanceUUID);
    }

    @Override
    public int getNumberOfProcessInstanceComments(ProcessInstanceUUID instanceUUID, String queryList) throws RemoteException {
        return EnvTool.getAllQueriers(queryList).getNumberOfProcessInstanceComments(instanceUUID);
    }

    @Override
    public List<Comment> getProcessInstanceCommentFeed(ProcessInstanceUUID instanceUUID, String queryList) throws RemoteException {
        FacadeUtil.checkArgsNotNull(instanceUUID);
        List<Comment> comments = EnvTool.getAllQueriers(queryList).getProcessInstanceCommentFeed(instanceUUID);
        return new ArrayList<Comment>(comments);
    }

    @Override
    public LightTaskInstance getLightTaskInstance(ActivityInstanceUUID taskUUID, String queryList) throws TaskNotFoundException, RemoteException {
        TaskInstance taskInstance = EnvTool.getAllQueriers(queryList).getTaskInstance(taskUUID);
        if (taskInstance == null) {
            throw new TaskNotFoundException("bai_QRAPII_5", taskUUID);
        }
        return new LightActivityInstanceImpl(taskInstance);
    }

    @Override
    public LightActivityInstance getLightActivityInstance(ActivityInstanceUUID activityInstanceUUID, String queryList) throws ActivityNotFoundException, RemoteException {
        InternalActivityInstance activityInstance = EnvTool.getAllQueriers(queryList).getActivityInstance(activityInstanceUUID);
        if (activityInstance == null) {
            throw new ActivityNotFoundException("bai_QRAPII_11", activityInstanceUUID);
        }
        return new LightActivityInstanceImpl(activityInstance);
    }
}

