/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.impl;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.facade.def.InternalActivityDefinition;
import org.ow2.bonita.facade.def.InternalProcessDefinition;
import org.ow2.bonita.facade.def.element.impl.AttachmentDefinitionImpl;
import org.ow2.bonita.facade.def.majorElement.ActivityDefinition;
import org.ow2.bonita.facade.def.majorElement.TransitionDefinition;
import org.ow2.bonita.facade.def.majorElement.impl.ActivityDefinitionImpl;
import org.ow2.bonita.facade.exception.ActivityNotFoundException;
import org.ow2.bonita.facade.exception.InstanceNotFoundException;
import org.ow2.bonita.facade.exception.ProcessNotFoundException;
import org.ow2.bonita.facade.exception.VariableNotFoundException;
import org.ow2.bonita.facade.impl.FacadeUtil;
import org.ow2.bonita.facade.internal.InternalRepairAPI;
import org.ow2.bonita.facade.runtime.AttachmentInstance;
import org.ow2.bonita.facade.runtime.InitialAttachment;
import org.ow2.bonita.facade.runtime.VariableUpdate;
import org.ow2.bonita.facade.runtime.impl.InitialAttachmentImpl;
import org.ow2.bonita.facade.runtime.impl.InternalProcessInstance;
import org.ow2.bonita.facade.uuid.ActivityInstanceUUID;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.runtime.model.ExecuteNode;
import org.ow2.bonita.runtime.model.Execution;
import org.ow2.bonita.services.LargeDataRepository;
import org.ow2.bonita.services.Recorder;
import org.ow2.bonita.util.EnvTool;
import org.ow2.bonita.util.Misc;
import org.ow2.bonita.util.ProcessUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepairAPIImpl
implements InternalRepairAPI {
    private static final Logger LOG = Logger.getLogger(RepairAPIImpl.class.getName());

    protected RepairAPIImpl() {
    }

    @Override
    public ProcessInstanceUUID copyProcessInstance(ProcessInstanceUUID instanceUUID, Map<String, Object> processVariables, Collection<InitialAttachment> attachments) throws RemoteException, InstanceNotFoundException, VariableNotFoundException {
        return this.copyProcessInstance(instanceUUID, processVariables, attachments, null);
    }

    @Override
    public ProcessInstanceUUID copyProcessInstance(ProcessInstanceUUID instanceUUID, Map<String, Object> processVariables, Collection<InitialAttachment> attachments, Date restoreVariableValuesAtDate) throws RemoteException, InstanceNotFoundException, VariableNotFoundException {
        FacadeUtil.checkArgsNotNull(instanceUUID);
        InternalProcessInstance processInstance = EnvTool.getJournalQueriers().getProcessInstance(instanceUUID);
        if (processInstance == null) {
            throw new InstanceNotFoundException("bai_REAPII_1", instanceUUID);
        }
        InternalProcessDefinition processDefinition = EnvTool.getJournalQueriers().getProcess(processInstance.getProcessDefinitionUUID());
        ArrayList<String> activitiesNames = new ArrayList<String>();
        Set<Execution> activiesExecutions = this.searchActiveExecutions(processInstance.getRootExecution(), null, Execution.STATE_ACTIVE);
        for (Execution execution : activiesExecutions) {
            if (processInstance.getActivities(execution.getNodeName()).isEmpty()) continue;
            activitiesNames.add(execution.getNodeName());
        }
        Map<String, Object> variablesToSet = null;
        if (restoreVariableValuesAtDate == null) {
            variablesToSet = processInstance.getLastKnownVariableValues();
        } else {
            variablesToSet = processInstance.getInitialVariableValues();
            List<VariableUpdate> VariablesUpdates = processInstance.getVariableUpdates();
            for (VariableUpdate variableUpdate : VariablesUpdates) {
                if (variableUpdate.getDate().getTime() > restoreVariableValuesAtDate.getTime()) continue;
                variablesToSet.put(variableUpdate.getName(), variableUpdate.getValue());
            }
        }
        if (processVariables != null) {
            variablesToSet.putAll(processVariables);
        }
        HashMap<String, InitialAttachment> attachmentsToSet = new HashMap<String, InitialAttachment>();
        List<AttachmentInstance> attachmentInstances = processInstance.getAttachments();
        for (AttachmentInstance attachmentInstance : attachmentInstances) {
            if (restoreVariableValuesAtDate != null && attachmentInstance.getVersionDate().getTime() > restoreVariableValuesAtDate.getTime()) continue;
            AttachmentDefinitionImpl attachmentDefinition = new AttachmentDefinitionImpl(processDefinition.getUUID(), attachmentInstance.getName());
            attachmentDefinition.setDescription(attachmentInstance.getDescription());
            attachmentDefinition.setFileName(attachmentInstance.getFileName());
            attachmentDefinition.setLabel(attachmentInstance.getLabel());
            LargeDataRepository largeDataRepository = EnvTool.getLargeDataRepository();
            String key = Misc.getAttachmentIndexName(attachmentInstance.getName(), attachmentInstance.getVersionDate());
            List<String> categories = Misc.getAttachmentCategories(attachmentInstance.getProcessInstanceUUID());
            byte[] attachmentValue = largeDataRepository.getData(byte[].class, categories, key);
            InitialAttachmentImpl initialAttachment = new InitialAttachmentImpl(attachmentDefinition, attachmentValue);
            attachmentsToSet.put(attachmentDefinition.getName(), initialAttachment);
        }
        if (attachments != null) {
            for (InitialAttachment attachment : attachments) {
                attachmentsToSet.put(attachment.getName(), attachment);
            }
        }
        String instanceInitiator = processInstance.getStartedBy();
        ProcessInstanceUUID processInstanceCopyUUID = null;
        try {
            processInstanceCopyUUID = this.instantiateProcess(instanceUUID.getProcessDefinitionUUID(), variablesToSet, attachmentsToSet.values(), activitiesNames, instanceInitiator);
        }
        catch (ProcessNotFoundException e) {
            LOG.severe("Process instance " + processDefinition.getUUID() + " not found.");
        }
        catch (ActivityNotFoundException e) {
            LOG.severe("Unable to start an execution of activity. Activity " + e.getActivityId() + " not found.");
        }
        return processInstanceCopyUUID;
    }

    @Override
    public ProcessInstanceUUID instantiateProcess(ProcessDefinitionUUID processDefinitionUUID, Map<String, Object> processVariables, Collection<InitialAttachment> attachments, List<String> startActivitiesNames) throws RemoteException, ProcessNotFoundException, VariableNotFoundException, ActivityNotFoundException {
        return this.instantiateProcess(processDefinitionUUID, processVariables, attachments, startActivitiesNames, EnvTool.getUserId());
    }

    @Override
    public ProcessInstanceUUID instantiateProcess(ProcessDefinitionUUID processDefinitionUUID, Map<String, Object> processVariables, Collection<InitialAttachment> attachments, List<String> startActivitiesNames, String instanceInitiator) throws RemoteException, ProcessNotFoundException, VariableNotFoundException, ActivityNotFoundException {
        FacadeUtil.checkArgsNotNull(processDefinitionUUID);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Starting a new instance of process : " + processDefinitionUUID);
        }
        Execution rootExecution = ProcessUtil.createProcessInstance(processDefinitionUUID, processVariables, attachments, null, null);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Started: " + rootExecution.getInstance());
        }
        Recorder recorder = EnvTool.getRecorder();
        recorder.recordInstanceStarted(rootExecution.getInstance(), instanceInitiator);
        ProcessInstanceUUID processInstanceUUID = rootExecution.getInstance().getUUID();
        if (startActivitiesNames != null) {
            HashSet<String> executionsAlreadyStarted = new HashSet<String>();
            for (String activityName : startActivitiesNames) {
                if (!executionsAlreadyStarted.contains(activityName)) {
                    try {
                        this.startExecution(processInstanceUUID, activityName);
                        executionsAlreadyStarted.add(activityName);
                    }
                    catch (InstanceNotFoundException e) {
                        LOG.severe("Unable to start an execution of " + activityName + " in process instance " + processInstanceUUID + ". Process instance not found.");
                    }
                    continue;
                }
                LOG.warning("Unable to start a second execution of " + activityName + " in process instance " + processInstanceUUID + ". Another execution of this activity is already active.");
            }
        }
        return processInstanceUUID;
    }

    @Override
    public ActivityInstanceUUID startExecution(ProcessInstanceUUID instanceUUID, String activityName) throws RemoteException, InstanceNotFoundException, ActivityNotFoundException, VariableNotFoundException {
        FacadeUtil.checkArgsNotNull(instanceUUID, activityName);
        InternalProcessInstance processInstance = EnvTool.getJournalQueriers().getProcessInstance(instanceUUID);
        if (processInstance == null) {
            throw new InstanceNotFoundException("bai_REAPII_1", instanceUUID);
        }
        InternalProcessDefinition processDefinition = EnvTool.getJournalQueriers().getProcess(processInstance.getProcessDefinitionUUID());
        ActivityDefinitionImpl activityDefinition = null;
        Set<ActivityDefinition> activities = processDefinition.getActivities();
        if (activities != null) {
            for (ActivityDefinition activity : activities) {
                if (!activity.getName().equals(activityName)) continue;
                activityDefinition = (InternalActivityDefinition)activity;
                break;
            }
        }
        if (activityDefinition == null) {
            throw new ActivityNotFoundException("bai_REAPII_2", processDefinition.getUUID(), activityName);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Starting a new execution of activity " + activityName + " of process instance " + processInstance.getProcessDefinitionUUID());
        }
        Set<TransitionDefinition> incomingTransitions = activityDefinition.getIncomingTransitions();
        for (TransitionDefinition transitionDefinition : incomingTransitions) {
            InternalProcessInstance.TransitionState ts = processInstance.getTransitionState(transitionDefinition.getName());
            if (ts != null && ts.equals((Object)InternalProcessInstance.TransitionState.TAKEN)) continue;
            processInstance.setTransitionState(transitionDefinition.getName(), InternalProcessInstance.TransitionState.TAKEN);
        }
        Execution execution = new Execution(activityName, processDefinition, processInstance, (InternalActivityDefinition)activityDefinition, Execution.STATE_CREATED, null);
        execution.setIterationId(Misc.getUniqueId("it"));
        execution.setState(Execution.STATE_ACTIVE);
        Execution rootExecution = processInstance.getRootExecution();
        rootExecution.addExecution(execution);
        execution.performAtomicOperation(new ExecuteNode(), false);
        for (Execution child : execution.getExecutions()) {
            if (child.getActivityInstanceUUID() == null) continue;
            return child.getActivityInstanceUUID();
        }
        return null;
    }

    @Override
    public void stopExecution(ProcessInstanceUUID instanceUUID, String activityName) throws RemoteException, InstanceNotFoundException, ActivityNotFoundException {
        FacadeUtil.checkArgsNotNull(instanceUUID, activityName);
        InternalProcessInstance processInstance = EnvTool.getJournalQueriers().getProcessInstance(instanceUUID);
        if (processInstance == null) {
            throw new InstanceNotFoundException("bai_REAPII_1", instanceUUID);
        }
        Set<Execution> activiesExecutions = this.searchActiveExecutions(processInstance.getRootExecution(), activityName, null);
        for (Execution execution : activiesExecutions) {
            if (Execution.STATE_CANCELLED.equals(execution.getState()) || Execution.STATE_ENDED.equals(execution.getState())) continue;
            execution.setState(Execution.STATE_ACTIVE);
            execution.cancel();
        }
    }

    private Set<Execution> searchActiveExecutions(Execution parentExecution, String activityName, String executionState) {
        HashSet<Execution> result = new HashSet<Execution>();
        for (Execution execution : parentExecution.getExecutions()) {
            if ((activityName == null || execution.getName().equals(activityName)) && (executionState == null || execution.getState().equals(executionState))) {
                result.add(execution);
            }
            if (execution.getExecutions() == null) continue;
            result.addAll(this.searchActiveExecutions(execution, activityName, executionState));
        }
        return result;
    }
}

