/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.impl;

import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.connector.core.Connector;
import org.ow2.bonita.connector.core.Filter;
import org.ow2.bonita.connector.core.Mapper;
import org.ow2.bonita.connector.core.RoleResolver;
import org.ow2.bonita.definition.activity.ConnectorExecutor;
import org.ow2.bonita.facade.def.InternalProcessDefinition;
import org.ow2.bonita.facade.def.majorElement.ProcessDefinition;
import org.ow2.bonita.facade.exception.ActivityNotFoundException;
import org.ow2.bonita.facade.exception.BonitaInternalException;
import org.ow2.bonita.facade.exception.IllegalTaskStateException;
import org.ow2.bonita.facade.exception.InstanceNotFoundException;
import org.ow2.bonita.facade.exception.ProcessNotFoundException;
import org.ow2.bonita.facade.exception.TaskNotFoundException;
import org.ow2.bonita.facade.exception.UncancellableInstanceException;
import org.ow2.bonita.facade.exception.UndeletableInstanceException;
import org.ow2.bonita.facade.exception.VariableNotFoundException;
import org.ow2.bonita.facade.impl.FacadeUtil;
import org.ow2.bonita.facade.internal.InternalRuntimeAPI;
import org.ow2.bonita.facade.runtime.AttachmentInstance;
import org.ow2.bonita.facade.runtime.Comment;
import org.ow2.bonita.facade.runtime.InitialAttachment;
import org.ow2.bonita.facade.runtime.InstanceState;
import org.ow2.bonita.facade.runtime.ProcessInstance;
import org.ow2.bonita.facade.runtime.impl.AttachmentInstanceImpl;
import org.ow2.bonita.facade.runtime.impl.CommentImpl;
import org.ow2.bonita.facade.runtime.impl.InternalActivityInstance;
import org.ow2.bonita.facade.runtime.impl.InternalProcessInstance;
import org.ow2.bonita.facade.uuid.ActivityDefinitionUUID;
import org.ow2.bonita.facade.uuid.ActivityInstanceUUID;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.runtime.ClassDataLoader;
import org.ow2.bonita.runtime.TaskManager;
import org.ow2.bonita.runtime.event.OutgoingEventInstance;
import org.ow2.bonita.runtime.model.Execution;
import org.ow2.bonita.services.Archiver;
import org.ow2.bonita.services.EventService;
import org.ow2.bonita.services.Querier;
import org.ow2.bonita.services.Recorder;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.EnvTool;
import org.ow2.bonita.util.ExceptionManager;
import org.ow2.bonita.util.GroovyException;
import org.ow2.bonita.util.GroovyUtil;
import org.ow2.bonita.util.Misc;
import org.ow2.bonita.util.ProcessUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuntimeAPIImpl
implements InternalRuntimeAPI {
    private static final Logger LOG = Logger.getLogger(RuntimeAPIImpl.class.getName());

    protected RuntimeAPIImpl() {
    }

    @Override
    public void enableEventsInFailure(ActivityInstanceUUID activityUUID) {
        EventService eventService = EnvTool.getEventService();
        eventService.enableEventsInFailureIncomingEvents(activityUUID);
    }

    @Override
    public void enableEventsInFailure(ProcessInstanceUUID instanceUUID, String activityName) {
        Set<InternalActivityInstance> activities = EnvTool.getAllQueriers().getActivityInstances(instanceUUID, activityName);
        for (InternalActivityInstance activity : activities) {
            this.enableEventsInFailure(activity.getUUID());
        }
    }

    @Override
    public void enablePermanentEventInFailure(ActivityDefinitionUUID activityUUID) {
        EventService eventService = EnvTool.getEventService();
        eventService.enablePermanentEventsInFailure(activityUUID);
    }

    @Override
    public ProcessInstanceUUID instantiateProcess(ProcessDefinitionUUID processUUID) throws ProcessNotFoundException {
        try {
            return this.instantiateProcess(processUUID, null, null);
        }
        catch (VariableNotFoundException e) {
            throw new BonitaRuntimeException(e);
        }
    }

    @Override
    public ProcessInstanceUUID instantiateProcess(ProcessDefinitionUUID processUUID, Map<String, Object> variables) throws ProcessNotFoundException, VariableNotFoundException {
        return this.instantiateProcess(processUUID, variables, null);
    }

    @Override
    public ProcessInstanceUUID instantiateProcess(ProcessDefinitionUUID processUUID, Map<String, Object> variables, Collection<InitialAttachment> attachments) throws ProcessNotFoundException, VariableNotFoundException {
        FacadeUtil.checkArgsNotNull(processUUID);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Starting a new instance of process : " + processUUID);
        }
        Execution rootExecution = ProcessUtil.createProcessInstance(processUUID, variables, attachments, null, null);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Started: " + rootExecution.getInstance());
        }
        rootExecution.getInstance().begin();
        return rootExecution.getInstance().getUUID();
    }

    @Override
    public void executeTask(ActivityInstanceUUID taskUUID, boolean assignTask) throws TaskNotFoundException, IllegalTaskStateException, RemoteException {
        this.startTask(taskUUID, assignTask);
        this.finishTask(taskUUID, assignTask);
    }

    @Override
    public void cancelProcessInstance(ProcessInstanceUUID instanceUUID) throws InstanceNotFoundException, UncancellableInstanceException {
        FacadeUtil.checkArgsNotNull(instanceUUID);
        InternalProcessInstance instance = FacadeUtil.getInstance(instanceUUID, null);
        if (instance == null) {
            throw new InstanceNotFoundException("bai_RAPII_1", instanceUUID);
        }
        if (instance == null || instance.getParentInstanceUUID() != null || !instance.getInstanceState().equals((Object)InstanceState.STARTED)) {
            throw new UncancellableInstanceException("bai_RAPII_2", instanceUUID, instance.getParentInstanceUUID(), instance.getInstanceState());
        }
        instance.cancel();
    }

    @Override
    public void cancelProcessInstances(Collection<ProcessInstanceUUID> instanceUUIDs) throws InstanceNotFoundException, UncancellableInstanceException {
        FacadeUtil.checkArgsNotNull(instanceUUIDs);
        for (ProcessInstanceUUID instanceUUID : instanceUUIDs) {
            this.cancelProcessInstance(instanceUUID);
        }
    }

    @Override
    public void deleteProcessInstances(Collection<ProcessInstanceUUID> instanceUUIDs) throws InstanceNotFoundException, UndeletableInstanceException {
        if (instanceUUIDs == null) {
            return;
        }
        for (ProcessInstanceUUID instanceUUID : instanceUUIDs) {
            this.deleteProcessInstance(instanceUUID);
        }
    }

    @Override
    public void deleteProcessInstance(ProcessInstanceUUID instanceUUID) throws InstanceNotFoundException, UndeletableInstanceException {
        boolean inJournal;
        FacadeUtil.checkArgsNotNull(instanceUUID);
        Querier allQueriers = EnvTool.getAllQueriers();
        Querier journal = EnvTool.getJournalQueriers();
        Querier history = EnvTool.getHistoryQueriers();
        InternalProcessInstance processInst = journal.getProcessInstance(instanceUUID);
        boolean inHistory = false;
        boolean bl = inJournal = processInst != null;
        if (!inJournal) {
            processInst = history.getProcessInstance(instanceUUID);
            boolean bl2 = inHistory = processInst != null;
        }
        if (processInst == null) {
            throw new InstanceNotFoundException("bai_RAPII_3", instanceUUID);
        }
        ProcessInstanceUUID parentInstanceUUID = processInst.getParentInstanceUUID();
        if (parentInstanceUUID != null && allQueriers.getProcessInstance(parentInstanceUUID) != null) {
            throw new UndeletableInstanceException("bai_RAPII_4", instanceUUID, parentInstanceUUID);
        }
        EnvTool.getLargeDataRepository().deleteData(Misc.getAttachmentCategories(instanceUUID));
        EnvTool.getUUIDService().disableProcess(processInst.getProcessDefinitionUUID());
        ProcessUtil.removeAllInstanceEvents(instanceUUID);
        if (inJournal) {
            Recorder recorder = EnvTool.getRecorder();
            recorder.remove(processInst);
        } else if (inHistory) {
            Archiver archiver = EnvTool.getArchiver();
            archiver.remove(processInst);
        }
        Set<ProcessInstanceUUID> children = processInst.getChildrenInstanceUUID();
        for (ProcessInstanceUUID child : children) {
            this.deleteProcessInstance(child);
        }
    }

    @Override
    public void deleteAllProcessInstances(Collection<ProcessDefinitionUUID> processUUIDs) throws ProcessNotFoundException, UndeletableInstanceException {
        FacadeUtil.checkArgsNotNull(processUUIDs);
        for (ProcessDefinitionUUID processUUID : processUUIDs) {
            this.deleteAllProcessInstances(processUUID);
        }
    }

    @Override
    public void deleteAllProcessInstances(ProcessDefinitionUUID processUUID) throws ProcessNotFoundException, UndeletableInstanceException {
        FacadeUtil.checkArgsNotNull(processUUID);
        Querier querier = EnvTool.getAllQueriers();
        InternalProcessDefinition process = querier.getProcess(processUUID);
        if (process == null) {
            throw new ProcessNotFoundException("bai_RAPII_5", processUUID);
        }
        this.deleteAllProcessInstances(process);
    }

    public void deleteAllProcessInstances(ProcessDefinition process) throws ProcessNotFoundException, UndeletableInstanceException {
        FacadeUtil.checkArgsNotNull(process);
        ProcessDefinitionUUID processUUID = process.getUUID();
        Querier querier = EnvTool.getAllQueriers();
        Set<InternalProcessInstance> instances = querier.getProcessInstances(processUUID);
        for (InternalProcessInstance instance : instances) {
            if (instance.getParentInstanceUUID() != null) continue;
            try {
                this.deleteProcessInstance(instance.getUUID());
            }
            catch (InstanceNotFoundException e) {
                String message = ExceptionManager.getInstance().getFullMessage("bai_RAPII_6", new Object[0]);
                throw new BonitaInternalException(message, e);
            }
        }
        instances = querier.getProcessInstances(processUUID);
        if (instances != null && !instances.isEmpty()) {
            ProcessInstance first = instances.iterator().next();
            throw new UndeletableInstanceException("bai_RAPII_7", first.getUUID(), first.getParentInstanceUUID());
        }
    }

    @Override
    public void startTask(ActivityInstanceUUID taskUUID, boolean assignTask) throws TaskNotFoundException, IllegalTaskStateException {
        FacadeUtil.checkArgsNotNull(taskUUID);
        TaskManager.start(taskUUID, assignTask);
    }

    @Override
    public void startActivity(ActivityInstanceUUID activityUUID) throws ActivityNotFoundException, RemoteException {
    }

    @Override
    public void finishTask(ActivityInstanceUUID taskUUID, boolean assignTask) throws TaskNotFoundException, IllegalTaskStateException {
        FacadeUtil.checkArgsNotNull(taskUUID);
        TaskManager.finish(taskUUID, assignTask);
    }

    @Override
    public void suspendTask(ActivityInstanceUUID taskUUID, boolean assignTask) throws TaskNotFoundException, IllegalTaskStateException {
        FacadeUtil.checkArgsNotNull(taskUUID);
        TaskManager.suspend(taskUUID, assignTask);
    }

    @Override
    public void resumeTask(ActivityInstanceUUID taskUUID, boolean taskAssign) throws TaskNotFoundException, IllegalTaskStateException {
        FacadeUtil.checkArgsNotNull(taskUUID);
        TaskManager.resume(taskUUID, taskAssign);
    }

    @Override
    public void assignTask(ActivityInstanceUUID taskUUID) throws TaskNotFoundException {
        FacadeUtil.checkArgsNotNull(taskUUID);
        TaskManager.assign(taskUUID);
    }

    @Override
    public void assignTask(ActivityInstanceUUID taskUUID, String userId) throws TaskNotFoundException {
        FacadeUtil.checkArgsNotNull(taskUUID, userId);
        TaskManager.assign(taskUUID, userId);
    }

    @Override
    public void assignTask(ActivityInstanceUUID taskUUID, Set<String> candidates) throws TaskNotFoundException {
        FacadeUtil.checkArgsNotNull(taskUUID, candidates);
        TaskManager.assign(taskUUID, candidates);
    }

    @Override
    public void unassignTask(ActivityInstanceUUID taskUUID) throws TaskNotFoundException {
        FacadeUtil.checkArgsNotNull(taskUUID);
        TaskManager.unAssign(taskUUID);
    }

    private void setProcessInstanceVariable(ProcessInstance instance, ProcessInstanceUUID instanceUUID, String variableId, Object variableValue) throws InstanceNotFoundException, VariableNotFoundException {
        if (instance == null) {
            throw new InstanceNotFoundException("bai_RAPII_20", instanceUUID);
        }
        if (!instance.getLastKnownVariableValues().containsKey(variableId)) {
            throw new VariableNotFoundException("bai_RAPII_21", instanceUUID, variableId);
        }
    }

    @Override
    public void setProcessInstanceVariable(ProcessInstanceUUID instanceUUID, String variableId, Object variableValue) throws InstanceNotFoundException, VariableNotFoundException {
        InternalProcessInstance instance = EnvTool.getJournalQueriers().getProcessInstance(instanceUUID);
        this.setProcessInstanceVariable(instance, instanceUUID, variableId, variableValue);
        EnvTool.getRecorder().recordInstanceVariableUpdated(variableId, variableValue, instance.getUUID(), EnvTool.getUserId());
    }

    @Override
    public void setActivityInstanceVariable(ActivityInstanceUUID activityUUID, String variableId, Object variableValue) throws ActivityNotFoundException, VariableNotFoundException {
        InternalActivityInstance activity = EnvTool.getJournalQueriers().getActivityInstance(activityUUID);
        if (activity == null) {
            throw new ActivityNotFoundException("bai_RAPII_22", activityUUID);
        }
        ProcessInstanceUUID instanceUUID = activity.getProcessInstanceUUID();
        String activityId = activity.getActivityName();
        Recorder recorder = EnvTool.getRecorder();
        if (!activity.getLastKnownVariableValues().containsKey(variableId)) {
            throw new VariableNotFoundException("bai_RAPII_24", instanceUUID, activityId, variableId);
        }
        recorder.recordActivityVariableUpdated(variableId, variableValue, activity.getUUID(), EnvTool.getUserId());
    }

    @Override
    public void setVariable(ActivityInstanceUUID activityUUID, String variableId, Object variableValue) throws ActivityNotFoundException, VariableNotFoundException {
        try {
            this.setActivityInstanceVariable(activityUUID, variableId, variableValue);
        }
        catch (VariableNotFoundException e) {
            InternalActivityInstance activity = EnvTool.getAllQueriers().getActivityInstance(activityUUID);
            if (activity == null) {
                throw new ActivityNotFoundException("bai_RAPII_25", activityUUID);
            }
            try {
                this.setProcessInstanceVariable(activity.getProcessInstanceUUID(), variableId, variableValue);
            }
            catch (InstanceNotFoundException e1) {
                Misc.unreachableStatement();
            }
        }
    }

    @Override
    public void addComment(ProcessInstanceUUID instanceUUID, String message, String userId) throws InstanceNotFoundException {
        CommentImpl comment = new CommentImpl(userId, message, instanceUUID);
        this.addComment(comment, instanceUUID);
    }

    @Override
    public void addComment(ActivityInstanceUUID activityUUID, String message, String userId) throws ActivityNotFoundException, InstanceNotFoundException {
        InternalActivityInstance activity = EnvTool.getJournalQueriers().getActivityInstance(activityUUID);
        if (activity == null) {
            throw new ActivityNotFoundException("bai_RAPII_28", activityUUID);
        }
        CommentImpl comment = new CommentImpl(userId, message, activityUUID);
        this.addComment(comment, activityUUID.getProcessInstanceUUID());
    }

    private void addComment(Comment comment, ProcessInstanceUUID instanceUUID) throws InstanceNotFoundException {
        InternalProcessInstance instance = EnvTool.getJournalQueriers().getProcessInstance(instanceUUID);
        if (instance == null) {
            throw new InstanceNotFoundException("bai_RAPII_27", instanceUUID);
        }
        instance.addComment(comment);
    }

    @Override
    @Deprecated
    public void addComment(ProcessInstanceUUID instanceUUID, ActivityInstanceUUID activityUUID, String message, String userId) throws InstanceNotFoundException, ActivityNotFoundException {
        InternalActivityInstance activity;
        InternalProcessInstance instance = EnvTool.getJournalQueriers().getProcessInstance(instanceUUID);
        if (instance == null) {
            throw new InstanceNotFoundException("bai_RAPII_27", instanceUUID);
        }
        if (activityUUID != null && (activity = EnvTool.getAllQueriers().getActivityInstance(activityUUID)) == null) {
            throw new ActivityNotFoundException("bai_RAPII_28", activityUUID);
        }
        CommentImpl comment = activityUUID != null ? new CommentImpl(userId, message, activityUUID) : new CommentImpl(userId, message, instanceUUID);
        instance.addComment(comment);
    }

    @Override
    public void addProcessMetaData(ProcessDefinitionUUID uuid, String key, String value) throws ProcessNotFoundException, RemoteException {
        FacadeUtil.checkArgsNotNull(uuid, key, value);
        InternalProcessDefinition process = EnvTool.getAllQueriers().getProcess(uuid);
        if (process == null) {
            throw new ProcessNotFoundException("bai_RAPII_29", uuid);
        }
        process.addAMetaData(key, value);
    }

    @Override
    public void deleteProcessMetaData(ProcessDefinitionUUID uuid, String key) throws ProcessNotFoundException, RemoteException {
        FacadeUtil.checkArgsNotNull(uuid, key);
        InternalProcessDefinition process = EnvTool.getAllQueriers().getProcess(uuid);
        if (process == null) {
            throw new ProcessNotFoundException("bai_RAPII_29", uuid);
        }
        process.deleteAMetaData(key);
    }

    @Override
    public Object evaluateGroovyExpression(String expression, ProcessInstanceUUID instanceUUID, boolean propagate) throws InstanceNotFoundException, GroovyException {
        return this.evaluateGroovyExpression(expression, instanceUUID, null, propagate);
    }

    @Override
    public Object evaluateGroovyExpression(String expression, ProcessInstanceUUID instanceUUID, Map<String, Object> context, boolean propagate) throws InstanceNotFoundException, GroovyException {
        return GroovyUtil.evaluate(expression, context, instanceUUID, propagate);
    }

    @Override
    public Object evaluateGroovyExpression(String expression, ActivityInstanceUUID activityUUID, boolean useActivityScope, boolean propagate) throws InstanceNotFoundException, ActivityNotFoundException, GroovyException {
        return this.evaluateGroovyExpression(expression, activityUUID, null, useActivityScope, propagate);
    }

    @Override
    public Object evaluateGroovyExpression(String expression, ActivityInstanceUUID activityUUID, Map<String, Object> context, boolean useActivityScope, boolean propagate) throws InstanceNotFoundException, ActivityNotFoundException, GroovyException {
        return GroovyUtil.evaluate(expression, context, activityUUID, useActivityScope, propagate);
    }

    @Override
    public Object evaluateGroovyExpression(String expression, ProcessDefinitionUUID processDefinitionUUID) throws ProcessNotFoundException, GroovyException, RemoteException {
        return this.evaluateGroovyExpression(expression, processDefinitionUUID, null);
    }

    @Override
    public Object evaluateGroovyExpression(String expression, ProcessDefinitionUUID processDefinitionUUID, Map<String, Object> context) throws ProcessNotFoundException, GroovyException, RemoteException {
        return GroovyUtil.evaluate(expression, context, processDefinitionUUID, false);
    }

    @Override
    public void addAttachment(ProcessInstanceUUID instanceUUID, String name, String fileName, byte[] value) throws RemoteException {
        AttachmentInstanceImpl attachmentInstance = new AttachmentInstanceImpl(name, instanceUUID, EnvTool.getUserId(), new Date());
        attachmentInstance.setFileName(fileName);
        InternalProcessInstance instance = EnvTool.getJournalQueriers().getProcessInstance(instanceUUID);
        ProcessUtil.addAttachment(instance, attachmentInstance, value);
    }

    @Override
    public void addAttachment(ProcessInstanceUUID instanceUUID, String name, String label, String description, String fileName, Map<String, String> metadata, byte[] value) throws RemoteException {
        AttachmentInstanceImpl attachmentInstance = new AttachmentInstanceImpl(name, instanceUUID, EnvTool.getUserId(), new Date());
        attachmentInstance.setDescription(description);
        attachmentInstance.setFileName(fileName);
        attachmentInstance.setLabel(label);
        attachmentInstance.setMetaData(metadata);
        InternalProcessInstance instance = EnvTool.getJournalQueriers().getProcessInstance(instanceUUID);
        ProcessUtil.addAttachment(instance, attachmentInstance, value);
    }

    @Override
    public void addAttachments(Map<AttachmentInstance, byte[]> attachments) throws RemoteException {
        if (attachments != null) {
            for (AttachmentInstance attachmentInstance : attachments.keySet()) {
                InternalProcessInstance instance = EnvTool.getJournalQueriers().getProcessInstance(attachmentInstance.getProcessInstanceUUID());
                ProcessUtil.addAttachment(instance, new AttachmentInstanceImpl(attachmentInstance), attachments.get(attachmentInstance));
            }
        }
    }

    @Override
    public void setActivityInstancePriority(ActivityInstanceUUID activityInstanceUUID, int priority) throws ActivityNotFoundException {
        InternalActivityInstance activity = EnvTool.getJournalQueriers().getActivityInstance(activityInstanceUUID);
        if (activity == null) {
            throw new ActivityNotFoundException("bai_RAPII_22", activityInstanceUUID);
        }
        ProcessInstanceUUID instanceUUID = activity.getProcessInstanceUUID();
        Execution execution = EnvTool.getJournalQueriers().getExecutionOnActivity(instanceUUID, activityInstanceUUID);
        if (execution == null) {
            throw new ActivityNotFoundException("bai_RAPII_23", activityInstanceUUID);
        }
        Recorder recorder = EnvTool.getRecorder();
        recorder.recordActivityPriorityUpdated(activityInstanceUUID, priority);
    }

    @Override
    public void deleteEvents(String eventName, String toProcessName, String toActivityName, ActivityInstanceUUID actiivtyUUID) throws RemoteException {
        EventService eventService = EnvTool.getEventService();
        Set<OutgoingEventInstance> events = eventService.getOutgoingEvents(eventName, toProcessName, toActivityName, actiivtyUUID);
        if (events != null) {
            for (OutgoingEventInstance event : events) {
                eventService.removeEvent(event);
            }
        }
    }

    @Override
    public Map<String, Object> executeConnector(String connectorClassName, Map<String, Object[]> parameters, ProcessDefinitionUUID definitionUUID) throws RemoteException, Exception {
        return this.executeConnector(connectorClassName, parameters, definitionUUID, null);
    }

    @Override
    public Map<String, Object> executeConnector(String connectorClassName, Map<String, Object[]> parameters) throws RemoteException, Exception {
        return this.executeConnector(connectorClassName, parameters, null, null);
    }

    @Override
    public Map<String, Object> executeConnector(String connectorClassName, Map<String, Object[]> parameters, ClassLoader classLoader) throws RemoteException, Exception {
        return this.executeConnector(connectorClassName, parameters, null, classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> executeConnector(String connectorClassName, Map<String, Object[]> parameters, ProcessDefinitionUUID definitionUUID, ClassLoader classLoader) throws Exception {
        ClassLoader baseClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Connector connector = null;
            if (classLoader == null) {
                connector = (Connector)ClassDataLoader.getInstance(definitionUUID, connectorClassName);
            } else {
                Thread.currentThread().setContextClassLoader(classLoader);
                Class<?> objectClass = Class.forName(connectorClassName, true, classLoader);
                connector = (Connector)objectClass.newInstance();
            }
            if (connector instanceof Mapper) {
                throw new IllegalAccessException(connectorClassName + " is a instance of RoleResolver or Filter");
            }
            Map<String, Object> map = ConnectorExecutor.executeConnector(connector, parameters);
            return map;
        }
        finally {
            Thread.currentThread().setContextClassLoader(baseClassLoader);
        }
    }

    @Override
    public Set<String> executeFilter(String connectorClassName, Map<String, Object[]> parameters, Set<String> members) throws RemoteException, Exception {
        return this.executeFilter(connectorClassName, parameters, members, null, null);
    }

    @Override
    public Set<String> executeFilter(String connectorClassName, Map<String, Object[]> parameters, Set<String> members, ProcessDefinitionUUID definitionUUID) throws RemoteException, Exception {
        return this.executeFilter(connectorClassName, parameters, members, definitionUUID, null);
    }

    @Override
    public Set<String> executeFilter(String connectorClassName, Map<String, Object[]> parameters, Set<String> members, ClassLoader classLoader) throws RemoteException, Exception {
        return this.executeFilter(connectorClassName, parameters, members, null, classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> executeFilter(String connectorClassName, Map<String, Object[]> parameters, Set<String> members, ProcessDefinitionUUID definitionUUID, ClassLoader classLoader) throws Exception {
        FacadeUtil.checkArgsNotNull(members);
        ClassLoader baseClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Filter connector = null;
            if (classLoader == null) {
                connector = (Filter)ClassDataLoader.getInstance(definitionUUID, connectorClassName);
            } else {
                Thread.currentThread().setContextClassLoader(classLoader);
                Class<?> objectClass = Class.forName(connectorClassName, true, classLoader);
                connector = (Filter)objectClass.newInstance();
            }
            Set<String> set = ConnectorExecutor.executeFilter(connector, parameters, members);
            return set;
        }
        finally {
            Thread.currentThread().setContextClassLoader(baseClassLoader);
        }
    }

    @Override
    public Set<String> executeRoleResolver(String connectorClassName, Map<String, Object[]> parameters, ProcessDefinitionUUID definitionUUID) throws RemoteException, Exception {
        return this.executeRoleResolver(connectorClassName, parameters, definitionUUID, null);
    }

    @Override
    public Set<String> executeRoleResolver(String connectorClassName, Map<String, Object[]> parameters) throws RemoteException, Exception {
        return this.executeRoleResolver(connectorClassName, parameters, null, null);
    }

    @Override
    public Set<String> executeRoleResolver(String connectorClassName, Map<String, Object[]> parameters, ClassLoader classLoader) throws RemoteException, Exception {
        return this.executeRoleResolver(connectorClassName, parameters, null, classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> executeRoleResolver(String connectorClassName, Map<String, Object[]> parameters, ProcessDefinitionUUID definitionUUID, ClassLoader classLoader) throws Exception {
        ClassLoader baseClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            RoleResolver connector = null;
            if (classLoader == null) {
                connector = (RoleResolver)ClassDataLoader.getInstance(definitionUUID, connectorClassName);
            } else {
                Thread.currentThread().setContextClassLoader(classLoader);
                Class<?> objectClass = Class.forName(connectorClassName, true, classLoader);
                connector = (RoleResolver)objectClass.newInstance();
            }
            Set<String> set = ConnectorExecutor.executeRoleResolver(connector, parameters);
            return set;
        }
        finally {
            Thread.currentThread().setContextClassLoader(baseClassLoader);
        }
    }
}

