/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.ow2.bonita.facade.exception.BonitaInternalException;
import org.ow2.bonita.facade.internal.InternalAPIAccessor;
import org.ow2.bonita.facade.internal.InternalQueryAPIAccessor;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.ExceptionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StandardInternalAPIAccessorFactory {
    private static final Object LOCK = new Object();
    private static Properties mapping = null;

    private StandardInternalAPIAccessorFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getMapping() throws IOException {
        Object object = LOCK;
        synchronized (object) {
            if (mapping == null) {
                Properties map = new Properties();
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                InputStream inStream = cl.getResourceAsStream("org.ow2.bonita.api.implementations");
                if (inStream != null) {
                    try {
                        map.load(inStream);
                    }
                    finally {
                        inStream.close();
                    }
                } else {
                    String message = ExceptionManager.getInstance().getFullMessage("baa_SIAPIAF_1", new Object[0]);
                    throw new BonitaInternalException(message);
                }
                mapping = map;
            }
        }
        return mapping;
    }

    private static <T> T getObject(Class<T> clazz) {
        try {
            String implementationClassName = StandardInternalAPIAccessorFactory.getMapping().getProperty(clazz.getName());
            if (implementationClassName == null) {
                String message = ExceptionManager.getInstance().getFullMessage("baa_SIAPIAF_2", clazz.getName());
                throw new BonitaInternalException(message);
            }
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class<?> implClass = cl.loadClass(implementationClassName);
            return (T)implClass.newInstance();
        }
        catch (Exception e) {
            throw new BonitaRuntimeException(e);
        }
    }

    public static InternalAPIAccessor getStandardInternalAPIAccessor() {
        return StandardInternalAPIAccessorFactory.getObject(InternalAPIAccessor.class);
    }

    public static InternalQueryAPIAccessor getStandardInternalQueryAPIAccessor() {
        return StandardInternalAPIAccessorFactory.getObject(InternalQueryAPIAccessor.class);
    }
}

