/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.impl;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ow2.bonita.facade.impl.FacadeUtil;
import org.ow2.bonita.facade.internal.InternalWebAPI;
import org.ow2.bonita.facade.runtime.Label;
import org.ow2.bonita.facade.runtime.WebTemporaryToken;
import org.ow2.bonita.facade.runtime.impl.CaseImpl;
import org.ow2.bonita.facade.runtime.impl.InternalProcessInstance;
import org.ow2.bonita.facade.runtime.impl.LabelImpl;
import org.ow2.bonita.facade.runtime.impl.WebTemporaryTokenImpl;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.light.LightProcessInstance;
import org.ow2.bonita.light.impl.LightProcessInstanceImpl;
import org.ow2.bonita.services.Querier;
import org.ow2.bonita.services.WebService;
import org.ow2.bonita.services.WebTokenManagementService;
import org.ow2.bonita.util.EnvTool;
import org.ow2.bonita.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebAPIImpl
implements InternalWebAPI {
    protected WebAPIImpl() {
    }

    @Override
    public void deletePhantomCases() throws RemoteException {
        Set<ProcessInstanceUUID> webCases = EnvTool.getWebService().getAllCases();
        Set<ProcessInstanceUUID> runtimeCases = EnvTool.getAllQueriers().getParentInstancesUUIDs();
        webCases.removeAll(runtimeCases);
        if (!webCases.isEmpty()) {
            EnvTool.getWebService().deleteCases(webCases);
        }
    }

    @Override
    public void addLabel(String labelName, String ownerName, String editableCSSStyleName, String readonlyCSSStyleName, String previewCSSStyleName, boolean isVisible, boolean hasToBeDisplayed, String iconCSSStyle, Set<ProcessInstanceUUID> caseList, int displayOrder, boolean isSystemLabel) throws RemoteException {
        WebService webService = EnvTool.getWebService();
        LabelImpl label = new LabelImpl(labelName, ownerName, editableCSSStyleName, readonlyCSSStyleName, previewCSSStyleName, isVisible, hasToBeDisplayed, iconCSSStyle, displayOrder, isSystemLabel);
        webService.addLabel(label);
        this.addCasesToLabel(ownerName, labelName, caseList);
    }

    @Override
    public void removeLabel(String ownerName, String labelName) throws RemoteException {
        EnvTool.getWebService().removeLabel(ownerName, labelName);
    }

    @Override
    public void removeCasesFromLabel(String ownerName, String labelName, Set<ProcessInstanceUUID> caseList) {
        Set<InternalProcessInstance> instances = EnvTool.getAllQueriers().getProcessInstances((Collection<ProcessInstanceUUID>)caseList);
        WebService webService = EnvTool.getWebService();
        for (InternalProcessInstance parentNewOrUpdatedInstance : instances) {
            webService.removeCase(parentNewOrUpdatedInstance.getUUID(), ownerName, labelName);
        }
        EnvTool.getWebService().removeCasesFromLabel(ownerName, labelName, caseList);
    }

    @Override
    public void deleteAllCases() throws RemoteException {
        EnvTool.getWebService().deleteAllCases();
    }

    @Override
    public void updateLabelCSS(String ownerName, String labelName, String aEditableCSSStyle, String aPreviewCSSStyle, String aReadOnlyCSSStyle) throws RemoteException {
        LabelImpl label = EnvTool.getWebService().getLabel(ownerName, labelName);
        label.setEditableCSSStyleName(aEditableCSSStyle);
        label.setPreviewCSSStyleName(aPreviewCSSStyle);
        label.setReadonlyCSSStyleName(aReadOnlyCSSStyle);
    }

    @Override
    public void addCasesToLabel(String ownerName, String labelName, Set<ProcessInstanceUUID> caseList) {
        Set<InternalProcessInstance> instances = EnvTool.getAllQueriers().getProcessInstances((Collection<ProcessInstanceUUID>)caseList);
        WebService webService = EnvTool.getWebService();
        for (InternalProcessInstance internalProcessInstance : instances) {
            if (webService.getCase(internalProcessInstance.getUUID(), ownerName, labelName) != null) continue;
            webService.addCase(new CaseImpl(internalProcessInstance.getUUID(), ownerName, labelName));
        }
    }

    @Override
    public Label getLabel(String ownerName, String labelName) throws RemoteException {
        LabelImpl label = EnvTool.getWebService().getLabel(ownerName, labelName);
        if (label == null) {
            return null;
        }
        return new LabelImpl(label);
    }

    @Override
    public Set<Label> getLabels(String ownerName) throws RemoteException {
        Set<LabelImpl> labels = EnvTool.getWebService().getLabels(ownerName);
        return this.getCopy(labels);
    }

    @Override
    public List<Label> getSystemLabels(String ownerName) throws RemoteException {
        List<LabelImpl> labels = EnvTool.getWebService().getSystemLabels(ownerName);
        return this.getCopy(labels);
    }

    @Override
    public List<Label> getUserCustomLabels(String ownerName) throws RemoteException {
        List<LabelImpl> labels = EnvTool.getWebService().getUserCustomLabels(ownerName);
        return this.getCopy(labels);
    }

    @Override
    public Set<Label> getCaseLabels(String ownerName, ProcessInstanceUUID case_) {
        Set<LabelImpl> labels = EnvTool.getWebService().getCaseLabels(ownerName, case_);
        return this.getCopy(labels);
    }

    @Override
    public Map<ProcessInstanceUUID, Set<Label>> getCasesLabels(String ownerName, Set<ProcessInstanceUUID> cases) {
        if (cases == null || cases.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<ProcessInstanceUUID, Set<Label>> result = new HashMap<ProcessInstanceUUID, Set<Label>>();
        for (ProcessInstanceUUID case_ : cases) {
            result.put(case_, this.getCaseLabels(ownerName, case_));
        }
        return result;
    }

    @Override
    public void removeAllCasesFromLabels(Set<ProcessInstanceUUID> caseList) {
        if (caseList != null && !caseList.isEmpty()) {
            WebService webService = EnvTool.getWebService();
            for (ProcessInstanceUUID case_ : caseList) {
                webService.removeCase(case_);
            }
        }
    }

    @Override
    public Set<ProcessInstanceUUID> getCases(String ownerName, Set<String> labels) throws RemoteException {
        if (ownerName != null && labels != null && !labels.isEmpty()) {
            WebService webService = EnvTool.getWebService();
            Set<ProcessInstanceUUID> cases = webService.getCases(ownerName, labels);
            if (cases == null) {
                return Collections.emptySet();
            }
            HashSet<ProcessInstanceUUID> result = new HashSet<ProcessInstanceUUID>();
            for (ProcessInstanceUUID instanceUUID : cases) {
                result.add(new ProcessInstanceUUID(instanceUUID));
            }
            return result;
        }
        return Collections.emptySet();
    }

    @Override
    public List<LightProcessInstance> getLightProcessInstances(String ownerName, Set<String> theLabelsName, int fromIndex, int pageSize) throws RemoteException {
        if (ownerName == null || theLabelsName == null || theLabelsName.isEmpty()) {
            return Collections.emptyList();
        }
        List<ProcessInstanceUUID> caseUUIDs = EnvTool.getWebService().getLabelsCaseUUIDs(ownerName, theLabelsName, fromIndex, pageSize);
        Set<InternalProcessInstance> internalList = EnvTool.getAllQueriers().getProcessInstances(caseUUIDs);
        if (internalList == null || internalList.isEmpty()) {
            return Collections.emptyList();
        }
        Comparator<InternalProcessInstance> comparator = new Comparator<InternalProcessInstance>(){

            @Override
            public int compare(InternalProcessInstance o1, InternalProcessInstance o2) {
                return o2.getLastUpdate().compareTo(o1.getLastUpdate());
            }
        };
        ArrayList<InternalProcessInstance> sortedInstances = new ArrayList<InternalProcessInstance>(internalList);
        Collections.sort(sortedInstances, comparator);
        ArrayList<LightProcessInstance> list = new ArrayList<LightProcessInstance>();
        for (InternalProcessInstance internalProcessInstance : sortedInstances) {
            list.add(new LightProcessInstanceImpl(internalProcessInstance));
        }
        return list;
    }

    @Override
    public boolean setLabelsOnNewOrUpdatedCases(String ownerName, Set<String> labelsToApplyOnNewOrUpdated, Set<String> labelsToRemoveOnNewOrUpdated, String labelToApplyOnMyCases) {
        CaseImpl case_;
        boolean continue_ = false;
        WebService webService = EnvTool.getWebService();
        Set<InternalProcessInstance> processInstances = EnvTool.getAllQueriers().getUpdatedWebProcessInstances(ownerName, 0, 2500);
        HashSet<InternalProcessInstance> newOrUpdatedProcessInstances = new HashSet<InternalProcessInstance>();
        HashSet<InternalProcessInstance> myProcessInstances = new HashSet<InternalProcessInstance>();
        for (InternalProcessInstance internalProcessInstance : processInstances) {
            Set<String> involvedUsers = internalProcessInstance.getInvolvedUsers();
            if (!involvedUsers.contains(ownerName)) {
                myProcessInstances.add(internalProcessInstance);
                continue;
            }
            newOrUpdatedProcessInstances.add(internalProcessInstance);
            if (!internalProcessInstance.getStartedBy().equals(ownerName)) continue;
            myProcessInstances.add(internalProcessInstance);
        }
        HashSet<ProcessInstanceUUID> caseUUIDs = new HashSet<ProcessInstanceUUID>();
        HashSet<ProcessInstanceUUID> myCaseUUIDs = new HashSet<ProcessInstanceUUID>();
        Set<Object> casesToRemove = Collections.emptySet();
        HashSet<CaseImpl> casesToAdd = new HashSet<CaseImpl>();
        Querier allQueriers = EnvTool.getAllQueriers();
        HashMap<ProcessInstanceUUID, Date> rootInstancesUpdates = new HashMap<ProcessInstanceUUID, Date>();
        Set<Object> cases = Collections.emptySet();
        if (newOrUpdatedProcessInstances != null && !newOrUpdatedProcessInstances.isEmpty()) {
            if (newOrUpdatedProcessInstances.size() >= 2500) {
                continue_ = true;
            }
            for (InternalProcessInstance instance : newOrUpdatedProcessInstances) {
                ProcessInstanceUUID processInstanceUUID = instance.getRootInstanceUUID();
                caseUUIDs.add(processInstanceUUID);
                if (labelsToApplyOnNewOrUpdated != null) {
                    for (String user : instance.getInvolvedUsers()) {
                        for (String label : labelsToApplyOnNewOrUpdated) {
                            case_ = new CaseImpl(processInstanceUUID, user, label);
                            casesToAdd.add(case_);
                        }
                    }
                }
                rootInstancesUpdates.put(processInstanceUUID, instance.getLastUpdate());
            }
            cases = webService.getCases(caseUUIDs);
            if (labelsToApplyOnNewOrUpdated != null) {
                casesToAdd.removeAll(webService.getLabelCases(ownerName, labelsToApplyOnNewOrUpdated, caseUUIDs));
            }
            if (labelsToRemoveOnNewOrUpdated != null && !labelsToRemoveOnNewOrUpdated.isEmpty()) {
                casesToRemove = webService.getLabelCases(ownerName, labelsToRemoveOnNewOrUpdated, caseUUIDs);
            }
        }
        HashMap<ProcessInstanceUUID, Date> myRootInstancesUpdates = new HashMap<ProcessInstanceUUID, Date>();
        if (myProcessInstances != null && !myProcessInstances.isEmpty()) {
            if (myProcessInstances.size() >= 2500) {
                continue_ = true;
            }
            HashMap<ProcessInstanceUUID, InternalProcessInstance> myRootInstances = new HashMap<ProcessInstanceUUID, InternalProcessInstance>();
            HashSet<ProcessInstanceUUID> hashSet = new HashSet<ProcessInstanceUUID>();
            if (labelToApplyOnMyCases != null) {
                for (InternalProcessInstance instance : myProcessInstances) {
                    ProcessInstanceUUID rootInstanceUUID = instance.getRootInstanceUUID();
                    if (rootInstanceUUID.equals(instance.getUUID())) {
                        myRootInstances.put(rootInstanceUUID, instance);
                    } else {
                        hashSet.add(rootInstanceUUID);
                    }
                    myCaseUUIDs.add(rootInstanceUUID);
                    myRootInstancesUpdates.put(rootInstanceUUID, instance.getLastUpdate());
                }
                if (!hashSet.isEmpty()) {
                    Set<InternalProcessInstance> retrievedRootInstances = allQueriers.getProcessInstances((Collection<ProcessInstanceUUID>)hashSet);
                    for (InternalProcessInstance rootInstance : retrievedRootInstances) {
                        myRootInstances.put(rootInstance.getUUID(), rootInstance);
                    }
                }
                Set myProcessInstanceUUIDs = Collections.emptySet();
                Set<CaseImpl> myCasesImpl = webService.getLabelCases(ownerName, this.getSetFromString(labelToApplyOnMyCases), myCaseUUIDs);
                if (myCasesImpl != null) {
                    myProcessInstanceUUIDs = new HashSet();
                    for (CaseImpl caseImpl : myCasesImpl) {
                        myProcessInstanceUUIDs.add(caseImpl.getUUID());
                    }
                }
                for (InternalProcessInstance rootInstance : myRootInstances.values()) {
                    if (myProcessInstanceUUIDs.contains(rootInstance.getUUID())) continue;
                    case_ = new CaseImpl(rootInstance.getUUID(), rootInstance.getStartedBy(), labelToApplyOnMyCases);
                    casesToAdd.add(case_);
                }
            }
        }
        if (!casesToRemove.isEmpty() || !casesToAdd.isEmpty()) {
            for (CaseImpl caseImpl : casesToRemove) {
                webService.removeCase(caseImpl);
            }
            for (CaseImpl caseImpl : casesToAdd) {
                Date updateDate = (Date)rootInstancesUpdates.get(caseImpl.getUUID());
                if (updateDate == null) {
                    updateDate = (Date)myRootInstancesUpdates.get(caseImpl.getUUID());
                }
                caseImpl.setLastUpdate(updateDate.getTime());
                webService.addCase(caseImpl);
            }
            for (InternalProcessInstance internalProcessInstance : newOrUpdatedProcessInstances) {
                internalProcessInstance.setUserXPRead(internalProcessInstance.getLastUpdate());
            }
            for (InternalProcessInstance internalProcessInstance : myProcessInstances) {
                internalProcessInstance.setUserXPRead(internalProcessInstance.getLastUpdate());
            }
            cases.removeAll(casesToRemove);
            for (CaseImpl caseImpl : cases) {
                caseImpl.setLastUpdate(((Date)rootInstancesUpdates.get(caseImpl.getUUID())).getTime());
            }
        }
        return continue_;
    }

    private Set<String> getSetFromString(String s) {
        HashSet<String> result = new HashSet<String>();
        result.add(s);
        return result;
    }

    @Override
    public Set<Label> getLabels(String ownerName, Set<String> labelsName) throws RemoteException {
        Set<LabelImpl> labels = EnvTool.getWebService().getLabels(ownerName, labelsName);
        return this.getCopy(labels);
    }

    private Set<Label> getCopy(Set<LabelImpl> labels) {
        if (labels == null || labels.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Label> result = new HashSet<Label>();
        for (LabelImpl label : labels) {
            result.add(new LabelImpl(label));
        }
        return result;
    }

    private List<Label> getCopy(List<LabelImpl> labels) {
        if (labels == null || labels.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Label> result = new ArrayList<Label>();
        for (LabelImpl label : labels) {
            result.add(new LabelImpl(label));
        }
        return result;
    }

    @Override
    public void removeLabels(String ownerName, Collection<String> labelNames) throws RemoteException {
        for (String labelName : labelNames) {
            this.removeLabel(ownerName, labelName);
        }
    }

    @Override
    public void updateLabelName(String ownerName, String labelName, String newName) throws RemoteException {
        EnvTool.getWebService().updateLabelName(ownerName, labelName, newName);
    }

    @Override
    public void updateLabelVisibility(String ownerName, String labelName, boolean isVisible) {
        LabelImpl label = EnvTool.getWebService().getLabel(ownerName, labelName);
        label.setVisible(isVisible);
    }

    @Override
    public void updateLabelVisibility(String ownerName, Map<String, Boolean> labelvisibilities) throws RemoteException {
        for (Map.Entry<String, Boolean> labelVisibility : labelvisibilities.entrySet()) {
            this.updateLabelVisibility(ownerName, labelVisibility.getKey(), labelVisibility.getValue());
        }
    }

    @Override
    public Map<String, Integer> getCasesNumber(String ownerName, Collection<String> labelNames, int limit) throws RemoteException {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        WebService webService = EnvTool.getWebService();
        for (String label : labelNames) {
            int number = 0;
            if (limit <= 2500) {
                Set<CaseImpl> cases = webService.getCases(ownerName, label, limit + 1);
                number = cases.size();
                if (number > limit) {
                    number = -limit;
                }
            } else {
                number = webService.getCasesNumber(ownerName, label);
            }
            result.put(label, number);
        }
        return result;
    }

    @Override
    public Map<String, Integer> getCasesNumber(String ownerName, Collection<String> labelNames) throws RemoteException {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        WebService webService = EnvTool.getWebService();
        for (String label : labelNames) {
            int number = webService.getCasesNumber(ownerName, label);
            result.put(label, number);
        }
        return result;
    }

    @Override
    public Map<String, Integer> getCasesNumber(String ownerName, String labelName, Collection<String> labelNames, int limit) throws RemoteException {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        WebService webService = EnvTool.getWebService();
        for (String label : labelNames) {
            int number = 0;
            if (limit <= 2500) {
                Set<CaseImpl> cases = webService.getCases(ownerName, labelName, label, limit + 1);
                number = cases.size();
                if (number > limit) {
                    number = -limit;
                }
            } else {
                number = webService.getCasesNumber(ownerName, labelName, label);
            }
            result.put(label, number);
        }
        return result;
    }

    @Override
    public String generateTemporaryToken(String identityKey) throws RemoteException {
        FacadeUtil.checkArgsNotNull(identityKey);
        if (identityKey.length() == 0) {
            throw new IllegalArgumentException();
        }
        WebTokenManagementService webTokenManagementService = EnvTool.getWebTokenManagementService();
        String tokenKey = Misc.getUniqueId("");
        long expirationDate = new Date().getTime() + 3600000L;
        WebTemporaryTokenImpl temporaryToken = new WebTemporaryTokenImpl(tokenKey, expirationDate, identityKey);
        webTokenManagementService.addTemporaryToken(temporaryToken);
        return temporaryToken.getToken();
    }

    @Override
    public String getIdentityKeyFromTemporaryToken(String token) throws RemoteException {
        WebTokenManagementService webTokenManagementService = EnvTool.getWebTokenManagementService();
        WebTemporaryToken temporaryToken = webTokenManagementService.getToken(token);
        if (temporaryToken == null) {
            return null;
        }
        webTokenManagementService.deleteToken((WebTemporaryTokenImpl)temporaryToken);
        Set<WebTemporaryToken> expiredTokens = webTokenManagementService.getExpiredTokens();
        for (WebTemporaryToken expiredToken : expiredTokens) {
            webTokenManagementService.deleteToken((WebTemporaryTokenImpl)expiredToken);
        }
        return temporaryToken.getIdentityKey();
    }
}

