/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.interceptor;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import org.ow2.bonita.facade.exception.BonitaInternalException;
import org.ow2.bonita.facade.interceptor.InterceptorUtil;
import org.ow2.bonita.util.ExceptionManager;

public class ClientAPIInterceptor
implements InvocationHandler {
    private final Object api;
    private final String queryList;

    public ClientAPIInterceptor(Object api) {
        this.api = api;
        this.queryList = null;
    }

    public ClientAPIInterceptor(Object api, String queryList) {
        this.api = api;
        this.queryList = queryList;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            Object[] methodsArgs;
            Class<?>[] params;
            if (this.queryList != null) {
                int i;
                Class<?>[] p = method.getParameterTypes();
                if (p != null) {
                    params = new Class[p.length + 1];
                    for (i = 0; i < p.length; ++i) {
                        params[i] = p[i];
                    }
                    params[p.length] = String.class;
                } else {
                    params = new Class[]{String.class};
                }
                if (args != null) {
                    methodsArgs = new Object[args.length + 1];
                    for (i = 0; i < args.length; ++i) {
                        methodsArgs[i] = args[i];
                    }
                    methodsArgs[args.length] = this.queryList;
                } else {
                    methodsArgs = new Object[]{this.queryList};
                }
            } else {
                params = method.getParameterTypes();
                methodsArgs = args;
            }
            Method m = this.api.getClass().getMethod(method.getName(), params);
            return m.invoke(this.api, methodsArgs);
        }
        catch (Exception e) {
            if (e instanceof InvocationTargetException) {
                Throwable invocationExceptionCause = e.getCause();
                if (invocationExceptionCause instanceof RemoteException) {
                    RemoteException remoteException = (RemoteException)invocationExceptionCause;
                    Throwable remoteCause = this.getRemoteCause(remoteException);
                    InterceptorUtil.manageInvokeExceptionCause(method, remoteCause);
                } else {
                    throw invocationExceptionCause;
                }
            }
            String message = ExceptionManager.getInstance().getFullMessage("baa_CAPII_1", e);
            throw new BonitaInternalException(message, e);
        }
    }

    private Throwable getRemoteCause(RemoteException e) {
        Throwable t = e;
        while (t instanceof RemoteException) {
            t = ((Throwable)t).getCause();
        }
        return t;
    }
}

