/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.interceptor;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.interceptor.InvocationContext;
import org.ow2.bonita.facade.impl.StandardInternalAPIAccessorImpl;
import org.ow2.bonita.facade.interceptor.InterceptorUtil;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.ExceptionManager;

public class EJB3Interceptor {
    private static final int SUFFIX_LENGTH = "Bean".length();

    private Object getStandaloneAPI(String className) {
        try {
            StandardInternalAPIAccessorImpl apiAccessor = new StandardInternalAPIAccessorImpl();
            Method m = apiAccessor.getClass().getMethod("get" + className, new Class[0]);
            return m.invoke((Object)apiAccessor, new Object[0]);
        }
        catch (Exception e) {
            String message = ExceptionManager.getInstance().getFullMessage("baie_EJB3I_1", new Object[0]);
            throw new BonitaRuntimeException(message, e);
        }
    }

    public Object performInterception(InvocationContext ctx) throws Exception {
        String className = ctx.getTarget().getClass().getSimpleName();
        className = className.substring(0, className.length() - SUFFIX_LENGTH);
        Object standaloneAPI = this.getStandaloneAPI(className);
        Method implMethod = null;
        try {
            implMethod = standaloneAPI.getClass().getMethod(ctx.getMethod().getName(), ctx.getMethod().getParameterTypes());
            return implMethod.invoke(standaloneAPI, ctx.getParameters());
        }
        catch (Exception e) {
            if (e instanceof InvocationTargetException && implMethod != null) {
                Throwable invocationExceptionCause = e.getCause();
                InterceptorUtil.manageInvokeExceptionCause(implMethod, invocationExceptionCause);
            }
            String message = ExceptionManager.getInstance().getFullMessage("baie_EJB3I_2", ctx.getMethod().getName());
            throw new BonitaRuntimeException(message, e);
        }
    }
}

