/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.internal;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.ow2.bonita.facade.def.element.BusinessArchive;
import org.ow2.bonita.facade.def.majorElement.ProcessDefinition;
import org.ow2.bonita.facade.exception.DeploymentException;
import org.ow2.bonita.facade.exception.PrivilegeNotFoundException;
import org.ow2.bonita.facade.exception.ProcessNotFoundException;
import org.ow2.bonita.facade.exception.RuleAlreadyExistsException;
import org.ow2.bonita.facade.exception.RuleNotFoundException;
import org.ow2.bonita.facade.exception.UndeletableInstanceException;
import org.ow2.bonita.facade.exception.UndeletableProcessException;
import org.ow2.bonita.facade.exception.UserNotFoundException;
import org.ow2.bonita.facade.privilege.PrivilegePolicy;
import org.ow2.bonita.facade.privilege.Rule;
import org.ow2.bonita.facade.uuid.AbstractUUID;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface InternalManagementAPI
extends Remote {
    public ProcessDefinition deploy(BusinessArchive var1) throws DeploymentException, RemoteException;

    public void deployJar(String var1, byte[] var2) throws DeploymentException, RemoteException;

    public void removeJar(String var1) throws DeploymentException, RemoteException;

    public void deleteProcess(ProcessDefinitionUUID var1) throws ProcessNotFoundException, UndeletableProcessException, UndeletableInstanceException, RemoteException;

    public void deleteAllProcesses() throws UndeletableProcessException, UndeletableInstanceException, RemoteException;

    public String getLoggedUser() throws RemoteException;

    public Set<String> getAvailableJars() throws RemoteException;

    public void addMetaData(String var1, String var2) throws RemoteException;

    public String getMetaData(String var1) throws RemoteException;

    public void deleteMetaData(String var1) throws RemoteException;

    public void disable(ProcessDefinitionUUID var1) throws DeploymentException, RemoteException;

    public void enable(ProcessDefinitionUUID var1) throws DeploymentException, RemoteException;

    public void archive(ProcessDefinitionUUID var1) throws DeploymentException, RemoteException;

    public void disable(Collection<ProcessDefinitionUUID> var1) throws DeploymentException, RemoteException;

    public void enable(Collection<ProcessDefinitionUUID> var1) throws DeploymentException, RemoteException;

    public void archive(Collection<ProcessDefinitionUUID> var1) throws DeploymentException, RemoteException;

    public void delete(Collection<ProcessDefinitionUUID> var1) throws DeploymentException, ProcessNotFoundException, UndeletableProcessException, UndeletableInstanceException, RemoteException;

    public boolean isUserAdmin(String var1) throws UserNotFoundException, RemoteException;

    public boolean checkUserCredentials(String var1, String var2) throws RemoteException;

    public <E extends AbstractUUID> Rule createRule(String var1, String var2, String var3, Set<E> var4, Rule.RuleType var5) throws RuleAlreadyExistsException, RemoteException;

    public void deleteRule(String var1) throws RuleNotFoundException, RemoteException;

    public <E extends AbstractUUID> void addExceptionsToRule(String var1, Set<E> var2) throws RuleNotFoundException, RemoteException;

    public <E extends AbstractUUID> void removeExceptionsFromRule(String var1, Set<E> var2) throws RuleNotFoundException, RemoteException;

    public void updateRule(String var1, Rule var2) throws RuleNotFoundException, RemoteException;

    public Rule getRule(String var1) throws RuleNotFoundException, RemoteException;

    public Set<Rule> getRules() throws RemoteException;

    public List<Rule> getRules(Rule.RuleType var1, int var2, int var3) throws RemoteException;

    public Set<Rule> getRules(Set<String> var1) throws RemoteException, RuleNotFoundException;

    public void applyRulesToEntity(String var1, Set<String> var2) throws RuleNotFoundException, RemoteException;

    public void removeRulesFromEntity(String var1, Set<String> var2) throws RuleNotFoundException, PrivilegeNotFoundException, RemoteException;

    public void applySameRulesToOtherEntities(String var1, Set<String> var2) throws PrivilegeNotFoundException, RemoteException;

    public Set<Rule> getApplicableRules(String var1, Rule.RuleType var2) throws RemoteException;

    public Set<Rule> getAllApplicableRules(String var1) throws RemoteException;

    public PrivilegePolicy getDefaultPolicy() throws RemoteException;

    public void setDefaultPolicy(PrivilegePolicy var1, boolean var2) throws RemoteException;

    public long getNumberOfRules(Rule.RuleType var1) throws RemoteException;
}

