/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.privilege.impl;

import java.util.HashSet;
import java.util.Set;
import org.ow2.bonita.facade.privilege.Rule;
import org.ow2.bonita.facade.privilege.impl.RuleImpl;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProcessRuleImpl
extends RuleImpl {
    private static final long serialVersionUID = -1096929781625084230L;

    public ProcessRuleImpl(Rule.RuleType ruleType) {
        super(ruleType);
    }

    public ProcessRuleImpl(String name, String label, String description, Set<ProcessDefinitionUUID> items, Rule.RuleType ruleType) {
        super(name, label, description, items, ruleType);
    }

    public ProcessRuleImpl(ProcessRuleImpl src) {
        super(src);
    }

    public void addProcesses(Set<ProcessDefinitionUUID> items) {
        Misc.checkArgsNotNull(items);
        HashSet<String> processes = new HashSet<String>();
        for (ProcessDefinitionUUID processDefinitionUUID : items) {
            processes.add(processDefinitionUUID.getValue());
        }
        this.addItems(processes);
    }

    public void removeProcesses(Set<ProcessDefinitionUUID> items) {
        Misc.checkArgsNotNull(items);
        HashSet<String> processes = new HashSet<String>();
        for (ProcessDefinitionUUID processDefinitionUUID : items) {
            processes.add(processDefinitionUUID.getValue());
        }
        this.removeExceptions(processes);
    }

    public void setProcesses(Set<ProcessDefinitionUUID> processes) {
        this.removeExceptions(this.getItems());
        this.addProcesses(processes);
    }

    public Set<ProcessDefinitionUUID> getProcesses() {
        HashSet<ProcessDefinitionUUID> processUUIDs = new HashSet<ProcessDefinitionUUID>();
        for (String definitionUUID : this.getItems()) {
            processUUIDs.add(new ProcessDefinitionUUID(definitionUUID));
        }
        return processUUIDs;
    }
}

