/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.privilege.impl;

import java.util.HashSet;
import java.util.Set;
import org.ow2.bonita.facade.def.majorElement.impl.DescriptionElementImpl;
import org.ow2.bonita.facade.privilege.Rule;
import org.ow2.bonita.facade.uuid.AbstractUUID;
import org.ow2.bonita.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RuleImpl
extends DescriptionElementImpl
implements Rule {
    private static final long serialVersionUID = -5403223858809095337L;
    protected long dbid;
    protected String name;
    protected String label;
    protected Set<String> exceptions;
    protected String type;
    protected Set<String> entities;

    protected RuleImpl(Rule.RuleType type) {
        this.type = type.name();
    }

    protected RuleImpl(String name, String label, String description, Set<? extends AbstractUUID> items, Rule.RuleType type) {
        Misc.checkArgsNotNull(new Object[]{name, items, type});
        this.name = name;
        this.label = label;
        if (items != null) {
            this.exceptions = new HashSet<String>();
            for (AbstractUUID abstractUUID : items) {
                this.exceptions.add(abstractUUID.getValue());
            }
        } else {
            this.exceptions = null;
        }
        this.type = type.name();
        this.setDescription(description);
    }

    protected RuleImpl(Rule src) {
        super(src);
        this.dbid = src.getId();
        this.name = src.getName();
        this.label = src.getLabel();
        this.exceptions = new HashSet<String>();
        Set<String> items_ = src.getItems();
        for (String item : items_) {
            this.exceptions.add(item);
        }
        this.type = src.getType().name();
        this.entities = new HashSet<String>();
        Set<String> entities_ = src.getEntities();
        for (String entity : entities_) {
            this.entities.add(entity);
        }
    }

    @Override
    public long getId() {
        return this.dbid;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public Set<String> getItems() {
        if (this.exceptions == null) {
            this.exceptions = new HashSet<String>();
        }
        return this.exceptions;
    }

    @Override
    public Rule.RuleType getType() {
        return Rule.RuleType.valueOf(this.type);
    }

    public void addItems(Set<String> items) {
        Misc.checkArgsNotNull(items);
        if (this.exceptions == null) {
            this.exceptions = new HashSet<String>();
        }
        this.exceptions.addAll(items);
    }

    public void removeExceptions(Set<String> exceptions) {
        Misc.checkArgsNotNull(exceptions);
        if (this.exceptions != null && !this.exceptions.isEmpty()) {
            this.exceptions.removeAll(exceptions);
        }
    }

    public void setExceptions(Set<String> exceptions) {
        Misc.checkArgsNotNull(exceptions);
        this.exceptions = exceptions;
    }

    @Override
    public Set<String> getEntities() {
        if (this.entities == null) {
            this.entities = new HashSet<String>();
        }
        return this.entities;
    }

    public void addEntitiess(Set<String> entities) {
        Misc.checkArgsNotNull(entities);
        if (this.entities == null) {
            this.entities = new HashSet<String>();
        }
        this.entities.addAll(entities);
    }

    public void removeEntities(Set<String> entities) {
        Misc.checkArgsNotNull(entities);
        if (this.entities != null && !this.entities.isEmpty()) {
            this.entities.removeAll(entities);
        }
    }

    public String toString() {
        return this.name + " - " + this.label + " - " + this.type;
    }
}

