/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.runtime.command;

import java.util.HashSet;
import java.util.Set;
import org.ow2.bonita.env.Environment;
import org.ow2.bonita.facade.QueryRuntimeAPI;
import org.ow2.bonita.facade.RuntimeAPI;
import org.ow2.bonita.facade.WebAPI;
import org.ow2.bonita.facade.impl.StandardAPIAccessorImpl;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.light.LightProcessInstance;
import org.ow2.bonita.util.Command;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebDeleteAllProcessInstancesCommand
implements Command<Void> {
    private static final long serialVersionUID = 1L;
    private Set<ProcessDefinitionUUID> processUUIDs;

    public WebDeleteAllProcessInstancesCommand(Set<ProcessDefinitionUUID> processUUIDs) {
        this.processUUIDs = processUUIDs;
    }

    @Override
    public Void execute(Environment environment) throws Exception {
        StandardAPIAccessorImpl accessor = new StandardAPIAccessorImpl();
        if (this.processUUIDs != null && !this.processUUIDs.isEmpty()) {
            QueryRuntimeAPI queryRuntimeAPI = accessor.getQueryRuntimeAPI();
            Set<LightProcessInstance> instances = queryRuntimeAPI.getLightWeightProcessInstances(this.processUUIDs);
            WebAPI webAPI = accessor.getWebAPI();
            HashSet<ProcessInstanceUUID> uuids = new HashSet<ProcessInstanceUUID>();
            for (LightProcessInstance instance : instances) {
                uuids.add(instance.getUUID());
                if (uuids.size() != 100) continue;
                webAPI.removeAllCasesFromLabels(uuids);
                uuids.clear();
            }
            webAPI.removeAllCasesFromLabels(uuids);
            RuntimeAPI runtimeAPI = accessor.getRuntimeAPI();
            runtimeAPI.deleteAllProcessInstances(this.processUUIDs);
        }
        return null;
    }
}

