/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.runtime.command;

import java.util.HashSet;
import java.util.Set;
import org.ow2.bonita.env.Environment;
import org.ow2.bonita.facade.WebAPI;
import org.ow2.bonita.facade.impl.StandardAPIAccessorImpl;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.util.Command;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebDeleteProcessInstancesCommand
implements Command<Void> {
    private static final long serialVersionUID = 1L;
    private Set<ProcessInstanceUUID> instancesUUIDs;

    public WebDeleteProcessInstancesCommand(Set<ProcessInstanceUUID> instancesUUIDs) {
        this.instancesUUIDs = instancesUUIDs;
    }

    @Override
    public Void execute(Environment environment) throws Exception {
        StandardAPIAccessorImpl accessor = new StandardAPIAccessorImpl();
        if (this.instancesUUIDs != null && !this.instancesUUIDs.isEmpty()) {
            WebAPI webAPI = accessor.getWebAPI();
            HashSet<ProcessInstanceUUID> uuids = new HashSet<ProcessInstanceUUID>();
            for (ProcessInstanceUUID uuid : this.instancesUUIDs) {
                uuids.add(uuid);
                if (uuids.size() != 100) continue;
                webAPI.removeAllCasesFromLabels(uuids);
                uuids.clear();
            }
            webAPI.removeAllCasesFromLabels(uuids);
            accessor.getRuntimeAPI().deleteProcessInstances(this.instancesUUIDs);
        }
        return null;
    }
}

