/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.runtime.command;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.env.Environment;
import org.ow2.bonita.facade.RuntimeAPI;
import org.ow2.bonita.facade.impl.StandardAPIAccessorImpl;
import org.ow2.bonita.facade.runtime.InitialAttachment;
import org.ow2.bonita.facade.uuid.ActivityInstanceUUID;
import org.ow2.bonita.util.Command;
import org.ow2.bonita.util.GroovyException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebExecuteTask
implements Command<Void> {
    private static final long serialVersionUID = -183964674754241232L;
    private static final Logger LOG = Logger.getLogger(WebExecuteTask.class.getName());
    private ActivityInstanceUUID taskUUID;
    private Map<String, Object> processVariables;
    private Map<String, Object> activityVariables;
    private Set<InitialAttachment> attachments;
    private List<String> scriptsToExecute;
    private Map<String, Object> scriptContext;

    public WebExecuteTask(ActivityInstanceUUID taskUUID, Map<String, Object> processVariables, Map<String, Object> activityVariables, Set<InitialAttachment> attachments, List<String> scriptsToExecute, Map<String, Object> scriptContext) {
        this.taskUUID = taskUUID;
        this.processVariables = processVariables;
        this.activityVariables = activityVariables;
        this.attachments = attachments;
        this.scriptsToExecute = scriptsToExecute;
        this.scriptContext = scriptContext;
    }

    @Override
    public Void execute(Environment environment) throws Exception {
        StandardAPIAccessorImpl accessor = new StandardAPIAccessorImpl();
        RuntimeAPI runtimeAPI = accessor.getRuntimeAPI();
        runtimeAPI.startTask(this.taskUUID, true);
        if (this.processVariables != null) {
            for (Map.Entry<String, Object> entry : this.processVariables.entrySet()) {
                runtimeAPI.setProcessInstanceVariable(this.taskUUID.getProcessInstanceUUID(), entry.getKey(), entry.getValue());
            }
        }
        if (this.activityVariables != null) {
            for (Map.Entry entry : this.activityVariables.entrySet()) {
                runtimeAPI.setActivityInstanceVariable(this.taskUUID, (String)entry.getKey(), entry.getValue());
            }
        }
        if (this.attachments != null) {
            for (InitialAttachment initialAttachment : this.attachments) {
                runtimeAPI.addAttachment(this.taskUUID.getProcessInstanceUUID(), initialAttachment.getName(), initialAttachment.getLabel(), initialAttachment.getDescription(), initialAttachment.getFileName(), initialAttachment.getMetaData(), initialAttachment.getContent());
            }
        }
        if (this.scriptsToExecute != null) {
            for (String string : this.scriptsToExecute) {
                try {
                    runtimeAPI.evaluateGroovyExpression(string, this.taskUUID, this.scriptContext, false, true);
                }
                catch (GroovyException e) {
                    if (!LOG.isLoggable(Level.SEVERE)) continue;
                    LOG.log(Level.SEVERE, "Error while executing action. unable to evaluate the groovy expression", e);
                }
            }
        }
        runtimeAPI.finishTask(this.taskUUID, true);
        return null;
    }
}

