/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.runtime.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.ow2.bonita.env.Environment;
import org.ow2.bonita.facade.ManagementAPI;
import org.ow2.bonita.facade.QueryDefinitionAPI;
import org.ow2.bonita.facade.def.majorElement.ProcessDefinition;
import org.ow2.bonita.facade.privilege.PrivilegePolicy;
import org.ow2.bonita.facade.privilege.Rule;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.light.LightProcessDefinition;
import org.ow2.bonita.util.AccessorUtil;
import org.ow2.bonita.util.Command;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebGetStartableProcessesCommand
implements Command<Set<LightProcessDefinition>> {
    private static final long serialVersionUID = 1L;
    private ArrayList<String> entities;

    public WebGetStartableProcessesCommand(String ... entities) {
        this.entities = new ArrayList<String>(Arrays.asList(entities));
    }

    @Override
    public Set<LightProcessDefinition> execute(Environment environment) throws Exception {
        ManagementAPI managementAPI = AccessorUtil.getManagementAPI();
        QueryDefinitionAPI queryDefinitionAPI = AccessorUtil.getQueryDefinitionAPI("journalQueryList");
        Set<Object> applicableRules = new HashSet();
        HashSet<String> exceptions = new HashSet<String>();
        for (String entityID : this.entities) {
            applicableRules = managementAPI.getApplicableRules(entityID, Rule.RuleType.PROCESS_START);
            for (Rule rule : applicableRules) {
                exceptions.addAll(rule.getItems());
            }
        }
        HashSet<ProcessDefinitionUUID> processUUIDs = new HashSet<ProcessDefinitionUUID>();
        for (String processUUID : exceptions) {
            processUUIDs.add(new ProcessDefinitionUUID(processUUID));
        }
        PrivilegePolicy currentPolicy = managementAPI.getDefaultPolicy();
        switch (currentPolicy) {
            case ALLOW_BY_DEFAULT: {
                if (processUUIDs != null && !processUUIDs.isEmpty()) {
                    List<LightProcessDefinition> tempResult = queryDefinitionAPI.getAllLightProcessesExcept(processUUIDs, 0, queryDefinitionAPI.getNumberOfProcesses());
                    HashSet<LightProcessDefinition> hashSet = new HashSet<LightProcessDefinition>();
                    for (LightProcessDefinition lightProcessDefinition : tempResult) {
                        if (lightProcessDefinition.getState() != ProcessDefinition.ProcessState.ENABLED) continue;
                        hashSet.add(lightProcessDefinition);
                    }
                    return hashSet;
                }
                return queryDefinitionAPI.getLightProcesses(ProcessDefinition.ProcessState.ENABLED);
            }
            case DENY_BY_DEFAULT: {
                if (processUUIDs.size() > 0) {
                    Set<LightProcessDefinition> tempResult2 = queryDefinitionAPI.getLightProcesses(processUUIDs);
                    if (tempResult2 == null || tempResult2.isEmpty()) {
                        return Collections.emptySet();
                    }
                    HashSet<LightProcessDefinition> hashSet = new HashSet<LightProcessDefinition>();
                    for (LightProcessDefinition lightProcessDefinition : tempResult2) {
                        if (lightProcessDefinition.getState() != ProcessDefinition.ProcessState.ENABLED) continue;
                        hashSet.add(lightProcessDefinition);
                    }
                    return hashSet;
                }
                return Collections.emptySet();
            }
        }
        throw new IllegalArgumentException();
    }
}

