/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.runtime.command;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.env.Environment;
import org.ow2.bonita.facade.RuntimeAPI;
import org.ow2.bonita.facade.impl.StandardAPIAccessorImpl;
import org.ow2.bonita.facade.runtime.InitialAttachment;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.util.Command;
import org.ow2.bonita.util.GroovyException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebInstantiateProcess
implements Command<ProcessInstanceUUID> {
    private static final long serialVersionUID = -6141460318114068466L;
    private static final Logger LOG = Logger.getLogger(WebInstantiateProcess.class.getName());
    private ProcessDefinitionUUID processDefinitionUUID;
    private Map<String, Object> processVariables;
    private Set<InitialAttachment> attachments;
    private List<String> scriptsToExecute;
    private Map<String, Object> scriptContext;

    public WebInstantiateProcess(ProcessDefinitionUUID processDefinitionUUID, Map<String, Object> processVariables, Set<InitialAttachment> attachments, List<String> scriptsToExecute, Map<String, Object> scriptContext) {
        this.processDefinitionUUID = processDefinitionUUID;
        this.processVariables = processVariables;
        this.attachments = attachments;
        this.scriptsToExecute = scriptsToExecute;
        this.scriptContext = scriptContext;
    }

    @Override
    public ProcessInstanceUUID execute(Environment environment) throws Exception {
        StandardAPIAccessorImpl accessor = new StandardAPIAccessorImpl();
        RuntimeAPI runtimeAPI = accessor.getRuntimeAPI();
        if (this.scriptsToExecute != null) {
            for (String scriptToExecute : this.scriptsToExecute) {
                try {
                    runtimeAPI.evaluateGroovyExpression(scriptToExecute, this.processDefinitionUUID, this.scriptContext);
                }
                catch (GroovyException e) {
                    if (!LOG.isLoggable(Level.SEVERE)) continue;
                    LOG.log(Level.SEVERE, "Error while executing action. unable to evaluate the groovy expression", e);
                }
            }
        }
        return runtimeAPI.instantiateProcess(this.processDefinitionUUID, this.processVariables, this.attachments);
    }
}

