/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.runtime.command;

import java.util.Set;
import org.ow2.bonita.env.Environment;
import org.ow2.bonita.facade.impl.StandardAPIAccessorImpl;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.util.Command;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebUpdateLabelCommand
implements Command<Void> {
    private static final long serialVersionUID = 1L;
    private String ownerName;
    private Set<String> labelsToAdd;
    private Set<String> labelsToRemove;
    private Set<ProcessInstanceUUID> instanceUUIDs;

    public WebUpdateLabelCommand(String ownerName, Set<String> labelsToAdd, Set<String> labelsToRemove, Set<ProcessInstanceUUID> instanceUUIDs) {
        this.ownerName = ownerName;
        this.labelsToAdd = labelsToAdd;
        this.labelsToRemove = labelsToRemove;
        this.instanceUUIDs = instanceUUIDs;
    }

    @Override
    public Void execute(Environment environment) throws Exception {
        for (String labelName : this.labelsToAdd) {
            this.addCasesToLabel(this.ownerName, labelName, this.instanceUUIDs);
        }
        for (String labelName : this.labelsToRemove) {
            this.removeCasesFromLabel(this.ownerName, labelName, this.instanceUUIDs);
        }
        return null;
    }

    private void addCasesToLabel(String ownerName, String labelName, Set<ProcessInstanceUUID> instanceUUIDs) {
        if (instanceUUIDs != null && !instanceUUIDs.isEmpty()) {
            StandardAPIAccessorImpl accessor = new StandardAPIAccessorImpl();
            accessor.getWebAPI().addCasesToLabel(ownerName, labelName, instanceUUIDs);
        }
    }

    public void removeCasesFromLabel(String ownerName, String labelName, Set<ProcessInstanceUUID> instanceUUIDs) {
        if (instanceUUIDs != null && !instanceUUIDs.isEmpty()) {
            StandardAPIAccessorImpl accessor = new StandardAPIAccessorImpl();
            accessor.getWebAPI().removeCasesFromLabel(ownerName, labelName, instanceUUIDs);
        }
    }
}

