/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.runtime.impl;

import org.ow2.bonita.facade.runtime.Case;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CaseImpl
implements Case,
Comparable<CaseImpl> {
    private static final long serialVersionUID = -1171017304614068835L;
    protected long dbid;
    protected ProcessInstanceUUID uuid;
    protected String ownerName;
    protected String labelName;
    protected long lastUpdate;
    protected String label;

    protected CaseImpl() {
    }

    public CaseImpl(ProcessInstanceUUID uuid, String ownerName, String labelName) {
        this.uuid = uuid;
        this.labelName = labelName;
        this.ownerName = ownerName;
        this.label = CaseImpl.buildLabel(this.ownerName, this.labelName);
    }

    public static String buildLabel(String ownerName, String labelName) {
        return ownerName + "--" + labelName;
    }

    @Override
    public long getLastUpdate() {
        return this.lastUpdate;
    }

    @Override
    public ProcessInstanceUUID getUUID() {
        return this.uuid;
    }

    @Override
    public String getLabelName() {
        return this.labelName;
    }

    @Override
    public String getOwnerName() {
        return this.ownerName;
    }

    public int hashCode() {
        return (this.uuid + this.labelName + this.ownerName).hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof CaseImpl)) {
            return false;
        }
        CaseImpl other = (CaseImpl)o;
        return other.getUUID().equals(this.getUUID()) && other.getLabelName().equals(this.labelName) && other.getOwnerName().equals(this.ownerName);
    }

    public void setLabelName(String labelName) {
        this.labelName = labelName;
        this.label = CaseImpl.buildLabel(this.ownerName, labelName);
    }

    public String toString() {
        return "CaseImpl [dbid=" + this.dbid + ", labelName=" + this.labelName + ", ownerName=" + this.ownerName + ", uuid=" + this.uuid + "]";
    }

    public void setLastUpdate(long lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public String getLabel() {
        return this.label;
    }

    @Override
    public int compareTo(CaseImpl c) {
        if (c == null) {
            return 1;
        }
        Long my = new Long(this.lastUpdate);
        Long other = new Long(c.getLastUpdate());
        return my.compareTo(other);
    }
}

