/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.runtime.impl;

import java.util.Date;
import org.ow2.bonita.facade.runtime.Comment;
import org.ow2.bonita.facade.uuid.ActivityInstanceUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.util.Misc;

public class CommentImpl
implements Comment {
    private static final long serialVersionUID = -2528309336083325621L;
    protected long dbid;
    protected String userId;
    protected long date;
    protected String message;
    protected ActivityInstanceUUID activityUUID;
    protected ProcessInstanceUUID instanceUUID;

    protected CommentImpl() {
    }

    public CommentImpl(String userId, String message, ProcessInstanceUUID instanceUUID) {
        this.userId = userId;
        this.message = message;
        this.instanceUUID = instanceUUID;
        this.date = System.currentTimeMillis();
    }

    public CommentImpl(String userId, String message, ActivityInstanceUUID activityUUID) {
        this.userId = userId;
        this.message = message;
        this.instanceUUID = activityUUID.getProcessInstanceUUID();
        this.activityUUID = activityUUID;
        this.date = System.currentTimeMillis();
    }

    public CommentImpl(Comment comment) {
        this.userId = comment.getUserId();
        this.message = comment.getMessage();
        this.date = Misc.getTime(comment.getDate());
        this.activityUUID = comment.getActivityUUID();
        this.instanceUUID = comment.getInstanceUUID();
    }

    public String getUserId() {
        return this.userId;
    }

    public Date getDate() {
        return Misc.getDate(this.date);
    }

    public String getMessage() {
        return this.message;
    }

    public ActivityInstanceUUID getActivityUUID() {
        return this.activityUUID;
    }

    public ProcessInstanceUUID getInstanceUUID() {
        return this.instanceUUID;
    }

    public void setInstanceUUID(ProcessInstanceUUID instanceUUID) {
        this.instanceUUID = instanceUUID;
    }
}

