/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.runtime.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.ow2.bonita.definition.activity.ConnectorExecutor;
import org.ow2.bonita.facade.def.InternalActivityDefinition;
import org.ow2.bonita.facade.def.InternalProcessDefinition;
import org.ow2.bonita.facade.def.element.HookDefinition;
import org.ow2.bonita.facade.runtime.ActivityInstance;
import org.ow2.bonita.facade.runtime.ActivityState;
import org.ow2.bonita.facade.runtime.InstanceState;
import org.ow2.bonita.facade.runtime.ProcessInstance;
import org.ow2.bonita.facade.runtime.VariableUpdate;
import org.ow2.bonita.facade.runtime.impl.InstanceStateUpdateImpl;
import org.ow2.bonita.facade.runtime.impl.InternalActivityInstance;
import org.ow2.bonita.facade.runtime.impl.ProcessInstanceImpl;
import org.ow2.bonita.facade.runtime.impl.VariableUpdateImpl;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.runtime.model.Execution;
import org.ow2.bonita.services.handlers.FinishedInstanceHandler;
import org.ow2.bonita.type.Variable;
import org.ow2.bonita.util.EnvTool;
import org.ow2.bonita.util.Misc;
import org.ow2.bonita.util.ProcessUtil;
import org.ow2.bonita.util.VariableUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalProcessInstance
extends ProcessInstanceImpl {
    private static final long serialVersionUID = 370138202886825855L;
    protected Execution rootExecution;
    protected long userXPRead = 0L;
    protected Map<String, String> transitionStates = new HashMap<String, String>();

    protected InternalProcessInstance() {
    }

    public InternalProcessInstance(ProcessInstanceUUID instanceUUID, InternalProcessDefinition process, ProcessInstanceUUID rootInstanceUUID) {
        super(process.getUUID(), instanceUUID, rootInstanceUUID);
        Map<String, InternalActivityDefinition> initialActivities = process.getInternalInitialActivities();
        if (initialActivities.size() == 1) {
            InternalActivityDefinition initial = initialActivities.values().iterator().next();
            this.rootExecution = new Execution("Instance_" + this.getUUID().toString(), process, this, initial, Execution.STATE_CREATED, null);
        } else {
            this.rootExecution = new Execution("Instance_" + this.getUUID().toString(), process, this, null, Execution.STATE_CREATED, null);
        }
    }

    public InternalProcessInstance(ProcessInstance src) {
        super(src);
        this.activities = new HashSet();
        for (ActivityInstance activity : src.getActivities()) {
            this.activities.add(new InternalActivityInstance(activity));
        }
        for (VariableUpdate varUpdate : this.getVariableUpdates()) {
            Serializable value = varUpdate.getValue();
            if (value == null) continue;
            ((VariableUpdateImpl)varUpdate).setValue(ProcessUtil.createVariable(src.getProcessDefinitionUUID(), varUpdate.getName(), value));
        }
        this.setVariables(src.getInitialVariableValues());
        for (ActivityInstance activity : this.getActivities()) {
            ((InternalActivityInstance)activity).setVariables(VariableUtil.createVariableMap(src.getProcessDefinitionUUID(), activity.getVariablesBeforeStarted()));
            for (VariableUpdate varUpdate : activity.getVariableUpdates()) {
                Serializable value = varUpdate.getValue();
                if (value == null) continue;
                ((VariableUpdateImpl)varUpdate).setValue(ProcessUtil.createVariable(src.getProcessDefinitionUUID(), varUpdate.getName(), value));
            }
        }
        if (src.getClass().equals(InternalProcessInstance.class)) {
            InternalProcessInstance other = (InternalProcessInstance)src;
            this.userXPRead = other.getUserXPRead();
        }
    }

    private void setVariables(Map<String, Object> variables) {
        this.variables = VariableUtil.createVariableMap(this.getProcessDefinitionUUID(), variables);
        this.clientVariables = null;
    }

    public void begin() {
        if (this.rootExecution.getNode() != null) {
            this.rootExecution.beginWithOneStartNode();
        } else {
            this.rootExecution.beginWithManyStartNodes();
        }
    }

    public void setParentInstanceUUID(ProcessInstanceUUID parentInstanceUUID) {
        this.parentInstanceUUID = parentInstanceUUID;
    }

    public void setInitialVaribales(Map<String, Variable> initialVariables) {
        this.variables = initialVariables;
    }

    public boolean isInstanceState(InstanceState state) {
        return this.getInstanceState().equals((Object)state);
    }

    public TransitionState getTransitionState(String transitionName) {
        if (!this.transitionStates.containsKey(transitionName)) {
            return null;
        }
        return TransitionState.valueOf(this.transitionStates.get(transitionName));
    }

    public void setTransitionState(String transitionName, TransitionState state) {
        this.transitionStates.put(transitionName, state.toString());
    }

    public void removeTransitionState(String transitionName) {
        this.transitionStates.remove(transitionName);
    }

    public Execution getRootExecution() {
        return this.rootExecution;
    }

    @Override
    public String toString() {
        String value = "Instance " + this.getUUID() + "(state:" + (Object)((Object)this.getInstanceState());
        if (this.getParentInstanceUUID() != null) {
            value = value + ", child of " + this.getParentInstanceUUID();
        }
        value = value + ")";
        return value;
    }

    public List<Execution> getExecOnNode(String nodeName) {
        return this.getExecOnNode(this.getRootExecution(), nodeName);
    }

    private List<Execution> getExecOnNode(Execution exec, String nodeName) {
        Misc.checkArgsNotNull(exec, nodeName);
        ArrayList<Execution> res = new ArrayList<Execution>();
        if ((exec.getExecutions() == null || exec.getExecutions().isEmpty()) && exec.getNode() != null && exec.getNode().getName().equals(nodeName)) {
            res.add(exec);
        }
        if (exec.getExecutions() != null) {
            for (Execution child : exec.getExecutions()) {
                res.addAll(this.getExecOnNode(child, nodeName));
            }
        }
        return res;
    }

    public void cancel() {
        ConnectorExecutor.executeConnectors(this.getRootExecution(), HookDefinition.Event.instanceOnCancel);
        this.getRootExecution().cancel();
        EnvTool.getRecorder().recordInstanceCancelled(this.getUUID(), EnvTool.getUserId());
        ProcessUtil.removeInternalInstanceEvents(this.getUUID());
        if (this.getParentInstanceUUID() == null) {
            this.finish();
        }
    }

    public void finish() {
        FinishedInstanceHandler handler = EnvTool.getFinishedInstanceHandler();
        handler.handleFinishedInstance(this);
    }

    public void setInstanceState(InstanceState newState, String userId) {
        this.updateLastUpdateDate();
        InstanceState oldState = this.getInstanceState();
        this.state = newState;
        if (this.getInstanceStateUpdates() == null) {
            this.instanceStateUpdates = new ArrayList();
        }
        Date newDate = new Date();
        this.getInstanceStateUpdates().add(new InstanceStateUpdateImpl(newDate, userId, oldState, newState));
        if (newState.equals((Object)InstanceState.STARTED)) {
            this.startedDate = newDate.getTime();
            this.startedBy = userId;
        } else {
            this.endedDate = newDate.getTime();
            this.endedBy = userId;
            if (this.activities != null) {
                for (ActivityInstance activity : this.activities) {
                    if (activity.getEndedDate() != null) continue;
                    ((InternalActivityInstance)activity).setActivityState(ActivityState.ABORTED, "SYSTEM");
                }
            }
        }
    }

    public void setUserXPRead(Date d) {
        this.userXPRead = d.getTime();
    }

    public long getUserXPRead() {
        return this.userXPRead;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TransitionState {
        READY,
        TAKEN,
        ABORTED;

    }
}

